/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.StyledElementImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tree Filling Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getAxisUsedAsAxisProvider <em>Axis Used As Axis Provider</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getPasteConfiguration <em>Paste Configuration</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getDepth <em>Depth</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getLabelProvider <em>Label Provider</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getLabelProviderContext <em>Label Provider Context</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxisconfiguration.impl.TreeFillingConfigurationImpl#getFilterRule <em>Filter Rule</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TreeFillingConfigurationImpl extends StyledElementImpl implements TreeFillingConfiguration {

	/**
	 * The default value of the '{@link #getDepth() <em>Depth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDepth()
	 * @generated
	 * @ordered
	 */
	protected static final int DEPTH_EDEFAULT = 0;

	/**
	 * The default value of the '{@link #getLabelProviderContext() <em>Label Provider Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelProviderContext()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_PROVIDER_CONTEXT_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TreeFillingConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IAxis getAxisUsedAsAxisProvider() {
		return (IAxis)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAxisUsedAsAxisProvider(IAxis newAxisUsedAsAxisProvider, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newAxisUsedAsAxisProvider, NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAxisUsedAsAxisProvider(IAxis newAxisUsedAsAxisProvider) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER, newAxisUsedAsAxisProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PasteEObjectConfiguration getPasteConfiguration() {
		return (PasteEObjectConfiguration)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PasteEObjectConfiguration basicGetPasteConfiguration() {
		return (PasteEObjectConfiguration)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPasteConfiguration(PasteEObjectConfiguration newPasteConfiguration) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION, newPasteConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getDepth() {
		return (Integer)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__DEPTH, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDepth(int newDepth) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__DEPTH, newDepth);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ILabelProviderConfiguration getLabelProvider() {
		return (ILabelProviderConfiguration)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILabelProviderConfiguration basicGetLabelProvider() {
		return (ILabelProviderConfiguration)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLabelProvider(ILabelProviderConfiguration newLabelProvider) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER, newLabelProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLabelProviderContext() {
		return (String)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLabelProviderContext(String newLabelProviderContext) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT, newLabelProviderContext);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IBooleanEObjectExpression getFilterRule() {
		return (IBooleanEObjectExpression)eDynamicGet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__FILTER_RULE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFilterRule(IBooleanEObjectExpression newFilterRule, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newFilterRule, NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFilterRule(IBooleanEObjectExpression newFilterRule) {
		eDynamicSet(NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE - ESTATIC_FEATURE_COUNT, NattableaxisconfigurationPackage.Literals.TREE_FILLING_CONFIGURATION__FILTER_RULE, newFilterRule);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER:
				return basicSetAxisUsedAsAxisProvider(null, msgs);
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE:
				return basicSetFilterRule(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER:
				return getAxisUsedAsAxisProvider();
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION:
				if (resolve) return getPasteConfiguration();
				return basicGetPasteConfiguration();
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH:
				return getDepth();
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER:
				if (resolve) return getLabelProvider();
				return basicGetLabelProvider();
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT:
				return getLabelProviderContext();
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE:
				return getFilterRule();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER:
				setAxisUsedAsAxisProvider((IAxis)newValue);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION:
				setPasteConfiguration((PasteEObjectConfiguration)newValue);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH:
				setDepth((Integer)newValue);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER:
				setLabelProvider((ILabelProviderConfiguration)newValue);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT:
				setLabelProviderContext((String)newValue);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE:
				setFilterRule((IBooleanEObjectExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER:
				setAxisUsedAsAxisProvider((IAxis)null);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION:
				setPasteConfiguration((PasteEObjectConfiguration)null);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH:
				setDepth(DEPTH_EDEFAULT);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER:
				setLabelProvider((ILabelProviderConfiguration)null);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT:
				setLabelProviderContext(LABEL_PROVIDER_CONTEXT_EDEFAULT);
				return;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE:
				setFilterRule((IBooleanEObjectExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__AXIS_USED_AS_AXIS_PROVIDER:
				return getAxisUsedAsAxisProvider() != null;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__PASTE_CONFIGURATION:
				return basicGetPasteConfiguration() != null;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__DEPTH:
				return getDepth() != DEPTH_EDEFAULT;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER:
				return basicGetLabelProvider() != null;
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__LABEL_PROVIDER_CONTEXT:
				return LABEL_PROVIDER_CONTEXT_EDEFAULT == null ? getLabelProviderContext() != null : !LABEL_PROVIDER_CONTEXT_EDEFAULT.equals(getLabelProviderContext());
			case NattableaxisconfigurationPackage.TREE_FILLING_CONFIGURATION__FILTER_RULE:
				return getFilterRule() != null;
		}
		return super.eIsSet(featureID);
	}
} // TreeFillingConfigurationImpl
