/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.EObjectAxisWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EObject Axis Wrapper</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl.EObjectAxisWrapperImpl#getElement <em>Element</em>}</li>
 * </ul>
 *
 * @generated not
 */
public class EObjectAxisWrapperImpl extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl implements EObjectAxisWrapper {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EObjectAxisWrapperImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablecellPackage.Literals.EOBJECT_AXIS_WRAPPER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Decrease the generated ESTATIC_FEATURE_COUNT from 1 to 0 because the inherited
	 * EModelElement.eAnnotations feature is implemented dynamically, too.
	 * <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected static final int ESTATIC_FEATURE_COUNT = 0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return ESTATIC_FEATURE_COUNT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getElement() {
		return (EObject) eDynamicGet(NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.EOBJECT_AXIS_WRAPPER__ELEMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetElement() {
		return (EObject) eDynamicGet(NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.EOBJECT_AXIS_WRAPPER__ELEMENT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setElement(EObject newElement) {
		eDynamicSet(NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.EOBJECT_AXIS_WRAPPER__ELEMENT, newElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT:
			if (resolve) {
				return getElement();
			}
			return basicGetElement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT:
			setElement((EObject) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT:
			setElement((EObject) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablecellPackage.EOBJECT_AXIS_WRAPPER__ELEMENT:
			return basicGetElement() != null;
		}
		return super.eIsSet(featureID);
	}
} // EObjectAxisWrapperImpl
