/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.CellTextAlignment;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.CellTextStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Cell Text Style</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.CellTextStyleImpl#getAlignment <em>Alignment</em>}</li>
 * </ul>
 *
 * @generated not
 */
public class CellTextStyleImpl extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl implements CellTextStyle {

	/**
	 * The default value of the '{@link #getAlignment() <em>Alignment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getAlignment()
	 * @generated
	 * @ordered
	 */
	protected static final CellTextAlignment ALIGNMENT_EDEFAULT = CellTextAlignment.MIDDLE_LEFT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected CellTextStyleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablestylePackage.Literals.CELL_TEXT_STYLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Decrease the generated ESTATIC_FEATURE_COUNT from 1 to 0 because the inherited
	 * EModelElement.eAnnotations feature is implemented dynamically, too.
	 * <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	protected static final int ESTATIC_FEATURE_COUNT = 0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return ESTATIC_FEATURE_COUNT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public CellTextAlignment getAlignment() {
		return (CellTextAlignment) eDynamicGet(NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.CELL_TEXT_STYLE__ALIGNMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setAlignment(CellTextAlignment newAlignment) {
		eDynamicSet(NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT - ESTATIC_FEATURE_COUNT, NattablestylePackage.Literals.CELL_TEXT_STYLE__ALIGNMENT, newAlignment);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT:
			return getAlignment();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT:
			setAlignment((CellTextAlignment) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT:
			setAlignment(ALIGNMENT_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablestylePackage.CELL_TEXT_STYLE__ALIGNMENT:
			return getAlignment() != ALIGNMENT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}
} // CellTextStyleImpl
