/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.cdo.internal.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.uml2.common.util.CacheAdapter;

public class CDOCacheAdapter
extends CacheAdapter {
    private final IListener viewListener = new LifecycleEventAdapter(){

        protected void onAboutToDeactivate(ILifecycle lifecycle) {
            CDOCacheAdapter.this.disconnectView((CDOView)lifecycle);
        }

        protected void notifyOtherEvent(IEvent event) {
            if (event instanceof CDOViewInvalidationEvent) {
                CDOViewInvalidationEvent e = (CDOViewInvalidationEvent)event;
                HashSet<Resource> resources = new HashSet<Resource>();
                this.collectResources(resources, e.getDirtyObjects());
                this.collectResources(resources, e.getDetachedObjects());
                for (Resource resource : resources) {
                    CDOCacheAdapter.this.clear(resource);
                }
            }
        }

        private void collectResources(Set<Resource> resources, Set<CDOObject> objects) {
            for (CDOObject object : objects) {
                resources.add(object.eResource());
            }
        }
    };
    private final Set<CDOView> connectedViews = new HashSet<CDOView>();

    public static EcoreUtil.CrossReferencer getInverseCrossReferencer() {
        try {
            Field field = ECrossReferenceAdapter.class.getDeclaredField("inverseCrossReferencer");
            field.setAccessible(true);
            return (EcoreUtil.CrossReferencer)field.get(CDOCacheAdapter.getInstance());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void register(CacheAdapter cacheAdapter) {
        if (THREAD_LOCAL == null) {
            try {
                Field field = CacheAdapter.class.getDeclaredField("INSTANCE");
                field.setAccessible(true);
                field.set(null, cacheAdapter);
            }
            catch (Throwable throwable) {}
        } else {
            THREAD_LOCAL.set(cacheAdapter);
        }
    }

    protected void selfAdapt(Notification notification) {
        CDOView view = this.getView(notification.getNotifier());
        if (view == null) {
            super.selfAdapt(notification);
        }
    }

    public boolean adapt(Notifier notifier) {
        CDOView view = this.getView(notifier);
        if (view != null) {
            this.connectView(view);
            return false;
        }
        return super.adapt(notifier);
    }

    protected void addAdapter(Notifier notifier) {
        CDOView view = this.getView(notifier);
        if (view != null) {
            this.connectView(view);
            return;
        }
        super.addAdapter(notifier);
    }

    protected ECrossReferenceAdapter provideCrossReferenceAdapter(EObject eObject) {
        CDOView view = this.getView(eObject);
        if (view != null) {
            return this;
        }
        return super.provideCrossReferenceAdapter(eObject);
    }

    private CDOView getView(Object notifier) {
        EObject eObject;
        CDOObject cdoObject;
        if (notifier instanceof EObject && (cdoObject = CDOUtil.getCDOObject((EObject)(eObject = (EObject)notifier), (boolean)false)) != null) {
            return cdoObject.cdoView();
        }
        return null;
    }

    private Collection<EStructuralFeature.Setting> collectInverseReferences(CDOObject cdoObject, CDOView view, boolean nonNavigable) {
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        for (CDOObjectReference xref : view.queryXRefs(Collections.singleton(cdoObject), new EReference[0])) {
            EReference sourceReference = xref.getSourceReference();
            if (nonNavigable && sourceReference.getEOpposite() != null) continue;
            InternalCDOObject object = (InternalCDOObject)view.getObject(xref.getSourceID());
            result.add(object.eSetting((EStructuralFeature)sourceReference));
        }
        return result;
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject eObject) {
        CDOView view;
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)eObject, (boolean)false);
        if (cdoObject != null && (view = cdoObject.cdoView()) != null) {
            return this.collectInverseReferences(cdoObject, view, true);
        }
        return super.getNonNavigableInverseReferences(eObject);
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject) {
        CDOView view;
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)eObject, (boolean)false);
        if (cdoObject != null && (view = cdoObject.cdoView()) != null) {
            return this.collectInverseReferences(cdoObject, view, false);
        }
        return super.getInverseReferences(eObject);
    }

    protected InverseCrossReferencer createInverseCrossReferencer() {
        return new InverseCrossReferencer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectView(CDOView view) {
        boolean added;
        Set<CDOView> set = this.connectedViews;
        synchronized (set) {
            added = this.connectedViews.add(view);
        }
        if (added) {
            view.addListener(this.viewListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectView(CDOView view) {
        boolean removed;
        Set<CDOView> set = this.connectedViews;
        synchronized (set) {
            removed = this.connectedViews.remove(view);
        }
        if (removed) {
            view.removeListener(this.viewListener);
            this.clear();
        }
    }

    protected class InverseCrossReferencer
    extends CacheAdapter.InverseCrossReferencer {
        private static final long serialVersionUID = 1L;

        protected InverseCrossReferencer() {
            super((CacheAdapter)CDOCacheAdapter.this);
        }

        public EContentsEList.FeatureIterator<EObject> getCrossReferences(EObject eObject) {
            return super.getCrossReferences(eObject);
        }

        protected Collection<EStructuralFeature.Setting> getCollection(Object key) {
            return super.getCollection(key);
        }
    }
}

