/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.extension.StyleHandlerManager;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.StyleHandlerProvider;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElementFactory;

public class AppearanceModelElementFactory
implements ModelElementFactory {
    public ModelElement createFromSource(Object sourceElement, DataContextElement context) {
        for (StyleHandlerProvider provider : StyleHandlerManager.instance.getStyleHandlerProviders()) {
            if (!provider.isProviderFor(sourceElement)) continue;
            ModelElement element = provider.createModelElement(sourceElement, context);
            if (element == null) {
                Activator.log.warn("The StyleHandlerProvider " + provider.getClass().getName() + " provided an invalid ModelElement");
            }
            return element;
        }
        Activator.log.warn("No StyleHandlerProvider found for the following object: " + String.valueOf(sourceElement));
        return null;
    }
}

