/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.factory;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;

public class IAxisFactory {
    private IAxisFactory() {
    }

    public static final ITreeItemAxis createITreeItemAxis(ITreeItemAxis parent, Object object, AxisManagerRepresentation manager, String alias) {
        ITreeItemAxis createdAxis = null;
        if (object instanceof Integer || object instanceof Float || object instanceof Boolean) {
            object = object.toString();
        }
        if (object instanceof String) {
            IdTreeItemAxis newAxis = NattableaxisFactory.eINSTANCE.createIdTreeItemAxis();
            newAxis.setElement((String)object);
            createdAxis = newAxis;
        } else if (object instanceof EStructuralFeature) {
            EStructuralFeatureTreeItemAxis newAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureTreeItemAxis();
            newAxis.setElement((EStructuralFeature)object);
            createdAxis = newAxis;
        } else if (object instanceof EOperation) {
            EOperationTreeItemAxis newAxis = NattableaxisFactory.eINSTANCE.createEOperationTreeItemAxis();
            newAxis.setElement((EOperation)object);
            createdAxis = newAxis;
        } else if (object instanceof EObject) {
            EObjectTreeItemAxis newAxis = NattableaxisFactory.eINSTANCE.createEObjectTreeItemAxis();
            newAxis.setElement((EObject)object);
            createdAxis = newAxis;
        }
        if (createdAxis == null) {
            throw new UnsupportedOperationException(NLS.bind((String)"The creation for {0} is not yet implemented", (Object)object));
        }
        createdAxis.setParent(parent);
        createdAxis.setManager(manager);
        createdAxis.setAlias(alias);
        return createdAxis;
    }

    @Deprecated
    public static final FeatureAxis createAxisForFeature(Object object, AxisManagerRepresentation manager, String alias) {
        if (object instanceof String) {
            FeatureIdAxis axis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
            axis.setElement((String)object);
            axis.setAlias(alias);
            return axis;
        }
        if (object instanceof EStructuralFeature) {
            EStructuralFeatureAxis axis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
            axis.setElement((EStructuralFeature)object);
            axis.setAlias(alias);
            return axis;
        }
        throw new UnsupportedOperationException(NLS.bind((String)"The creation for {0} is not yet implemented", (Object)object));
    }

    public static final IAxis createAxisForTypedElement(Object object, AxisManagerRepresentation manager, String alias) {
        if (object instanceof String) {
            FeatureIdAxis axis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
            axis.setElement((String)object);
            axis.setAlias(alias);
            return axis;
        }
        if (object instanceof EStructuralFeature) {
            EStructuralFeatureAxis axis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
            axis.setElement((EStructuralFeature)object);
            axis.setAlias(alias);
            return axis;
        }
        if (object instanceof EOperation) {
            EOperationAxis axis = NattableaxisFactory.eINSTANCE.createEOperationAxis();
            axis.setElement((EOperation)object);
            axis.setAlias(alias);
            return axis;
        }
        throw new UnsupportedOperationException(NLS.bind((String)"The creation for {0} is not yet implemented", (Object)object));
    }
}

