/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter.instructions;

import org.eclipse.nebula.widgets.richtext.painter.AlignmentStyle;
import org.eclipse.nebula.widgets.richtext.painter.TagProcessingState;
import org.eclipse.nebula.widgets.richtext.painter.instructions.ParagraphInstruction;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class ListInstruction
extends ParagraphInstruction {
    protected int listIndentation;
    protected boolean ordered;

    public ListInstruction(int listIndent, boolean ordered, AlignmentStyle alignment, int paragraphSpace, TagProcessingState state) {
        super(alignment, paragraphSpace, state);
        this.listIndentation = listIndent;
        this.ordered = ordered;
    }

    @Override
    public void paint(GC gc, Rectangle area) {
        int marginLeft = this.state.getMarginLeft();
        super.paint(gc, area);
        if (this.state.getListDepth() > 0) {
            this.state.increaseY(this.state.getCurrentLineHeight() - this.paragraphSpace);
            this.state.setMarginLeft(marginLeft);
        }
        this.state.initCurrentListNumber();
        this.state.setListMargin(this.listIndentation);
        this.state.setOrderedList(this.ordered);
    }
}

