/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.component.getorcreate;

import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.AbstractWidget;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.widget.getorcreate.IAbstractGetOrCreateElementWidget;
import org.eclipse.papyrus.emf.facet.util.ui.utils.PropertyElement2;
import org.eclipse.papyrus.emf.facet.util.ui.utils.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractGetOrCreateElementWidget<T>
extends AbstractWidget
implements IAbstractGetOrCreateElementWidget {
    public static final int COLUMN_NUMBER = 3;
    private PropertyElement2<T> propertyElement;
    private Text text;

    protected AbstractGetOrCreateElementWidget(Composite parent, PropertyElement2<T> propertyElement) {
        super(parent);
        this.propertyElement = propertyElement;
        this.setLayout((Layout)new GridLayout(3, false));
    }

    public final PropertyElement2<T> getPropertyElement() {
        return this.propertyElement;
    }

    public Text getTextField() {
        return this.text;
    }

    protected void createTextField(boolean enabled) {
        ModifyListener modifyListener = null;
        if (enabled) {
            modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    AbstractGetOrCreateElementWidget.this.onTextModfified();
                }
            };
        }
        String initialText = "";
        if (this.propertyElement.getValue() != null && this.getTextFieldInitialText() != null) {
            initialText = this.getTextFieldInitialText();
        }
        this.text = UIUtils.createTextField(this, initialText, enabled, modifyListener);
        this.fireChanged();
    }

    protected void onTextModfified() {
        this.propertyElement.setValue(this.text.getText().toString());
        this.onFieldEdited();
    }

    protected void onFieldEdited() {
        this.fireChanged();
    }

    protected String getTextFieldInitialText() {
        String result = "";
        Object value = this.getPropertyElement().getValue();
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    @Override
    public String getError() {
        String error = null;
        Object value = this.propertyElement.getValue();
        if (value == null && !this.propertyElement.isCanBeNull()) {
            error = this.getErrorMessage();
        }
        return error;
    }

    protected abstract String getErrorMessage();

    public void setPropertyElement(PropertyElement2<T> propertyElement) {
        this.propertyElement = propertyElement;
    }

    public T getElement() {
        return this.getPropertyElement().getValue2();
    }

    @Override
    public String getText() {
        return this.text.getText();
    }

    @Override
    public void setText(String text) {
        this.text.setText(text);
    }
}

