/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.service.EditPolicyProviderService;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ViewProviderService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public class ProviderServiceUtil {
    private static final boolean isPapyrusGMFPart(EditPart editPart) {
        Object model;
        if (editPart != null && (model = editPart.getModel()) instanceof View) {
            return ProviderServiceUtil.isPapyrusGMFView((View)model);
        }
        return false;
    }

    private static final boolean isPapyrusGMFView(View view) {
        Diagram d;
        if (view != null && (d = view.getDiagram()) != null) {
            return DiagramUtils.isPapyrusGMFDiagram(d);
        }
        return false;
    }

    public static boolean isPapyrusPart(EditPart editPart) {
        if (!ProviderServiceUtil.isPapyrusGMFPart(editPart)) {
            return false;
        }
        try {
            return ServiceUtilsForEditPart.getInstance().getServiceRegistry(editPart) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isPapyrusView(View view) {
        if (!ProviderServiceUtil.isPapyrusGMFView(view)) {
            return false;
        }
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)view) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isEnabled(IViewProvider provider, View view) {
        if (ProviderServiceUtil.isPapyrusView(view)) {
            try {
                ViewProviderService service = (ViewProviderService)ServiceUtilsForEObject.getInstance().getService(ViewProviderService.class, (Object)view);
                return service.isEnabled(provider, view);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean isEnabled(IEditPolicyProvider provider, EditPart editPart) {
        if (ProviderServiceUtil.isPapyrusPart(editPart)) {
            try {
                EditPolicyProviderService service = (EditPolicyProviderService)ServiceUtilsForEditPart.getInstance().getService(EditPolicyProviderService.class, editPart);
                return service.isEnabled(provider, editPart);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }
}

