/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.papyrus.infra.widgets.editors.richtext.AbstractToolbarButton;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.infra.widgets.editors.richtext.RichTextUtils;
import org.eclipse.papyrus.infra.widgets.editors.richtext.SpellCheckToolbarButton;
import org.eclipse.swt.browser.BrowserFunction;

public class GenericToolbarConfiguration
extends ToolbarConfiguration {
    private List<AbstractToolbarButton> buttons = new ArrayList<AbstractToolbarButton>();

    public GenericToolbarConfiguration() {
        this.removeDefaultToolbarButton("Flash");
        this.removeDefaultToolbarButton("Table");
        this.removeDefaultToolbarButton("HorizontalRule");
        this.removeDefaultToolbarButton("Smiley");
        this.removeDefaultToolbarButton("SpecialChar");
        this.removeDefaultToolbarButton("PageBreak");
        this.removeDefaultToolbarButton("Iframe");
        this.registerDefaultButton();
    }

    protected void registerDefaultButton() {
        this.addSpellCheckToolbarButton();
    }

    protected void addSpellCheckToolbarButton() {
        SpellCheckToolbarButton action = new SpellCheckToolbarButton();
        this.addToolbarButton(action);
    }

    public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
        if (button instanceof AbstractToolbarButton) {
            this.buttons.add((AbstractToolbarButton)button);
        }
        super.addToolbarButton(button, function);
    }

    public void setRichTextEditor(GenericRichTextEditor editor) {
        for (AbstractToolbarButton current : this.buttons) {
            current.setRichTextEditor(editor);
        }
    }

    protected String getToolbarGroupConfiguration() {
        return this.createToolbarGroupConfiguration();
    }

    protected String createToolbarGroupConfiguration() {
        StringBuilder builder = new StringBuilder("CKEDITOR.config.toolbarGroups = ");
        builder.append("[");
        builder.append(this.createSourceGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createClipboardGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createOtherGroup().toLowerCase());
        builder.append(",");
        builder.append("'/'");
        builder.append(",");
        builder.append(this.createParagraphGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createColorsGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createLinksGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createInsertGroup().toLowerCase());
        builder.append(",");
        builder.append("'/'");
        builder.append(",");
        builder.append(this.createStylesGroup().toLowerCase());
        builder.append(",");
        builder.append(this.createBasicStylesGroup().toLowerCase());
        builder.append("]");
        builder.append(" ");
        builder.append(";");
        return builder.toString();
    }

    protected String createSourceGroup() {
        return RichTextUtils.createGroups("source", Collections.singletonList("mode"));
    }

    protected String createClipboardGroup() {
        ArrayList<String> clipboard = new ArrayList<String>();
        clipboard.add("clipboard");
        clipboard.add("Undo");
        clipboard.add("Find");
        return RichTextUtils.createGroups("clipboard", clipboard).toLowerCase();
    }

    protected String createOtherGroup() {
        return RichTextUtils.createGroups("other", null);
    }

    protected String createParagraphGroup() {
        ArrayList<String> paragraph = new ArrayList<String>();
        paragraph.add("list");
        paragraph.add("Indent");
        paragraph.add("align");
        return RichTextUtils.createGroups("paragraph", paragraph);
    }

    protected String createColorsGroup() {
        return RichTextUtils.createGroups("colors", null);
    }

    protected String createLinksGroup() {
        return RichTextUtils.createGroups("links", null);
    }

    protected String createInsertGroup() {
        return RichTextUtils.createGroups("insert", null);
    }

    protected String createStylesGroup() {
        return RichTextUtils.createGroups("styles", null);
    }

    protected String createBasicStylesGroup() {
        ArrayList<String> basicstyles = new ArrayList<String>();
        basicstyles.add("basicstyles");
        basicstyles.add("cleanup");
        return RichTextUtils.createGroups("basicstyles", basicstyles);
    }
}

