/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public abstract class CreateBehavioredClassifierDiagramCommand
extends AbstractPapyrusGmfCreateDiagramCommandHandler {
    private Behavior behavior = null;
    private String name = "";

    protected void initializeDiagram(EObject diagram) {
        if (diagram instanceof Diagram) {
            Diagram diag = (Diagram)diagram;
            if (this.behavior != null) {
                diag.setElement((EObject)this.behavior);
                this.createBehaviorView(diag);
            }
            diag.setName(this.getName());
        }
    }

    protected Behavior createBehavior() {
        Behavior newBehavior = (Behavior)UMLFactory.eINSTANCE.create(this.getBehaviorEClass());
        return newBehavior;
    }

    protected abstract EClass getBehaviorEClass();

    protected void initializeModel(EObject owner) {
        if (owner.eClass() == this.getBehaviorEClass()) {
            this.behavior = (Behavior)owner;
        } else {
            this.behavior = (Behavior)UMLFactory.eINSTANCE.create(this.getBehaviorEClass());
            if (owner instanceof BehavioredClassifier) {
                BehavioredClassifier behaviorClassifier = (BehavioredClassifier)owner;
                behaviorClassifier.getOwnedBehaviors().add((Object)this.behavior);
            } else if (owner instanceof Package) {
                Package pack = (Package)owner;
                pack.getPackagedElements().add((Object)this.behavior);
            }
            this.behavior.setName(NamedElementUtil.getName((NamedElement)this.behavior));
        }
    }

    private void createBehaviorView(Diagram diagram) {
        ViewService.getInstance().createView(Node.class, (IAdaptable)new EObjectAdapter((EObject)this.behavior), (View)diagram, null, -1, true, this.getPreferenceHint());
    }

    protected Diagram doCreateDiagram(Resource diagramResource, EObject owner, EObject element, DiagramPrototype prototype, String name) {
        Diagram diagram = null;
        if (element instanceof Package) {
            diagram = ViewService.createDiagram((EObject)element, (String)this.getDiagramNotationID(), (PreferencesHint)this.getPreferenceHint());
        } else if (element instanceof BehavioredClassifier) {
            diagram = ViewService.createDiagram((EObject)((BehavioredClassifier)element).getNearestPackage(), (String)this.getDiagramNotationID(), (PreferencesHint)this.getPreferenceHint());
        }
        if (diagram != null) {
            this.setName(name);
            diagram.setElement(element);
            DiagramUtils.setOwner((Diagram)diagram, (EObject)owner);
            DiagramUtils.setPrototype((Diagram)diagram, (DiagramPrototype)prototype);
            this.initializeModel(element);
            this.initializeDiagram((EObject)diagram);
            diagramResource.getContents().add((Object)diagram);
        }
        return diagram;
    }

    protected void setName(String newName) {
        if (newName == null || newName.equals(this.name)) {
            return;
        }
        this.name = newName;
    }

    protected String getName() {
        return this.name;
    }
}

