/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeElementListener
extends ResourceSetListenerImpl {
    private StereotypeNotificationFilter stereotypeFilter = new StereotypeNotificationFilter();
    private final StereotypeExtensionFinder finder;
    private final List<NotificationChain> undoRedoNotifications = new ArrayList<NotificationChain>();
    private final Transaction.OptionMetadata undoRedoOption = Transaction.OptionMetadata.Registry.INSTANCE.getOptionMetadata((Object)"is_undo_redo_transaction");

    public StereotypeElementListener(TransactionalEditingDomain editingDomain) {
        this(editingDomain.getResourceSet());
    }

    public StereotypeElementListener(ResourceSet resourceSet) {
        this.finder = new StereotypeExtensionFinder(resourceSet);
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        AbstractCommand result = null;
        if (!event.getNotifications().isEmpty()) {
            NotificationChainImpl chain = new NotificationChainImpl();
            ArrayList filteredNotificationsList = new ArrayList(event.getNotifications());
            for (Notification notification : filteredNotificationsList) {
                this.handleFilteredNotification(notification, (NotificationChain)chain);
            }
            result = new AbstractCommand("Inject Stereotype Notifications", (NotificationChain)chain){
                private NotificationChain notifications;
                private final /* synthetic */ NotificationChain val$chain;
                {
                    this.val$chain = notificationChain;
                    super($anonymous0);
                }

                protected boolean prepare() {
                    this.notifications = this.val$chain;
                    return true;
                }

                public void execute() {
                    this.dispatchAndInvert();
                }

                public void undo() {
                    StereotypeElementListener.this.undoRedoNotifications.add(this.notifications);
                }

                public void redo() {
                    StereotypeElementListener.this.undoRedoNotifications.add(this.notifications);
                }

                private void dispatchAndInvert() {
                    this.notifications.dispatch();
                    StereotypeElementListener.this.invertNotifications(this.notifications);
                }
            };
        }
        return result;
    }

    private void invertNotifications(NotificationChain notifications) {
        EList list = (EList)notifications;
        ECollections.reverse((EList)list);
        for (Notification next : list) {
            ((StereotypeExtensionNotification)next).invert();
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (event.getTransaction() == null || Boolean.FALSE.equals(this.undoRedoOption.getValue(event.getTransaction().getOptions()))) {
            this.undoRedoNotifications.clear();
        } else if (!this.undoRedoNotifications.isEmpty()) {
            try {
                for (NotificationChain next : this.undoRedoNotifications) {
                    next.dispatch();
                    this.invertNotifications(next);
                }
            }
            finally {
                this.undoRedoNotifications.clear();
            }
        }
    }

    private void handleFilteredNotification(Notification notification, NotificationChain notifications) {
        Object notifier = notification.getNotifier();
        Element extendedElement = null;
        Stereotype stereotype = null;
        boolean isBaseFeature = true;
        if (notifier instanceof EObject && (stereotype = this.finder.getDefiningStereotype((EObject)notifier)) != null) {
            extendedElement = this.finder.getExtendedElement((EObject)notifier);
            isBaseFeature = ((EStructuralFeature)notification.getFeature()).getName().startsWith("base_");
        }
        int eventType = 0;
        if (stereotype != null) {
            if (!isBaseFeature) {
                eventType = 33;
            } else if (extendedElement == null) {
                extendedElement = (Element)notification.getOldValue();
                eventType = 32;
            } else {
                extendedElement = (Element)notification.getNewValue();
                eventType = 31;
            }
        }
        if (stereotype != null) {
            Object oldValue = null;
            Object newValue = null;
            Element element = extendedElement;
            switch (eventType) {
                case 32: {
                    oldValue = notifier;
                    break;
                }
                case 31: {
                    newValue = notifier;
                    break;
                }
                case 33: {
                    newValue = notification.getNewValue();
                    oldValue = notification.getOldValue();
                }
            }
            if (element != null) {
                StereotypeExtensionNotification newNotification = new StereotypeExtensionNotification(element, eventType, oldValue, newValue, stereotype);
                if (notifications == null) {
                    newNotification.dispatch();
                } else {
                    notifications.add((Notification)newNotification);
                }
            }
        }
    }

    public NotificationFilter getFilter() {
        return this.stereotypeFilter;
    }

    class StereotypeExtensionFinder
    extends UMLUtil {
        private final ResourceSet resourceSet;

        StereotypeExtensionFinder(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        Stereotype getDefiningStereotype(EObject stereotypeApplication) {
            Stereotype result = null;
            NamedElement umlDefinition = this.getUMLDefinition((ENamedElement)stereotypeApplication.eClass(), stereotypeApplication);
            if (umlDefinition instanceof Stereotype) {
                result = (Stereotype)umlDefinition;
            }
            return result;
        }

        Property getExtensionEnd(EObject stereotypeApplication, EStructuralFeature ecoreDefinition) {
            Property property;
            Property result = null;
            NamedElement umlDefinition = this.getUMLDefinition((ENamedElement)ecoreDefinition, stereotypeApplication);
            if (umlDefinition instanceof Property && (property = (Property)umlDefinition).getAssociation() instanceof Extension) {
                result = property;
            }
            return result;
        }

        NamedElement getUMLDefinition(ENamedElement ecoreElement, EObject context) {
            EObject anyLoadedObject;
            boolean mayBeStereotype = false;
            for (EReference reference : context.eClass().getEAllReferences()) {
                EClass type;
                String name = reference.getName();
                if (name == null || !name.startsWith("base_")) continue;
                EClass eClass = type = reference.getEType() instanceof EClass ? (EClass)reference.getEType() : null;
                if (type == null || !UMLPackage.eINSTANCE.getElement().isSuperTypeOf(type)) continue;
                mayBeStereotype = true;
                break;
            }
            if (!mayBeStereotype) {
                return null;
            }
            NamedElement result = StereotypeExtensionFinder.getNamedElement((ENamedElement)ecoreElement, (EObject)context);
            if (result == null && this.resourceSet != null && (anyLoadedObject = this.getAnyEObject(this.resourceSet)) != null) {
                result = StereotypeExtensionFinder.getNamedElement((ENamedElement)ecoreElement, (EObject)anyLoadedObject);
            }
            return result;
        }

        Element getExtendedElement(EObject stereotypeApplication) {
            EClass eClass = stereotypeApplication.eClass();
            return StereotypeExtensionFinder.getBaseElement((EClass)eClass, (EObject)stereotypeApplication);
        }

        private EObject getAnyEObject(ResourceSet resourceSet) {
            EObject result = null;
            for (Resource next : resourceSet.getResources()) {
                if (!next.isLoaded() || next.getContents().isEmpty()) continue;
                result = (EObject)next.getContents().get(0);
            }
            return result;
        }
    }

    public class StereotypeExtensionNotification
    extends ENotificationImpl {
        public static final int STEREOTYPE_APPLIED_TO_ELEMENT = 31;
        public static final int STEREOTYPE_UNAPPLIED_FROM_ELEMENT = 32;
        public static final int MODIFIED_STEREOTYPE_OF_ELEMENT = 33;
        private Stereotype stereotype;

        public StereotypeExtensionNotification(Element notifier, int eventType, Object oldValue, Object newValue, Stereotype stereotype) {
            super((InternalEObject)notifier, eventType, null, oldValue, newValue);
            this.stereotype = stereotype;
        }

        public boolean isTouch() {
            return false;
        }

        public Stereotype getStereotype() {
            return this.stereotype;
        }

        void invert() {
            switch (this.getEventType()) {
                case 31: {
                    this.eventType = 32;
                    break;
                }
                case 32: {
                    this.eventType = 31;
                    break;
                }
            }
            Object swap = this.oldValue;
            this.oldValue = this.newValue;
            this.newValue = swap;
        }
    }

    class StereotypeNotificationFilter
    extends NotificationFilter.Custom {
        StereotypeNotificationFilter() {
        }

        public boolean matches(Notification notification) {
            Stereotype stereotype;
            Object notifier = notification.getNotifier();
            Object feature = notification.getFeature();
            Element baseElement = null;
            boolean isBaseFeature = false;
            if (feature instanceof EStructuralFeature) {
                isBaseFeature = ((EStructuralFeature)feature).getName().startsWith("base_");
            }
            switch (notification.getEventType()) {
                case 9: {
                    if (isBaseFeature) break;
                    return false;
                }
                default: {
                    if (!notification.isTouch()) break;
                    return false;
                }
            }
            Property extensionProperty = null;
            if (notifier instanceof EObject && (stereotype = StereotypeElementListener.this.finder.getDefiningStereotype((EObject)notifier)) != null && (extensionProperty = StereotypeElementListener.this.finder.getExtensionEnd((EObject)notifier, (EStructuralFeature)feature)) == null) {
                baseElement = StereotypeExtensionFinder.getBaseElement((EObject)((EObject)notifier));
            }
            return extensionProperty != null && isBaseFeature || !isBaseFeature && baseElement instanceof Element;
        }
    }
}

