/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.GetObjectsOfTypeListSelectionDialog;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.actions.LabelHelper;
import org.eclipse.papyrus.uml.diagram.common.ui.helper.HelpComponentFactory;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLFactory;

public abstract class CreateInvocationActionDialog
extends FormDialog {
    protected static final String MAP_FORMAT = "%s|%s";
    private static final Pattern MAP_PATTERN = Pattern.compile("(.*?)\\|(.*)");
    private Button creationRadio;
    protected Button selectionRadio;
    private Text selectionText;
    private Button selectionButton;
    private Text creationNameText;
    private Text creationParentText;
    private Button creationParentButton;
    protected EObject selectedInvoked = null;
    protected EObject selectedParent = null;
    private Activity actionParent;
    protected EClass selectedType = null;
    protected String selectedName = null;
    private ComboViewer typeComboViewer = null;
    private Combo creationTypeCombo = null;
    private ILabelProvider labelProvider;
    private InvocationAction invocationAction;

    public CreateInvocationActionDialog(Shell shell, Activity owner, InvocationAction newAction) {
        super(shell);
        this.actionParent = owner;
        this.selectedParent = this.getDefaultParent(owner);
        this.labelProvider = this.getCustomLabelProvider();
        this.invocationAction = newAction;
        try {
            LabelProviderService labelProviderService = (LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)owner).getService(LabelProviderService.class);
            this.labelProvider = labelProviderService.getLabelProvider((Object)owner);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public InvocationAction getInvocationAction() {
        return this.invocationAction;
    }

    private EObject getDefaultParent(Activity owner) {
        Matcher match;
        IPreferenceStore prefStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String ownerString = prefStore.getString(this.getCreationDefaultOwnerPreference());
        if (ownerString != null && !"".equals(ownerString) && (match = MAP_PATTERN.matcher(ownerString)).matches() && match.groupCount() >= 2) {
            EObject parent;
            String ressURI = match.group(1);
            String parentURI = match.group(2);
            if (owner.eResource().getURI().toString().equals(ressURI) && (parent = owner.eResource().getEObject(parentURI)) != null) {
                return parent;
            }
        }
        Activity parent = owner;
        while (!this.isPossibleInvokedParent((EObject)parent)) {
            parent = parent.eContainer();
        }
        return parent;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(this.getTitle());
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createInvocationCreationSection(scrolledForm.getBody(), toolkit);
        this.createInvocationSelectionSection(scrolledForm.getBody(), toolkit);
        this.createExtraSections(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(this.isSelectionDefault());
        this.hookListeners();
        this.setInvokedName(null);
        scrolledForm.reflow(true);
    }

    protected boolean isSelectionDefault() {
        IPreferenceStore prefStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        return prefStore.getBoolean(this.getSelectionIsDefaultPreference());
    }

    protected abstract String getSelectionIsDefaultPreference();

    protected abstract String getCreationDefaultOwnerPreference();

    protected void createExtraSections(Composite pParent, FormToolkit pToolkit) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    private void createInvocationSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getInvocationSelectionSectionTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, this.getSelectionLabel(), 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, this.getInvokedObjectLabel(), 0);
        this.selectionText = pToolkit.createText(lBody, "", 2056);
        this.selectionText.setLayoutData((Object)new GridData(768));
        this.selectionButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = UMLElementTypes.getImage((ENamedElement)this.getInvocationFeature());
        this.selectionButton.setImage(image);
        this.selectionButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void createInvocationCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getInvocationCreationSectionTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ImageHyperlink componentHelp = HelpComponentFactory.createHelpComponent((Composite)lSection, (FormToolkit)pToolkit, (String)this.getInvocationCreationSectionHelp(), (boolean)true);
        lSection.setTextClient((Control)componentHelp);
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, this.getCreationLabel(), 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        if (this.getPossibleInvokedTypes().length == 1) {
            this.selectedType = this.getPossibleInvokedTypes()[0];
        } else {
            pToolkit.createLabel(lBody, this.getInvokedTypeLabel(), 0);
            this.creationTypeCombo = new Combo(lBody, 12);
            this.typeComboViewer = new ComboViewer(this.creationTypeCombo);
            pToolkit.adapt((Composite)this.creationTypeCombo);
            this.creationTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.typeComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.typeComboViewer.add((Object[])this.getPossibleInvokedTypes());
            if (this.getPossibleInvokedTypes().length > 1) {
                this.typeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getPossibleInvokedTypes()[0]));
                this.selectedType = this.getPossibleInvokedTypes()[0];
            }
        }
        pToolkit.createLabel(lBody, this.getInvokedNameLabel(), 0);
        this.creationNameText = pToolkit.createText(lBody, "", 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.creationNameText.setFocus();
        pToolkit.createLabel(lBody, this.getInvokedParentLabel(), 0);
        this.creationParentText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.selectedParent), 2056);
        this.creationParentText.setLayoutData((Object)new GridData(768));
        this.creationParentButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = this.getParentImage();
        this.creationParentButton.setImage(image);
        this.creationParentButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (!isSelectionSelected) {
            this.selectedInvoked = UMLFactory.eINSTANCE.create(this.selectedType);
            if (this.selectedInvoked instanceof NamedElement) {
                ((NamedElement)this.selectedInvoked).setName(this.selectedName);
            }
            this.addInvokedInParent(this.selectedParent, this.selectedInvoked);
        }
        IPreferenceStore prefStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        prefStore.setValue(this.getSelectionIsDefaultPreference(), isSelectionSelected);
        if (!isSelectionSelected) {
            String ressUri = this.selectedParent.eResource().getURI().toString();
            String parentURI = this.selectedParent.eResource().getURIFragment(this.selectedParent);
            String prefValue = String.format(MAP_FORMAT, ressUri, parentURI);
            prefStore.setValue(this.getCreationDefaultOwnerPreference(), prefValue);
        }
        super.okPressed();
    }

    public EObject getSelectedInvoked() {
        return this.selectedInvoked;
    }

    private void hookListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInvocationActionDialog.this.creationRadio.equals(e.getSource())) {
                    CreateInvocationActionDialog.this.refreshSectionsEnable(false);
                } else {
                    CreateInvocationActionDialog.this.refreshSectionsEnable(true);
                }
                CreateInvocationActionDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.creationRadio.addSelectionListener((SelectionListener)selectCreateListener);
        SelectionAdapter selectBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateInvocationActionDialog.this.handleChooseInvoked();
                CreateInvocationActionDialog.this.refreshOkButton();
            }
        };
        this.selectionButton.addSelectionListener((SelectionListener)selectBtnListener);
        if (this.creationTypeCombo != null && this.typeComboViewer != null) {
            ModifyListener lTypeListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISelection sel = CreateInvocationActionDialog.this.typeComboViewer.getSelection();
                    if (sel instanceof StructuredSelection) {
                        Object type = ((StructuredSelection)sel).getFirstElement();
                        CreateInvocationActionDialog.this.selectedType = type instanceof EClass ? (EClass)type : null;
                        CreateInvocationActionDialog.this.setInvokedName(null);
                        CreateInvocationActionDialog.this.refreshOkButton();
                    }
                }
            };
            this.creationTypeCombo.addModifyListener(lTypeListener);
        }
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateInvocationActionDialog.this.setInvokedName(CreateInvocationActionDialog.this.creationNameText.getText());
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectParentBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateInvocationActionDialog.this.handleChooseParent();
                if (CreateInvocationActionDialog.this.selectedName == null) {
                    CreateInvocationActionDialog.this.setInvokedName(null);
                }
                CreateInvocationActionDialog.this.refreshOkButton();
            }
        };
        this.creationParentButton.addSelectionListener((SelectionListener)selectParentBtnListener);
    }

    private void setInvokedName(String text) {
        String name = text;
        if (text == null && this.selectedParent != null && this.selectedType != null) {
            name = LabelHelper.INSTANCE.findName(this.selectedParent, this.selectedType);
            this.creationNameText.setText(name);
        } else if (name != null && !"".equals(name.trim())) {
            this.selectedName = name.trim();
            Color black = this.creationNameText.getDisplay().getSystemColor(2);
            this.creationNameText.setForeground(black);
            this.refreshOkButton();
        } else {
            this.selectedName = null;
            Color red = this.creationNameText.getDisplay().getSystemColor(3);
            this.creationNameText.setForeground(red);
            this.refreshOkButton();
        }
    }

    protected void handleChooseInvoked() {
        Object[] result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        dialog.setContentProvider((ITreeContentProvider)new UMLContentProvider((EObject)this.getInvocationAction(), (EStructuralFeature)this.getInvocationFeature()));
        dialog.setLabelProvider(this.labelProvider);
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof EObject) {
            this.setInvokedSelection((EObject)result[0]);
        }
    }

    protected void setInvokedSelection(EObject invokedElement) {
        this.selectedInvoked = invokedElement;
        if (this.selectedInvoked instanceof NamedElement) {
            this.selectionText.setText(this.labelProvider.getText((Object)this.selectedInvoked));
        } else {
            this.selectionText.setText("");
        }
    }

    private void handleChooseParent() {
        Object object;
        GetObjectsOfTypeListSelectionDialog dialog = new GetObjectsOfTypeListSelectionDialog(this.getParentShell(), this.labelProvider, (EObject)this.actionParent, false);
        for (EClassifier eClassifier : this.getPossibleInvokedParents((EObject)this.actionParent)) {
            dialog.addElementsOfType(eClassifier);
        }
        if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof EObject) {
            this.setInvokedParent((EObject)dialog.getFirstResult());
        }
    }

    private void setInvokedParent(EObject invokedParent) {
        this.selectedParent = invokedParent;
        if (this.selectedParent instanceof NamedElement) {
            this.creationParentText.setText(this.labelProvider.getText((Object)this.selectedParent));
        } else {
            this.creationParentText.setText("");
        }
    }

    protected void refreshSectionsEnable(boolean isSelectionSelected) {
        if (isSelectionSelected) {
            this.creationRadio.setSelection(false);
            if (!this.selectionRadio.getSelection()) {
                this.selectionRadio.setSelection(true);
            }
        } else {
            this.selectionRadio.setSelection(false);
            if (!this.creationRadio.getSelection()) {
                this.creationRadio.setSelection(true);
            }
        }
        this.selectionText.setEnabled(isSelectionSelected);
        this.selectionButton.setEnabled(isSelectionSelected);
        if (this.creationTypeCombo != null) {
            this.creationTypeCombo.setEnabled(!isSelectionSelected);
        }
        this.creationNameText.setEnabled(!isSelectionSelected);
        this.creationNameText.setFocus();
        this.creationParentText.setEnabled(!isSelectionSelected);
        this.creationParentButton.setEnabled(!isSelectionSelected);
    }

    private void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            if (isSelectionSelected) {
                this.getButton(0).setEnabled(this.selectedInvoked != null);
            } else {
                this.getButton(0).setEnabled(this.selectedParent != null && this.selectedType != null && this.selectedName != null);
            }
        }
    }

    protected void addInvokedInParent(EObject selectedParent, EObject createdInvoked) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        Command addCmd = AddCommand.create((EditingDomain)editingdomain, (Object)selectedParent, null, Collections.singleton(createdInvoked));
        addCmd.execute();
    }

    private ILabelProvider getCustomLabelProvider() {
        AdapterFactoryLabelProvider adapterFactory = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()){

            public String getText(Object object) {
                String text = super.getText(object);
                if (object instanceof EClass) {
                    return text.substring(0, text.indexOf("[") - 1);
                }
                return text;
            }
        };
        return adapterFactory;
    }

    protected abstract EClass[] getPossibleInvokedTypes();

    protected abstract Set<? extends EClassifier> getPossibleInvokedParents(EObject var1);

    protected abstract boolean isPossibleInvokedParent(EObject var1);

    protected abstract EReference getInvocationFeature();

    protected abstract Image getParentImage();

    protected String getInvokedNameLabel() {
        return CustomMessages.CreateCallActionDialog_NameLabel;
    }

    protected String getInvokedTypeLabel() {
        return CustomMessages.CreateCallActionDialog_TypeLabel;
    }

    protected String getInvokedParentLabel() {
        return CustomMessages.CreateCallActionDialog_ParentLabel;
    }

    protected String getInvokedObjectLabel() {
        return this.getInvocationFeature().getEReferenceType().getName() + ":";
    }

    protected abstract String getTitle();

    protected abstract String getInvocationCreationSectionTitle();

    protected abstract String getInvocationCreationSectionHelp();

    protected abstract String getInvocationSelectionSectionTitle();

    protected abstract String getSelectionLabel();

    protected abstract String getCreationLabel();
}

