/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusSlidableSnapToGridAnchor;

public class AnchorHelper {
    public static String getAnchorId(TransactionalEditingDomain domain, org.eclipse.gef.ConnectionEditPart connEditPart, final boolean isSource) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)domain.runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = null;
                    a = isSource ? ((Edge)connection.getModel()).getSourceAnchor() : ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        return t;
    }

    public static Point getRequestLocation(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() != null) {
                Point pt = ((DropRequest)request).getLocation().getCopy();
                return pt;
            }
        } else if (request instanceof DropRequest) {
            return ((DropRequest)request).getLocation();
        }
        return null;
    }

    public static class CombinedFragmentAnchor
    extends SlidableAnchor {
        public CombinedFragmentAnchor(IFigure fig, PrecisionPoint p) {
            super(fig, p);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            Rectangle rect = this.getOwner().getBounds().getCopy();
            this.getOwner().translateToAbsolute((Translatable)rect);
            if (!rect.contains(foreignReference)) {
                return super.getLocation(ownReference, foreignReference);
            }
            PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
            if (intersections != null && intersections.size() > 0) {
                int size = intersections.size();
                Point near = intersections.getPoint(0);
                double dist = ownReference.getDistance(near);
                int i = 1;
                while (i < size) {
                    Point loc = intersections.getPoint(i);
                    double d = ownReference.getDistance(loc);
                    if (d < dist) {
                        dist = d;
                        near = loc;
                    }
                    ++i;
                }
                return near;
            }
            return null;
        }
    }

    public static class CombinedFragmentNodeFigure
    extends DefaultSizeNodeFigure {
        public CombinedFragmentNodeFigure(int width, int height) {
            super(width, height);
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor();
            }
            return new CombinedFragmentAnchor((IFigure)this, p);
        }
    }

    public static class FixedAnchorEx
    extends SlidableAnchor {
        protected int position;

        public FixedAnchorEx(IFigure f, int location) {
            super(f, location == 8 ? new PrecisionPoint(0.0, 0.0) : new PrecisionPoint(0.0, 1.0));
            this.position = location;
        }

        public Point getLocation(Point reference) {
            if (this.position == 8) {
                Point topLeft = this.getBox().getTopLeft();
                if (reference.x < topLeft.x) {
                    return topLeft;
                }
                return this.getBox().getTopRight();
            }
            if (this.position == 32) {
                Point bottomLeft = this.getBox().getBottomLeft();
                if (reference.x < bottomLeft.x) {
                    return bottomLeft;
                }
                return this.getBox().getBottomRight();
            }
            if (this.position == 2) {
                return this.getBox().getCenter();
            }
            return super.getLocation(reference);
        }

        public int getPosition() {
            return this.position;
        }

        public String getTerminal() {
            return super.getTerminal() + "{" + this.position + "}";
        }

        public static int parsePosition(String terminal) {
            if (terminal == null) {
                return -1;
            }
            int start = terminal.indexOf("{");
            int end = terminal.indexOf("}");
            if (start != -1 && end != -1 && end > start + 1) {
                String v = terminal.substring(start + 1, end);
                try {
                    return Integer.parseInt(v);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    public static class InnerPointAnchor
    extends PapyrusSlidableSnapToGridAnchor {
        private PrecisionPoint percent;
        private IFigure figure;

        public InnerPointAnchor(IFigure fig, PrecisionPoint percent) {
            super((NodeFigure)fig, percent);
            this.figure = fig;
            this.percent = percent;
        }

        public static InnerPointAnchor createAnchorAtLocation(IFigure fig, PrecisionPoint loc) {
            PrecisionPoint p = loc.getPreciseCopy();
            fig.translateToRelative((Translatable)p);
            return new InnerPointAnchor(fig, p);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            if (this.percent.preciseX() < 1.0 && this.percent.preciseX() > 0.0 || this.percent.preciseY() > 0.0 && this.percent.preciseY() < 1.0) {
                PrecisionRectangle bounds = new PrecisionRectangle(this.figure.getBounds());
                bounds.setPreciseWidth((double)bounds.width * this.percent.preciseX());
                bounds.setPreciseHeight((double)bounds.height * this.percent.preciseY());
                this.percent = new PrecisionPoint(bounds.getBottomRight());
            }
            Point copy = this.percent.getCopy();
            this.figure.translateToAbsolute((Translatable)copy);
            return copy;
        }

        public Point getReferencePoint() {
            if (this.percent.preciseX() < 1.0 && this.percent.preciseX() > 0.0 || this.percent.preciseY() > 0.0 && this.percent.preciseY() < 1.0) {
                return super.getReferencePoint();
            }
            Point copy = this.percent.getCopy();
            this.figure.translateToAbsolute((Translatable)copy);
            return copy;
        }
    }

    public static class IntersectionPointAnchor
    extends SlidableAnchor {
        public IntersectionPointAnchor(IFigure fig, PrecisionPoint p) {
            super(fig, p);
        }

        public IntersectionPointAnchor(IFigure fig) {
            super(fig);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
            if (intersections != null && intersections.size() > 0) {
                int size = intersections.size();
                Point near = intersections.getPoint(0);
                double dist = ownReference.getDistance(near);
                int i = 1;
                while (i < size) {
                    Point loc = intersections.getPoint(i);
                    double d = ownReference.getDistance(loc);
                    if (d < dist) {
                        dist = d;
                        near = loc;
                    }
                    ++i;
                }
                return near;
            }
            return null;
        }
    }

    public static class SideAnchor
    extends SlidableAnchor {
        private boolean isRight;

        public SideAnchor(NodeFigure nodeFigure, PrecisionPoint pt, boolean isRight) {
            super((IFigure)nodeFigure, pt);
            this.isRight = isRight;
        }

        public boolean isRight() {
            return this.isRight;
        }

        public String getTerminal() {
            String side = this.isRight ? "R" : "L";
            return super.getTerminal() + "{" + side + "}";
        }
    }
}

