/**
 * Copyright (c) 2006, 2010, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Artem Tikhomirov (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor.palette;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Separator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.StandardEntryKind;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class PaletteFactory {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private ElementTypes xptElementTypes;

  @Inject
  private Externalizer xptExternalizer;

  public CharSequence className(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    String _factoryClassName = it.getFactoryClassName();
    _builder.append(_factoryClassName);
    return _builder;
  }

  public CharSequence packageName(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  @Deprecated
  public CharSequence Factory(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _PaletteFactory = this.PaletteFactory(it);
    _builder.append(_PaletteFactory);
    return _builder;
  }

  public CharSequence PaletteFactory(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _factoryClassName = it.getFactoryClassName();
    _builder.append(_factoryClassName);
    _builder.append(" extends org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory.Adapter {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("//RS: New Palette generation");
    _builder.newLine();
    _builder.newLine();
    _builder.append("//Generates the ID for the tool elements");
    _builder.newLine();
    _builder.append("//Generate the tool factory (if(ID) createtool...)");
    _builder.newLine();
    {
      Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
      for(final AbstractToolEntry tool : _collectTools) {
        CharSequence _generateIDAttribute = this.generateIDAttribute(tool);
        _builder.append(_generateIDAttribute);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _factoryClassName_1 = it.getFactoryClassName();
    _builder.append(_factoryClassName_1, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generateCreateTool = this.generateCreateTool(it);
    _builder.append(_generateCreateTool, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generateGetTemplate = this.generateGetTemplate(it);
    _builder.append(_generateGetTemplate, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<AbstractToolEntry> _collectTools_1 = this._utils_qvto.collectTools(it);
      for(final AbstractToolEntry tool_1 : _collectTools_1) {
        CharSequence _createTool = this.createTool(tool_1);
        _builder.append(_createTool);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createGroup(final ToolGroup it) {
    StringConcatenation _builder = new StringConcatenation();
    String _title = it.getTitle();
    String _plus = ("Creates \"" + _title);
    String _plus_1 = (_plus + "\" palette tool group");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(_plus_1);
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gef.palette.PaletteContainer ");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _newContainer = this.newContainer(it, "paletteContainer");
    _builder.append(_newContainer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setIdentity = this.setIdentity(it, "paletteContainer");
    _builder.append(_setIdentity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setDescription = this.setDescription(it, "paletteContainer");
    _builder.append(_setDescription, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setSmallImage = this.setSmallImage(it, "paletteContainer", it.getPalette());
    _builder.append(_setSmallImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setLargeImage = this.setLargeImage(it, "paletteContainer", it.getPalette());
    _builder.append(_setLargeImage, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<ToolGroupItem> _entries = it.getEntries();
      for(final ToolGroupItem entry : _entries) {
        _builder.append("\t");
        CharSequence _addEntry = this.addEntry(entry, "paletteContainer");
        _builder.append(_addEntry, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return paletteContainer;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newContainer(final ToolGroup it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((it.isCollapse() && it.isToolsOnly())) {
        _builder.append("org.eclipse.gef.palette.PaletteDrawer ");
        _builder.append(varName);
        _builder.append(" = new org.eclipse.gef.palette.PaletteDrawer(");
        CharSequence _i18nTitle = this.i18nTitle(it);
        _builder.append(_i18nTitle);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        boolean _isStack = it.isStack();
        if (_isStack) {
          _builder.append("org.eclipse.gef.palette.PaletteStack ");
          _builder.append(varName);
          _builder.append(" = new org.eclipse.gef.palette.PaletteStack(");
          CharSequence _i18nTitle_1 = this.i18nTitle(it);
          _builder.append(_i18nTitle_1);
          _builder.append(", null, null);");
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("org.eclipse.gef.palette.PaletteGroup ");
          _builder.append(varName);
          _builder.append(" = new org.eclipse.gef.palette.PaletteGroup(");
          CharSequence _i18nTitle_2 = this.i18nTitle(it);
          _builder.append(_i18nTitle_2);
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
    }
    return _builder;
  }

  public CharSequence setDescription(final ToolGroup gr, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _description = gr.getDescription();
      boolean _tripleNotEquals = (_description != null);
      if (_tripleNotEquals) {
        _builder.append(varName);
        _builder.append(".setDescription(");
        CharSequence _i18nDesc = this.i18nDesc(gr);
        _builder.append(_i18nDesc);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _addEntry(final ToolGroupItem it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("abstract addEntry(ToolGroupItem,String) template for" + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _addEntry(final AbstractToolEntry it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(varName);
    _builder.append(".add(");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    {
      if ((it.isDefault() && it.getGroup().isStack())) {
        _builder.append(varName);
        _builder.append(".setActiveEntry((org.eclipse.gef.palette.ToolEntry) paletteContainer.getChildren().get(paletteContainer.getChildren().size() - 1));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _addEntry(final Separator it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(varName);
    _builder.append(".add(new org.eclipse.gef.palette.PaletteSeparator());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _addEntry(final ToolGroup it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(varName);
    _builder.append(".add(");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence createEntry(final AbstractToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gef.palette.ToolEntry ");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _newEntry = this.newEntry(it, "entry");
    _builder.append(_newEntry, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setIdentity = this.setIdentity(it, "entry");
    _builder.append(_setIdentity, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setSmallImage = this.setSmallImage(it, "entry", it.getGroup().getPalette());
    _builder.append(_setSmallImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setLargeImage = this.setLargeImage(it, "entry", it.getGroup().getPalette());
    _builder.append(_setLargeImage, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setToolClass = this.setToolClass(it, "entry");
    _builder.append(_setToolClass, "\t");
    _builder.newLineIfNotEmpty();
    {
      EMap<String, String> _properties = it.getProperties();
      for(final Map.Entry<String, String> prop : _properties) {
        _builder.append("\t");
        CharSequence _setToolProperty = this.setToolProperty(prop, "entry");
        _builder.append(_setToolProperty, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return entry;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected String toolEntryClass(final ToolEntry entry) {
    String _xifexpression = null;
    boolean _isEmpty = entry.getGenNodes().isEmpty();
    if (_isEmpty) {
      _xifexpression = this.linkToolEntryClassName();
    } else {
      _xifexpression = this.nodeToolEntryClassName();
    }
    return _xifexpression;
  }

  protected String getLinkToolEntryGeneratedClassName() {
    return "LinkToolEntry";
  }

  protected String getNodeToolEntryGeneratedClassName() {
    return "NodeToolEntry";
  }

  protected String getDefaultLinkToolEntryClassName() {
    return "org.eclipse.gmf.tooling.runtime.part.DefaultLinkToolEntry";
  }

  protected String getDefaultNodeToolEntryClassName() {
    return "org.eclipse.gmf.tooling.runtime.part.DefaultNodeToolEntry";
  }

  private String linkToolEntryClassName() {
    String _xifexpression = null;
    boolean _shouldGenerateToolEntryClasses = this.shouldGenerateToolEntryClasses();
    if (_shouldGenerateToolEntryClasses) {
      _xifexpression = this.getLinkToolEntryGeneratedClassName();
    } else {
      _xifexpression = this.getDefaultLinkToolEntryClassName();
    }
    return _xifexpression;
  }

  private String nodeToolEntryClassName() {
    String _xifexpression = null;
    boolean _shouldGenerateToolEntryClasses = this.shouldGenerateToolEntryClasses();
    if (_shouldGenerateToolEntryClasses) {
      _xifexpression = this.getNodeToolEntryGeneratedClassName();
    } else {
      _xifexpression = this.getDefaultNodeToolEntryClassName();
    }
    return _xifexpression;
  }

  protected CharSequence _newEntry(final AbstractToolEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("abstract newEntry(AbstractToolEntry,String) template for: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _newEntry(final ToolEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getElements().isEmpty();
      if (_isEmpty) {
        _builder.append("org.eclipse.gef.palette.ToolEntry ");
        _builder.append(toolVarName);
        _builder.append(" = new org.eclipse.gef.palette.ToolEntry(");
        CharSequence _i18nTitle = this.i18nTitle(it);
        _builder.append(_i18nTitle);
        _builder.append(", ");
        CharSequence _i18nDesc = this.i18nDesc(it);
        _builder.append(_i18nDesc);
        _builder.append(", null, null) {};");
        _builder.newLineIfNotEmpty();
      } else {
        int _size = it.getElements().size();
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          _builder.append("java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
          String _diamondOp = this._codeStyle.diamondOp(it.getElements().get(0), "org.eclipse.gmf.runtime.emf.type.core.IElementType");
          _builder.append(_diamondOp);
          _builder.append(">(");
          int _size_1 = it.getElements().size();
          _builder.append(_size_1);
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          {
            EList<GenCommonBase> _elements = it.getElements();
            for(final GenCommonBase e : _elements) {
              _builder.append("types.add(");
              CharSequence _accessElementType = this.xptElementTypes.accessElementType(e);
              _builder.append(_accessElementType);
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
          String _olEntryClass = this.toolEntryClass(it);
          _builder.append(_olEntryClass);
          _builder.append(" ");
          _builder.append(toolVarName);
          _builder.append(" = new ");
          String _olEntryClass_1 = this.toolEntryClass(it);
          _builder.append(_olEntryClass_1);
          _builder.append("(");
          CharSequence _i18nTitle_1 = this.i18nTitle(it);
          _builder.append(_i18nTitle_1);
          _builder.append(", ");
          CharSequence _i18nDesc_1 = this.i18nDesc(it);
          _builder.append(_i18nDesc_1);
          _builder.append(", types);");
          _builder.newLineIfNotEmpty();
        } else {
          String _olEntryClass_2 = this.toolEntryClass(it);
          _builder.append(_olEntryClass_2);
          _builder.append(" ");
          _builder.append(toolVarName);
          _builder.append(" = new ");
          String _olEntryClass_3 = this.toolEntryClass(it);
          _builder.append(_olEntryClass_3);
          _builder.append("(");
          CharSequence _i18nTitle_2 = this.i18nTitle(it);
          _builder.append(_i18nTitle_2);
          _builder.append(", ");
          CharSequence _i18nDesc_2 = this.i18nDesc(it);
          _builder.append(_i18nDesc_2);
          _builder.append(", java.util.Collections.singletonList(");
          CharSequence _accessElementType_1 = this.xptElementTypes.accessElementType(IterableExtensions.<GenCommonBase>head(it.getElements()));
          _builder.append(_accessElementType_1);
          _builder.append("));");
          _builder.newLineIfNotEmpty();
        }
      }
    }
    return _builder;
  }

  protected CharSequence _newEntry(final StandardEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      StandardEntryKind _kind = it.getKind();
      boolean _equals = Objects.equals(_kind, StandardEntryKind.SELECT_LITERAL);
      if (_equals) {
        CharSequence _newStdSelectEntry = this.newStdSelectEntry(it, toolVarName);
        _builder.append(_newStdSelectEntry);
        _builder.newLineIfNotEmpty();
      } else {
        StandardEntryKind _kind_1 = it.getKind();
        boolean _equals_1 = Objects.equals(_kind_1, StandardEntryKind.MARQUEE_LITERAL);
        if (_equals_1) {
          CharSequence _newStdMarqueeEntry = this.newStdMarqueeEntry(it, toolVarName);
          _builder.append(_newStdMarqueeEntry);
          _builder.newLineIfNotEmpty();
        } else {
          StandardEntryKind _kind_2 = it.getKind();
          boolean _equals_2 = Objects.equals(_kind_2, StandardEntryKind.ZOOM_LITERAL);
          if (_equals_2) {
            CharSequence _newStdZoomEntry = this.newStdZoomEntry(it, toolVarName);
            _builder.append(_newStdZoomEntry);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _newStdOtherEntry = this.newStdOtherEntry(it, toolVarName);
            _builder.append(_newStdOtherEntry);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence newStdSelectEntry(final StandardEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gef.palette.PanningSelectionToolEntry ");
    _builder.append(toolVarName);
    _builder.append(" = new org.eclipse.gef.palette.PanningSelectionToolEntry();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence newStdMarqueeEntry(final StandardEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gef.palette.MarqueeToolEntry ");
    _builder.append(toolVarName);
    _builder.append(" = new org.eclipse.gef.palette.MarqueeToolEntry();");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence newStdZoomEntry(final StandardEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("FIXME");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newStdOtherEntry(final StandardEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    StandardEntryKind _kind = it.getKind();
    String _plus = ("override newStdOtherEntry(StandardEntry, String) for kind " + _kind);
    this._common_qvto.ERROR(_plus);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence setSmallImage(final EntryBase it, final String toolVarName, final Palette palette) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _smallIconPath = it.getSmallIconPath();
      boolean _tripleNotEquals = (null != _smallIconPath);
      if (_tripleNotEquals) {
        _builder.append(toolVarName);
        _builder.append(".setSmallIcon(");
        String _activatorFQN = this._utils_qvto.activatorFQN(palette);
        _builder.append(_activatorFQN);
        _builder.append(".findImageDescriptor(\"");
        String _smallIconPath_1 = it.getSmallIconPath();
        _builder.append(_smallIconPath_1);
        _builder.append("\")); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS);
        _builder.newLineIfNotEmpty();
      } else {
        boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
        if (_oclIsKindOf) {
          {
            GenCommonBase _head = IterableExtensions.<GenCommonBase>head(((ToolEntry) it).getElements());
            boolean _tripleNotEquals_1 = (_head != null);
            if (_tripleNotEquals_1) {
              _builder.append(toolVarName);
              _builder.append(".setSmallIcon(");
              CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(palette.getDiagram());
              _builder.append(_qualifiedClassName);
              _builder.append(".getImageDescriptor(");
              CharSequence _accessElementType = this.xptElementTypes.accessElementType(IterableExtensions.<GenCommonBase>head(((ToolEntry) it).getElements()));
              _builder.append(_accessElementType);
              _builder.append("));");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence setLargeImage(final EntryBase it, final String toolVarName, final Palette palette) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _largeIconPath = it.getLargeIconPath();
      boolean _tripleNotEquals = (null != _largeIconPath);
      if (_tripleNotEquals) {
        _builder.append(toolVarName);
        _builder.append(".setLargeIcon(");
        String _activatorFQN = this._utils_qvto.activatorFQN(palette);
        _builder.append(_activatorFQN);
        _builder.append(".findImageDescriptor(\"");
        String _largeIconPath_1 = it.getLargeIconPath();
        _builder.append(_largeIconPath_1);
        _builder.append("\")); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS);
        _builder.newLineIfNotEmpty();
      } else {
        boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it, ToolEntry.class);
        if (_oclIsKindOf) {
          {
            GenCommonBase _head = IterableExtensions.<GenCommonBase>head(((ToolEntry) it).getElements());
            boolean _tripleNotEquals_1 = (_head != null);
            if (_tripleNotEquals_1) {
              _builder.append(toolVarName);
              _builder.append(".setLargeIcon(");
              _builder.append(toolVarName);
              _builder.append(".getSmallIcon());");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence setToolClass(final AbstractToolEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _qualifiedToolName = it.getQualifiedToolName();
      boolean _tripleNotEquals = (null != _qualifiedToolName);
      if (_tripleNotEquals) {
        _builder.append(toolVarName);
        _builder.append(".setToolClass(");
        String _qualifiedToolName_1 = it.getQualifiedToolName();
        _builder.append(_qualifiedToolName_1);
        _builder.append(".class);");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence setToolProperty(final Map.Entry<String, String> it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(toolVarName);
    _builder.append(".setToolProperty(");
    String _key = it.getKey();
    _builder.append(_key);
    _builder.append(", ");
    String _value = it.getValue();
    _builder.append(_value);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  protected CharSequence _i18nTitle(final ToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleEquals = (_title == null);
      if (_tripleEquals) {
        _builder.append("null");
      } else {
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getGroup().getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nTitleKey(it));
        _builder.append(_accessorCall);
      }
    }
    return _builder;
  }

  @Localization
  protected CharSequence _i18nTitle(final ToolGroup it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleEquals = (_title == null);
      if (_tripleEquals) {
        _builder.append("null");
      } else {
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nTitleKey(it));
        _builder.append(_accessorCall);
      }
    }
    return _builder;
  }

  @Localization
  protected CharSequence _i18nDesc(final ToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _description = it.getDescription();
      boolean _tripleEquals = (_description == null);
      if (_tripleEquals) {
        _builder.append("null");
      } else {
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getGroup().getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nDescKey(it));
        _builder.append(_accessorCall);
      }
    }
    return _builder;
  }

  @Localization
  protected CharSequence _i18nDesc(final ToolGroup it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _description = it.getDescription();
      boolean _tripleEquals = (_description == null);
      if (_tripleEquals) {
        _builder.append("null");
      } else {
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getPalette().getDiagram().getEditorGen(), this._utils_qvto.i18nDescKey(it));
        _builder.append(_accessorCall);
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
      for(final ToolGroup group : _collectGroups) {
        CharSequence _internal_i18n_accessors = this.internal_i18n_accessors(group);
        _builder.append(_internal_i18n_accessors);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
      for(final AbstractToolEntry tool : _collectTools) {
        CharSequence _internal_i18n_accessors_1 = this.internal_i18n_accessors(tool);
        _builder.append(_internal_i18n_accessors_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence i18nValues(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<ToolGroup> _collectGroups = this._utils_qvto.collectGroups(it);
      for(final ToolGroup group : _collectGroups) {
        CharSequence _internal_i18n_values = this.internal_i18n_values(group);
        _builder.append(_internal_i18n_values);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
      for(final AbstractToolEntry tool : _collectTools) {
        CharSequence _internal_i18n_values_1 = this.internal_i18n_values(tool);
        _builder.append(_internal_i18n_values_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  protected CharSequence internal_i18n_accessors(final EntryBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleNotEquals = (null != _title);
      if (_tripleNotEquals) {
        CharSequence _accessorField = this.xptExternalizer.accessorField(this._utils_qvto.i18nTitleKey(it));
        _builder.append(_accessorField);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      String _description = it.getDescription();
      boolean _tripleNotEquals_1 = (null != _description);
      if (_tripleNotEquals_1) {
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._utils_qvto.i18nDescKey(it));
        _builder.append(_accessorField_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  protected CharSequence internal_i18n_values(final EntryBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _title = it.getTitle();
      boolean _tripleNotEquals = (null != _title);
      if (_tripleNotEquals) {
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._utils_qvto.i18nTitleKey(it), it.getTitle());
        _builder.append(_messageEntry);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      String _description = it.getDescription();
      boolean _tripleNotEquals_1 = (null != _description);
      if (_tripleNotEquals_1) {
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._utils_qvto.i18nDescKey(it), it.getDescription());
        _builder.append(_messageEntry_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence cleanStandardToolsHack(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Workaround for https://bugs.eclipse.org/bugs/show_bug.cgi?id=159289");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void cleanStandardTools(org.eclipse.gef.palette.PaletteRoot paletteRoot) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it = paletteRoot.getChildren().iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.palette.PaletteEntry entry = (org.eclipse.gef.palette.PaletteEntry) it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!\"standardGroup\".equals(entry.getId())) { ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("continue;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator it2 = ((org.eclipse.gef.palette.PaletteContainer) entry).getChildren().iterator(); it2.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gef.palette.PaletteEntry entry2 = (org.eclipse.gef.palette.PaletteEntry) it2.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (\"zoomTool\".equals(entry2.getId())) { ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("it2.remove();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else if (\"noteStack\".equals(entry2.getId())) { ");
    CharSequence _nonNLS_2 = this._common.nonNLS(1);
    _builder.append(_nonNLS_2, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("it2.remove();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else if (\"selectionTool\".equals(entry2.getId())) { ");
    CharSequence _nonNLS_3 = this._common.nonNLS(1);
    _builder.append(_nonNLS_3, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("it2.remove();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (paletteRoot.getDefaultEntry() == entry2) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("paletteRoot.setDefaultEntry(null);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence nodeToolEntry(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class ");
    String _nodeToolEntryGeneratedClassName = this.getNodeToolEntryGeneratedClassName();
    _builder.append(_nodeToolEntryGeneratedClassName);
    _builder.append(" extends ");
    String _defaultNodeToolEntryClassName = this.getDefaultNodeToolEntryClassName();
    _builder.append(_defaultNodeToolEntryClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private NodeToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super(title, description, elementTypes);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence linkToolEntry(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class ");
    String _linkToolEntryGeneratedClassName = this.getLinkToolEntryGeneratedClassName();
    _builder.append(_linkToolEntryGeneratedClassName);
    _builder.append(" extends ");
    String _defaultLinkToolEntryClassName = this.getDefaultLinkToolEntryClassName();
    _builder.append(_defaultLinkToolEntryClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private LinkToolEntry(String title, String description, java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> elementTypes) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super(title, description, elementTypes);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public boolean shouldGenerateToolEntryClasses() {
    return false;
  }

  public CharSequence setIdentity(final EntryBase it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(toolVarName);
        _builder.append(".setId(");
        String _id = it.getId();
        _builder.append(_id);
        _builder.append(");");
        {
          if ((it.getId().startsWith("\"") && it.getId().endsWith("\""))) {
            _builder.append(" ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append(_nonNLS);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence generateCreateTool(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gef.Tool createTool(String toolId) {");
    _builder.newLine();
    {
      Iterable<AbstractToolEntry> _collectTools = this._utils_qvto.collectTools(it);
      for(final AbstractToolEntry tool : _collectTools) {
        _builder.append("\t\t");
        CharSequence _checkToolID = this.checkToolID(tool);
        _builder.append(_checkToolID, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("// default return: null");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence checkToolID(final AbstractToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (toolId.equals(");
    String _constantIDName = this._utils_qvto.getConstantIDName(it.getId());
    _builder.append(_constantIDName);
    _builder.append(")) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence generateGetTemplate(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public Object getTemplate(String templateId) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// default return: null");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence generateIDAttribute(final AbstractToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private final static String ");
    String _constantIDName = this._utils_qvto.getConstantIDName(it.getId());
    _builder.append(_constantIDName);
    _builder.append(" = ");
    String _id = it.getId();
    _builder.append(_id);
    _builder.append(";");
    {
      boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
      if (_isQuoted) {
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append(_nonNLS);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence createTool(final AbstractToolEntry it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gef.Tool ");
    String _createMethodName = it.getCreateMethodName();
    _builder.append(_createMethodName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _newTool = this.newTool(((ToolEntry) it), "entry");
    _builder.append(_newTool, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newTool(final ToolEntry it, final String toolVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getElements().isEmpty();
      if (_isEmpty) {
        this._common_qvto.ERROR("no elements for tool generation (Palette)");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("java.util.List<org.eclipse.gmf.runtime.emf.type.core.IElementType> types = new java.util.ArrayList<");
        String _diamondOp = this._codeStyle.diamondOp(it.getElements().get(0), "org.eclipse.gmf.runtime.emf.type.core.IElementType");
        _builder.append(_diamondOp);
        _builder.append(">(");
        int _size = it.getElements().size();
        _builder.append(_size);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        {
          EList<GenCommonBase> _elements = it.getElements();
          for(final GenCommonBase e : _elements) {
            _builder.append("\t");
            _builder.append("types.add(");
            CharSequence _accessElementType = this.xptElementTypes.accessElementType(e);
            _builder.append(_accessElementType, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.gef.Tool tool = new org.eclipse.papyrus.uml.diagram.common.service.");
        {
          boolean _isEmpty_1 = it.getGenNodes().isEmpty();
          if (_isEmpty_1) {
            _builder.append("AspectUnspecifiedTypeConnectionTool");
          } else {
            _builder.append("AspectUnspecifiedTypeCreationTool");
          }
        }
        _builder.append("(types);");
        _builder.newLineIfNotEmpty();
        _builder.append("return tool;");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence addEntry(final ToolGroupItem it, final String varName) {
    if (it instanceof AbstractToolEntry) {
      return _addEntry((AbstractToolEntry)it, varName);
    } else if (it instanceof Separator) {
      return _addEntry((Separator)it, varName);
    } else if (it instanceof ToolGroup) {
      return _addEntry((ToolGroup)it, varName);
    } else if (it != null) {
      return _addEntry(it, varName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, varName).toString());
    }
  }

  public CharSequence newEntry(final AbstractToolEntry it, final String toolVarName) {
    if (it instanceof StandardEntry) {
      return _newEntry((StandardEntry)it, toolVarName);
    } else if (it instanceof ToolEntry) {
      return _newEntry((ToolEntry)it, toolVarName);
    } else if (it != null) {
      return _newEntry(it, toolVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, toolVarName).toString());
    }
  }

  public CharSequence i18nTitle(final EObject it) {
    if (it instanceof ToolEntry) {
      return _i18nTitle((ToolEntry)it);
    } else if (it instanceof ToolGroup) {
      return _i18nTitle((ToolGroup)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence i18nDesc(final EObject it) {
    if (it instanceof ToolEntry) {
      return _i18nDesc((ToolEntry)it);
    } else if (it instanceof ToolGroup) {
      return _i18nDesc((ToolGroup)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
