/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.transformation;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ILocationStrategy;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.External;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Activator;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Messages;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppLocationStrategy;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassifierGenerator;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppPackageHeaderGenerator;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ManualGeneration;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CppModelElementsCreator
extends ModelElementsCreator {
    public static final String LANGUAGE_NAME = "C++";
    protected String sourceFolder;
    protected boolean formatCode;
    protected String hppExt;
    protected String cppExt;
    protected String commentHeader;

    public CppModelElementsCreator(IProject project) {
        this(project, FileSystemAccessFactory.create((IProject)project), null);
    }

    public CppModelElementsCreator(IProject project, String commentHeader) {
        this(project, FileSystemAccessFactory.create((IProject)project), commentHeader);
    }

    public CppModelElementsCreator(IPFileSystemAccess fileSystemAccess, String commentHeader) {
        this(null, fileSystemAccess, commentHeader);
    }

    public CppModelElementsCreator(IProject project, IPFileSystemAccess fileSystemAccess, String commentHeader) {
        super(fileSystemAccess, (ILocationStrategy)new CppLocationStrategy(), LANGUAGE_NAME);
        this.project = project;
        this.commentHeader = commentHeader != null ? commentHeader : CppCodeGenUtils.getCommentHeader();
        this.hppExt = CppCodeGenUtils.getHeaderSuffix();
        this.cppExt = CppCodeGenUtils.getBodySuffix();
        this.formatCode = CppCodeGenUtils.getFormatCode();
        this.sourceFolder = null;
    }

    protected void createPackageableElementFile(PackageableElement element, IProgressMonitor monitor) {
        if (element instanceof Package) {
            this.generatePkg((Package)element);
        } else if (!(element instanceof PrimitiveType || element instanceof Enumeration || element instanceof Usage || element instanceof ValueSpecification)) {
            if (element instanceof Classifier) {
                this.generateClassifier((Classifier)element);
            } else if (!(element instanceof Relationship || element instanceof Signal || element instanceof SignalEvent)) {
                Activator.log.debug("C++ code generator: unsupported model element " + String.valueOf(element));
            }
        }
    }

    protected void generateClassifier(Classifier classifier) {
        if (GenUtils.hasStereotype((Element)classifier, ManualGeneration.class)) {
            ManualGeneration mg = (ManualGeneration)UMLUtil.getStereotypeApplication((Element)classifier, ManualGeneration.class);
            Include cppInclude = (Include)UMLUtil.getStereotypeApplication((Element)classifier, Include.class);
            String fileContentH = this.commentHeader + cppInclude.getHeader();
            String fileNameH = this.getFileName((NamedElement)classifier) + "." + this.hppExt;
            this.generateFile(fileNameH, fileContentH);
            String fileContentB = this.commentHeader + cppInclude.getPreBody() + GenUtils.NL + cppInclude.getBody() + GenUtils.NL;
            String ext = GenUtils.maskNull((String)mg.getExtensionBody());
            if (ext.length() == 0) {
                ext = this.cppExt;
            }
            String fileNameB = this.getFileName((NamedElement)classifier) + "." + ext;
            this.generateFile(fileNameB, fileContentB);
        } else if (!(this.noCodeGen((Element)classifier) || GenUtils.hasStereotype((Element)classifier, Template.class) || classifier instanceof Association)) {
            if (GenUtils.isTemplateBoundElement((Classifier)classifier)) {
                String bindHeaderFileName = this.getFileName((NamedElement)classifier) + "." + this.hppExt;
                this.generateFile(bindHeaderFileName, this.commentHeader + String.valueOf(CppClassifierGenerator.generateBindHeaderCode(classifier)));
                String bindBodyFileName = this.getFileName((NamedElement)classifier) + "." + this.cppExt;
                this.generateFile(bindBodyFileName, this.commentHeader + String.valueOf(CppClassifierGenerator.generateBindBodyCode(classifier)));
            } else {
                String classHeaderFileName = this.getFileName((NamedElement)classifier) + "." + this.hppExt;
                this.generateFile(classHeaderFileName, this.commentHeader + String.valueOf(CppClassifierGenerator.generateClassHeaderCode(classifier)));
                if (classifier instanceof Class) {
                    String classBodyFileName = this.getFileName((NamedElement)classifier) + "." + this.cppExt;
                    this.generateFile(classBodyFileName, this.commentHeader + String.valueOf(CppClassifierGenerator.generateClassBodyCode(classifier)));
                }
            }
        }
    }

    public String getFileName(NamedElement element) {
        if (this.sourceFolder == null) {
            this.sourceFolder = GenUtils.getSourceFolder((Element)element);
        }
        return this.sourceFolder + this.locStrategy.getFileName(element);
    }

    protected void generatePkg(Package pkg) {
        String fileName = this.getFileName((NamedElement)pkg) + "." + this.hppExt;
        this.generateFile(fileName, CppPackageHeaderGenerator.generateCode(pkg).toString());
    }

    protected void generateFile(String fileName, String content) {
        if (this.formatCode) {
            if (this.fileSystemAccess instanceof IFileExists) {
                if (!((IFileExists)this.fileSystemAccess).existsFile(fileName)) {
                    this.fileSystemAccess.generateFile(fileName, "");
                }
            } else {
                this.fileSystemAccess.generateFile(fileName, "");
            }
            this.fileSystemAccess.generateFile(fileName, this.format(fileName, content));
        } else {
            this.fileSystemAccess.generateFile(fileName, content);
        }
    }

    protected String format(String fileName, String content) {
        Document doc;
        CodeFormatter codeFormatter;
        TextEdit edit;
        if (Platform.getBundle((String)"org.eclipse.cdt.core") == null) {
            return content;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.putAll(CCorePlugin.getOptions());
        if (this.project != null) {
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences ref = scope.getNode("org.eclipse.cdt.core");
            for (String key : options.keySet()) {
                String value;
                if (!key.startsWith("org.eclipse.cdt.core.formatter") || (value = ref.get(key, "")) == null || value.length() <= 0) continue;
                options.put(key, value);
            }
        }
        if ((edit = (codeFormatter = ToolFactory.createCodeFormatter(options)).format(8, (doc = new Document(content)).get(), 0, doc.get().length(), 0, null)) == null) {
            Activator.log.info(Messages.CppModelElementsCreator_CannotFormatContent);
            return content;
        }
        try {
            edit.apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            Activator.log.error((Throwable)e);
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    protected boolean noCodeGen(Element element) {
        if (GenUtils.hasStereotype((Element)element, NoCodeGen.class) || GenUtils.hasStereotype((Element)element, External.class) || GenUtils.hasStereotypeTree((Element)element, ExternLibrary.class)) {
            return true;
        }
        return super.noCodeGen(element);
    }
}

