package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Create package level dependencies, i.e. from nearest package to the other nearest package.
 * Place these dependencies in a package "dependencies"
 */
@SuppressWarnings("all")
public class PkgDependencies {
  private static String depencyPkgName = "dependencies";

  /**
   * create a dependency (Usage) from the classifier that owns the examined operation to the passed supplier. The relationship
   * is created in the nearest package.
   * @param the target of the usage.
   */
  public static void createDependency(final NamedElement client, final NamedElement supplier) {
    if (((client != null) && (supplier != null))) {
      final org.eclipse.uml2.uml.Package from = client.getNearestPackage();
      final org.eclipse.uml2.uml.Package to = supplier.getNearestPackage();
      boolean _notEquals = (!Objects.equals(from, to));
      if (_notEquals) {
        List<Usage> usages = IterableExtensions.<Usage>toList(Iterables.<Usage>filter(from.getOwnedElements(), Usage.class));
        final Function1<Usage, Boolean> _function = (Usage it) -> {
          return Boolean.valueOf(it.getSuppliers().contains(to));
        };
        Usage usage = IterableExtensions.<Usage>head(IterableExtensions.<Usage>filter(usages, _function));
        if ((usage == null)) {
          usage = from.createUsage(to);
          ReverseUtils.setXmlID(usage);
        }
      }
    } else {
      System.err.println("should not happen");
    }
  }

  public static org.eclipse.uml2.uml.Package getDependencyPkg() {
    org.eclipse.uml2.uml.Package dependencyPkg = ReverseData.current.dependencyPkg;
    if ((dependencyPkg == null)) {
      final Model root = ReverseData.current.models.get(0);
      NamedElement _member = root.getMember(PkgDependencies.depencyPkgName);
      dependencyPkg = ((org.eclipse.uml2.uml.Package) _member);
      if ((dependencyPkg == null)) {
        dependencyPkg = root.createNestedPackage(PkgDependencies.depencyPkgName);
        ReverseData.current.dependencyPkg = dependencyPkg;
      }
    }
    return dependencyPkg;
  }
}
