/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.IStructureTemplateDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Using;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.CommentUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseData;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GetOrCreateP1 {
    public static void getOrCreateClassifiers(IParent parent) throws Exception {
        ICElement[] children = ReverseUtils.safeGetChilds(parent);
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            boolean _isActive = ReverseUtils.isActive(child);
            if (_isActive) {
                boolean _matched = false;
                if (child instanceof IStructure) {
                    _matched = true;
                    GetOrCreateP1.getOrCreateClassifier(child);
                    GetOrCreateP1.getOrCreateClassifiers((IParent)child);
                }
                if (!_matched && child instanceof IEnumeration) {
                    _matched = true;
                    GetOrCreateP1.getOrCreateClassifier(child);
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    GetOrCreateP1.getOrCreateClassifiers((IParent)child);
                }
                if (!_matched && child instanceof ITypeDef) {
                    _matched = true;
                    GetOrCreateP1.getOrCreateClassifier(child);
                }
                if (!_matched && child instanceof IUsing) {
                    _matched = true;
                }
                if (!_matched && child instanceof IInclude) {
                    _matched = true;
                    ITranslationUnit headerUnit = ReverseUtils.getTranslationUnitFromInclude((IInclude)child, ReverseData.current.project);
                    if (headerUnit != null && ReverseUtils.getSourceFolder((ICElement)headerUnit) != null) {
                        ReverseCpp2Uml.currentCpp2Uml().reverseHeader(headerUnit);
                    }
                }
            }
            ++i;
        }
        if (parent instanceof ISourceReference) {
            GetOrCreateP1.getOrCreateAlias((ISourceReference)parent);
        }
    }

    public static Type getOrCreateClassifier(ICElement ideclaration) {
        Map<ICElement, EObject> map;
        block29: {
            map = ReverseData.current.map;
            if (ideclaration.getElementType() == 65 || ideclaration.getElementType() == 83 || ideclaration.getElementType() == 63 || ideclaration.getElementType() == 67 || ideclaration.getElementType() == 69 || ideclaration.getElementType() == 85 || ideclaration instanceof ITypeDef || ideclaration instanceof IUsing) break block29;
            return null;
        }
        try {
            boolean _equals_2;
            IASTNode _parent;
            EObject _get;
            Classifier existing = null;
            Namespace container = ReverseUtils.getContainer(ideclaration);
            if (container instanceof DataType) {
                container = ((DataType)container).getNearestPackage();
            }
            if ((_get = map.get(ideclaration)) instanceof Classifier) {
                EObject _get_1 = map.get(ideclaration);
                existing = (Classifier)_get_1;
            }
            if (existing != null) {
                return existing;
            }
            boolean structIsClassLike = GetOrCreateP1.isClassLike(ideclaration);
            String name = ReverseUtils.stripTemplate(ideclaration.getElementName());
            IASTNode astNode = ASTUtils.findEnclosingNode((ISourceReference)ideclaration);
            boolean _equals = "".equals(name);
            if (_equals && (_parent = astNode.getParent()) instanceof IASTSimpleDeclaration) {
                boolean _greaterThan;
                IASTNode _parent_1 = astNode.getParent();
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)_parent_1;
                int _length = simpleDecl.getDeclarators().length;
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    name = simpleDecl.getDeclarators()[0].getName().toString();
                }
            }
            if (ideclaration instanceof ITypeDef) {
                Type typedef = GetOrCreateP1.createTypedef(container, (ITypeDef)ideclaration);
                if (typedef != null) {
                    map.put(ideclaration, (EObject)typedef);
                }
                return typedef;
            }
            if (ideclaration.getElementType() == 65 || ideclaration.getElementType() == 83 || structIsClassLike) {
                boolean _equals_1;
                IStructure iStructure = (IStructure)ideclaration;
                Class classifier = null;
                if (existing != null) {
                    classifier = (Class)existing;
                } else {
                    if (container instanceof Package) {
                        classifier = ((Package)container).createOwnedClass(name, false);
                    } else {
                        Classifier _createNestedClassifier = ((Class)container).createNestedClassifier(name, UMLPackage.Literals.CLASS);
                        classifier = (Class)_createNestedClassifier;
                    }
                    ReverseUtils.setXmlID((NamedElement)classifier);
                }
                map.put(ideclaration, (EObject)classifier);
                CommentUtils.addComment((Element)classifier, astNode);
                int _elementType = iStructure.getElementType();
                boolean bl = _equals_1 = _elementType == 83;
                if (_equals_1) {
                    IStructureTemplate istructureTemplate = (IStructureTemplate)iStructure;
                    Template template = (Template)StereotypeUtil.applyApp((Element)classifier, Template.class);
                    template.setDeclaration(istructureTemplate.getTemplateSignature());
                }
                return classifier;
            }
            if (!(structIsClassLike || ideclaration.getElementType() != 67 && ideclaration.getElementType() != 69 && ideclaration.getElementType() != 85)) {
                DataType dataType = null;
                if (existing != null) {
                    dataType = (DataType)existing;
                } else {
                    if (container instanceof Package) {
                        Type _createOwnedType = ((Package)container).createOwnedType(name, UMLPackage.Literals.DATA_TYPE);
                        dataType = (DataType)_createOwnedType;
                    } else {
                        Classifier _createNestedClassifier_1 = ((Class)container).createNestedClassifier(name, UMLPackage.Literals.DATA_TYPE);
                        dataType = (DataType)_createNestedClassifier_1;
                    }
                    ReverseUtils.setXmlID((NamedElement)dataType);
                }
                map.put(ideclaration, (EObject)dataType);
                CommentUtils.addComment((Element)dataType, astNode);
                return dataType;
            }
            int _elementType_1 = ideclaration.getElementType();
            boolean bl = _equals_2 = _elementType_1 == 63;
            if (_equals_2) {
                ICElement[] _children;
                Enumeration enumeration = null;
                IEnumeration iEnum = (IEnumeration)ideclaration;
                if (existing != null) {
                    enumeration = (Enumeration)existing;
                } else {
                    if (container instanceof Package) {
                        enumeration = ((Package)container).createOwnedEnumeration(name);
                    } else {
                        Classifier _createNestedClassifier_2 = ((Class)container).createNestedClassifier(name, UMLPackage.Literals.ENUMERATION);
                        enumeration = (Enumeration)_createNestedClassifier_2;
                    }
                    ReverseUtils.setXmlID((NamedElement)enumeration);
                }
                map.put(ideclaration, (EObject)enumeration);
                CommentUtils.addComment((Element)enumeration, astNode);
                GetOrCreateP1.getOrCreateClassifiers((IParent)iEnum);
                ICElement[] iCElementArray = _children = iEnum.getChildren();
                int n = _children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (child instanceof IEnumerator) {
                        EnumerationLiteral literal = enumeration.createOwnedLiteral(((IEnumerator)child).getElementName());
                        ReverseUtils.setXmlID((NamedElement)literal);
                        if (((IEnumerator)child).getConstantExpression() != null && !((IEnumerator)child).getConstantExpression().equals("")) {
                            ValueSpecification _createSpecification = literal.createSpecification("defaultVal-ue", (Type)literal.getEnumeration(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                            OpaqueExpression valueSpecification = (OpaqueExpression)_createSpecification;
                            valueSpecification.getLanguages().add((Object)ReverseCpp2Uml.Cpp_LangID);
                            valueSpecification.getBodies().add((Object)((IEnumerator)child).getConstantExpression());
                        }
                    }
                    ++n2;
                }
                return enumeration;
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClassLike(ICElement ideclaration) {
        try {
            if (ideclaration.getElementType() == 67 || ideclaration.getElementType() == 69 || ideclaration.getElementType() == 85) {
                IASTNode[] _children_1;
                ICElement[] _children;
                IStructure iStructure = (IStructure)ideclaration;
                ICElement[] iCElementArray = _children = iStructure.getChildren();
                int n = _children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    if (child instanceof IMethodDeclaration || child instanceof IStructure || child instanceof IStructureTemplateDeclaration) {
                        return true;
                    }
                    ++n2;
                }
                IASTNode node = ASTUtils.findEnclosingNode((ISourceReference)ideclaration);
                if (ideclaration instanceof IStructureTemplate) {
                    node = ASTUtils.getDeclSpecifier(node);
                }
                IASTNode[] iASTNodeArray = _children_1 = node.getChildren();
                int n3 = _children_1.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTNode child_1 = iASTNodeArray[n4];
                    if (child_1 instanceof ICPPASTAliasDeclaration) {
                        return true;
                    }
                    ++n4;
                }
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Type createTypedef(Namespace container, ITypeDef typedef) {
        block10: {
            try {
                ICElement _parent_1;
                ICElement childStruct;
                ICElement _parent;
                int pos;
                if (!Objects.equals(typedef.getTypeName(), "struct") && !Objects.equals(typedef.getTypeName(), "class") && !Objects.equals(typedef.getTypeName(), "enum") || (pos = ((List)Conversions.doWrapArray((Object)((IParent)(_parent = typedef.getParent())).getChildren())).indexOf(typedef)) <= 0 || !((childStruct = ((IParent)(_parent_1 = typedef.getParent())).getChildren()[pos - 1]) instanceof IStructure) && !(childStruct instanceof IEnumeration) || !Objects.equals(childStruct.getElementName(), "")) break block10;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        NamedElement _member = container.getMember(typedef.getElementName());
        Type primitiveType = (Type)_member;
        if (primitiveType != null) {
            return primitiveType;
        }
        PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
        Procedures.Procedure1 _function = it -> it.setName(typedef.getElementName());
        PrimitiveType _doubleArrow = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function);
        primitiveType = _doubleArrow;
        CommentUtils.addComment((Element)primitiveType, (ISourceReference)typedef);
        if (container instanceof Package) {
            EList _ownedTypes = ((Package)container).getOwnedTypes();
            _ownedTypes.add((Object)primitiveType);
        } else if (container instanceof Class && primitiveType instanceof Classifier) {
            EList _nestedClassifiers = ((Class)container).getNestedClassifiers();
            _nestedClassifiers.add((Object)((Classifier)primitiveType));
        } else {
            EList _ownedTypes_1 = container.getNearestPackage().getOwnedTypes();
            _ownedTypes_1.add((Object)primitiveType);
        }
        Typedef typedefSt = (Typedef)StereotypeUtil.applyApp((Element)primitiveType, Typedef.class);
        IASTNode typedefNode = ASTUtils.findEnclosingNode((ISourceReference)typedef);
        String rawSignature = typedefNode.getRawSignature().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
        Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
        Matcher matcher = pattern.matcher(rawSignature);
        boolean _find = matcher.find();
        if (_find) {
            String typeName = rawSignature.replaceFirst(Pattern.quote(typedef.getElementName()), "typeName");
            typedefSt.setDefinition(typeName);
        } else {
            typedefSt.setDefinition(typedef.getTypeName());
        }
        ReverseData.current.map.put((ICElement)typedef, (EObject)primitiveType);
        return primitiveType;
    }

    public static void getOrCreateAlias(ISourceReference sourceRef) {
        IASTNode[] _children;
        Namespace container = ReverseUtils.getContainer((ICElement)sourceRef, true);
        IASTNode node = ASTUtils.findEnclosingNode(sourceRef);
        if (node == null) {
            return;
        }
        if (sourceRef instanceof IStructureTemplate) {
            IASTDeclSpecifier declSpecifier = ASTUtils.getDeclSpecifier(node);
            if (declSpecifier != null) {
                node = declSpecifier;
            } else if (!(node instanceof IASTMacroExpansionLocation)) {
                System.err.println("not in macro?? should not happen");
            }
        }
        IASTNode[] iASTNodeArray = _children = node.getChildren();
        int n = _children.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration;
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof ICPPASTAliasDeclaration) {
                GetOrCreateP1.getOrCreateAlias((ICPPASTAliasDeclaration)child, container);
            }
            if (child instanceof ICPPASTTemplateDeclaration && (declaration = ((ICPPASTTemplateDeclaration)child).getDeclaration()) instanceof ICPPASTAliasDeclaration) {
                GetOrCreateP1.getOrCreateAlias((ICPPASTAliasDeclaration)declaration, container);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getOrCreateAlias(ICPPASTAliasDeclaration aliasDecl, Namespace container) {
        String aliasName;
        NamedElement aliasPT;
        Object definition = "";
        try {
            IToken token = aliasDecl.getMappingTypeId().getSyntax();
            block2: while (token != null) {
                while (true) {
                    String _definition;
                    if (token.getOffset() <= ((String)definition).length()) {
                        _definition = definition;
                        String _string = token.toString();
                        definition = _definition + _string;
                        token = token.getNext();
                        continue block2;
                    }
                    _definition = definition;
                    definition = _definition + " ";
                }
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof ExpansionOverlapsBoundaryException)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            definition = aliasDecl.getMappingTypeId().getDeclSpecifier().toString();
        }
        if ((aliasPT = container.getMember(aliasName = aliasDecl.getAlias().toString())) == null) {
            if (container instanceof Package) {
                aliasPT = ((Package)container).createOwnedPrimitiveType(aliasName);
            } else if (container instanceof Class) {
                aliasPT = ((Class)container).createNestedClassifier(aliasName, UMLPackage.eINSTANCE.getPrimitiveType());
            } else {
                System.err.println("should not happen");
            }
            ReverseUtils.setXmlID(aliasPT);
            Using usingSt = (Using)StereotypeUtil.applyApp((Element)aliasPT, Using.class);
            usingSt.setDefinition((String)definition);
        }
    }

    public static Classifier getOrCreateTemplateParameter(NamedElement element, String parameterTypeName, String keyWord) {
        Classifier ret = null;
        RedefinableTemplateSignature templateSignature = null;
        if (element instanceof Classifier) {
            Classifier classifier = (Classifier)element;
            if (classifier.getOwnedTemplateSignature() == null || !(classifier.getOwnedTemplateSignature() instanceof RedefinableTemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature = classifier.createOwnedTemplateSignature(UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE);
                templateSignature = (RedefinableTemplateSignature)_createOwnedTemplateSignature;
                templateSignature.setName("template_paremeter_signature");
            }
            TemplateSignature _ownedTemplateSignature = classifier.getOwnedTemplateSignature();
            templateSignature = (RedefinableTemplateSignature)_ownedTemplateSignature;
        } else if (element instanceof Operation) {
            Operation operation = (Operation)element;
            if (operation.getOwnedTemplateSignature() == null || !(operation.getOwnedTemplateSignature() instanceof TemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature_1 = operation.createOwnedTemplateSignature(UMLPackage.Literals.TEMPLATE_SIGNATURE);
                templateSignature = _createOwnedTemplateSignature_1;
            }
            TemplateSignature _ownedTemplateSignature_1 = operation.getOwnedTemplateSignature();
            templateSignature = _ownedTemplateSignature_1;
        } else {
            return null;
        }
        Iterable classifierTemplates = Iterables.filter((Iterable)templateSignature.getOwnedParameters(), ClassifierTemplateParameter.class);
        Functions.Function1 _function = it -> {
            ParameterableElement _ownedParameteredElement = it.getOwnedParameteredElement();
            return _ownedParameteredElement instanceof Classifier;
        };
        Iterable classifierTemplatesContainClassifier = IterableExtensions.filter((Iterable)classifierTemplates, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getOwnedParameteredElement();
        Iterable containedClassifiers = IterableExtensions.map((Iterable)classifierTemplatesContainClassifier, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.getName().equals(parameterTypeName);
        ret = (Classifier)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)containedClassifiers, Classifier.class), (Functions.Function1)_function_2));
        if (ret == null) {
            TemplateParameter _createOwnedParameter = templateSignature.createOwnedParameter(UMLPackage.Literals.CLASSIFIER_TEMPLATE_PARAMETER);
            ClassifierTemplateParameter classifierTemplate = (ClassifierTemplateParameter)_createOwnedParameter;
            ParameterableElement _createOwnedParameteredElement = classifierTemplate.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
            ret = (Classifier)_createOwnedParameteredElement;
            ret.setName(parameterTypeName);
            classifierTemplate.addKeyword(keyWord);
        }
        return ret;
    }
}

