/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ASTUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.GetOrCreateP1;
import org.eclipse.papyrus.designer.languages.cpp.reverse.GetOrCreateP2;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseData;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.ModelManagement;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ReverseUtils {
    public static final Logger LOGGER = Logger.getLogger(ReverseCpp2Uml.class.getName());
    public static final String Cpp_LangID = "C++";
    public static final ICElement[] EMPTY_CHILDS = new ICElement[0];
    public static final String TEMPLATE_PARAMETER_SIGNATURE_NAME = "template_paremeter_signature";

    public static void analyzeDeclaration(List<IASTDeclarator> declarators, Type type, TypedElement typedElement, String langID) {
        for (IASTDeclarator declarator : declarators) {
            ReverseUtils.analyzeDeclaration(declarator, type, typedElement, langID);
        }
    }

    public static void analyzeDeclaration(IASTDeclarator declarator, Type type, TypedElement typedElement, String langID) {
        try {
            IASTPointerOperator[] _pointerOperators;
            boolean _tripleNotEquals;
            Object _function;
            if (declarator instanceof ICPPASTArrayDeclarator) {
                boolean _greaterThan;
                ICPPASTArrayDeclarator arrayDeclarator = (ICPPASTArrayDeclarator)declarator;
                IASTArrayModifier[] arrays = arrayDeclarator.getArrayModifiers();
                IASTArrayModifier[] _converted_arrays = arrays;
                int _size = ((List)Conversions.doWrapArray((Object)_converted_arrays)).size();
                boolean bl = _greaterThan = _size > 0;
                if (_greaterThan) {
                    Array array = (Array)StereotypeUtil.applyApp((Element)typedElement, Array.class);
                    array.setDefinition("");
                    IASTArrayModifier[] _converted_arrays_1 = arrays;
                    _function = it -> {
                        IASTExpression expr = it.getConstantExpression();
                        if (expr != null) {
                            String _definition = array.getDefinition();
                            String _plus = _definition + "[";
                            String _string = expr.toString();
                            String _plus_1 = _plus + _string;
                            String _plus_2 = _plus_1 + "]";
                            array.setDefinition(_plus_2);
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_converted_arrays_1)).forEach(_function);
                }
            }
            boolean bl = _tripleNotEquals = (_pointerOperators = declarator.getPointerOperators()) != null;
            if (_tripleNotEquals) {
                Pattern pattern;
                Matcher matcher;
                boolean _find;
                Ref refStereo_1;
                boolean _isApplied_2;
                Ptr ptrStereo_1;
                IASTPointerOperator[] _pointerOperators_1;
                boolean _isApplied = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied) {
                    Ptr _stereotypeApplication = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class);
                    _stereotypeApplication.setDeclaration("");
                }
                _function = _pointerOperators_1 = declarator.getPointerOperators();
                int _converted_arrays_1 = _pointerOperators_1.length;
                int array = 0;
                while (array < _converted_arrays_1) {
                    IASTPointerOperator pointerOperator = _function[array];
                    if (pointerOperator instanceof ICPPASTReferenceOperator) {
                        ICPPASTReferenceOperator reference = (ICPPASTReferenceOperator)pointerOperator;
                        Ref refStereo = (Ref)StereotypeUtil.applyApp((Element)typedElement, Ref.class);
                        refStereo.setDeclaration(reference.getSyntax().toString());
                    } else if (pointerOperator instanceof IASTPointerOperator) {
                        IASTPointerOperator pointer = pointerOperator;
                        Ref ptrStereo = (Ref)StereotypeUtil.applyApp((Element)typedElement, Ref.class);
                        if (ptrStereo != null) {
                            String _declaration = ptrStereo.getDeclaration();
                            String _string = pointer.getSyntax().toString();
                            String _plus = _declaration + _string;
                            ptrStereo.setDeclaration(_plus);
                        } else {
                            System.err.println("Hallo???");
                        }
                    }
                    ++array;
                }
                boolean _isApplied_1 = StereotypeUtil.isApplied((Element)typedElement, Ptr.class);
                if (_isApplied_1 && (ptrStereo_1 = (Ptr)UMLUtil.getStereotypeApplication((Element)typedElement, Ptr.class)).getDeclaration() != null && ptrStereo_1.getDeclaration().trim().equals("*")) {
                    ptrStereo_1.setDeclaration(null);
                }
                if ((_isApplied_2 = StereotypeUtil.isApplied((Element)typedElement, Ref.class)) && (refStereo_1 = (Ref)UMLUtil.getStereotypeApplication((Element)typedElement, Ref.class)).getDeclaration() != null && refStereo_1.getDeclaration().trim().equals("&")) {
                    refStereo_1.setDeclaration(null);
                }
                if (_find = (matcher = (pattern = Pattern.compile("(\\*)([\\s]*)(const)")).matcher(declarator.getRawSignature())).find()) {
                    StereotypeUtil.applyApp((Element)typedElement, Const.class);
                }
            }
            IASTInitializer initilizer = declarator.getInitializer();
            Functions.Function1 _function_1 = it -> it.getName().equals("defaultValue");
            ValueSpecification valueExisting = (ValueSpecification)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)typedElement.getOwnedElements(), ValueSpecification.class), (Functions.Function1)_function_1));
            if (valueExisting != null) {
                valueExisting.destroy();
            }
            if (initilizer != null) {
                IASTEqualsInitializer equalsInitialiser;
                IASTInitializerClause clause;
                ValueSpecification vs = null;
                if (typedElement instanceof Property) {
                    vs = ((Property)typedElement).createDefaultValue("defaultValue", ((Property)typedElement).getType(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                } else if (typedElement instanceof Parameter) {
                    vs = ((Parameter)typedElement).createDefaultValue("default", ((Parameter)typedElement).getType(), UMLPackage.Literals.OPAQUE_EXPRESSION);
                }
                if (vs == null) {
                    return;
                }
                OpaqueExpression oe = (OpaqueExpression)vs;
                oe.getLanguages().add((Object)langID);
                if (initilizer instanceof IASTEqualsInitializer && (clause = (equalsInitialiser = (IASTEqualsInitializer)initilizer).getInitializerClause()) != null) {
                    oe.getBodies().add((Object)clause.getRawSignature());
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getCppTypeName(String name) {
        String trimName = name.trim();
        trimName = trimName.replace("*", "");
        trimName = trimName.replace("&", "");
        trimName = trimName.replace("[", "");
        trimName = trimName.replace("]", "");
        trimName = trimName.replace("const ", "");
        trimName = trimName.replace(" const", "");
        trimName = trimName.replace("volatile", "");
        trimName = trimName.replace(" volatile", "");
        trimName = trimName.trim();
        return trimName;
    }

    public static List<ICElement> getAllIStructures(IParent parent, boolean allIncludes, boolean lookNestedTypes, ICProject project) {
        UniqueEList ret = new UniqueEList();
        ICElement[] children = ReverseUtils.safeGetChilds(parent);
        int i = 0;
        while (i < children.length) {
            ICElement child = children[i];
            boolean _matched = false;
            if (child instanceof IStructure) {
                _matched = true;
                ret.add((IStructure)child);
                if (lookNestedTypes) {
                    ret.addAll(ReverseUtils.getAllIStructures((IParent)((IStructure)child), allIncludes, lookNestedTypes, project));
                }
            }
            if (!_matched && child instanceof IEnumeration) {
                _matched = true;
                ret.add((IEnumeration)child);
            }
            if (!_matched && child instanceof IParent) {
                _matched = true;
                ret.addAll(ReverseUtils.getAllIStructures((IParent)child, allIncludes, lookNestedTypes, project));
            }
            if (!_matched && child instanceof IInclude) {
                ITranslationUnit unit;
                _matched = true;
                if (allIncludes && (unit = ReverseUtils.getTranslationUnitFromInclude((IInclude)child, project)) != null) {
                    ret.addAll(ReverseUtils.getAllIStructures((IParent)unit, allIncludes, lookNestedTypes, project));
                }
            }
            if (!_matched && child instanceof ITypeDef) {
                _matched = true;
                ret.add(child);
            }
            if (!_matched && child instanceof IStructureDeclaration) {
                _matched = true;
                ret.add(child);
            }
            ++i;
        }
        return ret;
    }

    public static ITranslationUnit getTranslationUnitFromInclude(IInclude include, ICProject cproject) {
        try {
            boolean _tripleNotEquals;
            String _fullFileName = include.getFullFileName();
            boolean bl = _tripleNotEquals = _fullFileName != null;
            if (_tripleNotEquals) {
                ITranslationUnit tu = ReverseUtils.getTranslationUnitFromPath(include.getFullFileName(), include.getCProject());
                if (tu == null) {
                    ICProject[] _cProjects;
                    ICModel cModel = CoreModel.getDefault().getCModel();
                    ICProject[] iCProjectArray = _cProjects = cModel.getCProjects();
                    int n = _cProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICProject otherCProject = iCProjectArray[n2];
                        tu = ReverseUtils.getTranslationUnitFromPath(include.getFullFileName(), otherCProject);
                        if (tu != null) {
                            boolean _tripleEquals;
                            Model _correspondingModel = ReverseUtils.getCorrespondingModel(tu);
                            boolean bl2 = _tripleEquals = _correspondingModel == null;
                            if (_tripleEquals) {
                                ModelManagement modelManager = ReverseData.current.modelManager;
                                IProject _project = cproject.getProject();
                                String _elementName = otherCProject.getElementName();
                                String _plus = _elementName + ".uml";
                                String umlFilePath = modelManager.getPath(_project, "reversed_models", _plus);
                                boolean reset = false;
                                modelManager.createOrgetModel(otherCProject.getElementName(), umlFilePath, true, false);
                                Model model = ReverseUtils.getCorrespondingModel(tu);
                                RoundtripCppUtils.applyProfile(model, "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml");
                                RoundtripCppUtils.applyProfile(model, "pathmap://UML_PROFILES/Standard.profile.uml");
                                ReverseUtils.setXmlID((NamedElement)model);
                            }
                            return tu;
                        }
                        ++n2;
                    }
                }
                return tu;
            }
            LOGGER.log(Level.WARNING, String.format("path of \"%s\" include cannot be resolved", include.getElementName()));
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ITranslationUnit getTranslationUnitFromPath(String fullFileName, ICProject cproject) {
        boolean _not;
        IPath fullProjectPath = cproject.getProject().getLocation();
        boolean _contains = fullFileName.contains(fullProjectPath.toString());
        boolean bl = _not = !_contains;
        if (_not) {
            return null;
        }
        ITranslationUnit ret = null;
        String fileIncludePath = (String)IterableExtensions.lastOrNull((Iterable)((Iterable)Conversions.doWrapArray((Object)fullFileName.split(fullProjectPath.toString()))));
        IFile file = cproject.getProject().getFile(fileIncludePath);
        if (file != null) {
            ITranslationUnit unit = CoreModelUtil.findTranslationUnit((IFile)file);
            if (unit == null) {
                unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, file.getLocation());
            }
            ret = unit;
        }
        return ret;
    }

    public static ITranslationUnit getTranslationUnitFromElement(ICElement element) {
        ICElement owner = element;
        while (owner != null && !(owner instanceof ITranslationUnit)) {
            owner = owner.getParent();
        }
        return (ITranslationUnit)owner;
    }

    public static void unapplyAllStereotypes(Element element) {
        EList stereotypeAppList = element.getStereotypeApplications();
        Consumer<EObject> _function = it -> {
            Stereotype stereotype = UMLUtil.getStereotype((EObject)it);
            element.unapplyStereotype(stereotype);
        };
        stereotypeAppList.forEach(_function);
    }

    public static Stereotype applyStereotype(Element element, boolean doApply, Class<? extends EObject> clazz) {
        Stereotype _xifexpression = null;
        if (doApply) {
            _xifexpression = StereotypeUtil.apply((Element)element, clazz);
        }
        return _xifexpression;
    }

    public static Type getUMLType(IASTDeclSpecifier declSpecifier, ICElement context) {
        Type ret = null;
        ret = ReverseUtils.getUMLType(ASTUtils.getQualifiedName(declSpecifier), context);
        return ret;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type getUMLType(String typeName, ICElement context) {
        void var22_30;
        void var22_28;
        String simpleTypeName;
        Classifier ret;
        block13: {
            Functions.Function1 _function_1;
            Iterable structureTemplates;
            IStructureTemplate match;
            Functions.Function1 _function;
            ITranslationUnit itu;
            block12: {
                try {
                    itu = ReverseUtils.getTranslationUnitFromElement(context);
                    boolean _isPrimitiveCppType = RoundtripCppUtils.isPrimitiveCppType(typeName);
                    if (_isPrimitiveCppType) {
                        return RoundtripCppUtils.getPrimitiveType(typeName, ReverseUtils.getCorrespondingModel(itu));
                    }
                    if (typeName != null) break block12;
                    return null;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            Model containerPkg = ReverseUtils.getCorrespondingModel(itu);
            String strippedTypeName = ReverseUtils.stripTemplate(typeName);
            String _name = containerPkg.getName();
            String _plus = _name + "::*::";
            String qName = _plus + strippedTypeName;
            NamedElement candidate1 = ElementUtils.getQualifiedElement((Package)containerPkg, (String)qName);
            if (candidate1 instanceof Type) {
                return (Type)candidate1;
            }
            ret = null;
            ICProject project = ReverseData.current.project;
            String[] token = strippedTypeName.split("::");
            int _length = token.length;
            int _minus = _length - 1;
            simpleTypeName = token[_minus].trim();
            List<ICElement> nestedStructures = ReverseUtils.getAllIStructures((IParent)itu, false, true, project);
            ICElement sameNameType = (ICElement)IterableExtensions.head((Iterable)IterableExtensions.filter(nestedStructures, (Functions.Function1)(_function = it -> it.getElementName().trim().equals(simpleTypeName.trim()))));
            if (sameNameType == null && (match = (IStructureTemplate)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)(structureTemplates = Iterables.filter(nestedStructures, IStructureTemplate.class)), (Functions.Function1)(_function_1 = it -> {
                Functions.Function1 _function_2 = it_1 -> it_1.equals(simpleTypeName);
                int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getTemplateParameterTypes())), (Functions.Function1)_function_2));
                return _size > 0;
            })))) != null) {
                Type type = GetOrCreateP2.getClassifier((ICElement)match);
                ret = GetOrCreateP1.getOrCreateTemplateParameter((NamedElement)((Classifier)type), simpleTypeName, "class");
            }
            if (ret != null) return ret;
            boolean _startsWith = typeName.startsWith("ecl");
            if (_startsWith) {
                System.err.println("what happened");
            }
            Package externalPkg = RoundtripCppUtils.getOrcreateExternalPackage((Package)ReverseUtils.getCorrespondingModel(itu), true);
            String containerQName = ReverseUtils.stripLastQName(typeName);
            Object var22_25 = null;
            if (containerQName != null) {
                Namespace namespace = ReverseUtils.getContainer(externalPkg, containerQName);
            } else {
                Package package_ = externalPkg;
            }
            NamedElement candidate = var22_28.getMember(simpleTypeName);
            if (candidate instanceof Type) {
                NamedElement _member = var22_28.getMember(simpleTypeName);
                ret = (Type)_member;
                break block13;
            }
            if (candidate == null) break block13;
            System.err.println("A non type member of same name exists, This should not happen");
            return null;
        }
        if (ret != null) return ret;
        LOGGER.log(Level.WARNING, typeName + " is not found, it will be created dynamically");
        if (!(var22_28 instanceof Package)) {
            Package package_ = var22_28.getNearestPackage();
        }
        ret = ((Package)var22_30).createOwnedType(simpleTypeName, UMLPackage.Literals.DATA_TYPE);
        StereotypeUtil.apply((Element)ret, External.class);
        return ret;
    }

    public static Classifier getTypeOfVariableOrMethod(ICElement element, ITranslationUnit translationUnit) {
        Type type;
        String qName;
        if ((element instanceof IVariableDeclaration || element instanceof IMethod) && (qName = ASTUtils.getQualifiedName((ISourceReference)element)) != null && (type = ReverseUtils.getUMLType(ReverseUtils.stripTemplate(qName), (ICElement)translationUnit)) instanceof Classifier) {
            return (Classifier)type;
        }
        return null;
    }

    public static boolean isActive(ICElement element) {
        if (element instanceof ISourceReference) {
            return ((ISourceReference)element).isActive();
        }
        return false;
    }

    public static String stripTemplate(String name) {
        if (name != null) {
            int LT = 60;
            int GT = 62;
            int openIdx = name.indexOf(60);
            if (openIdx != -1) {
                int count = 1;
                int closeIdx = openIdx + 1;
                while (count > 0 && closeIdx < name.length()) {
                    char ch = name.charAt(closeIdx);
                    if (ch == '<') {
                        ++count;
                    } else if (ch == '>') {
                        --count;
                    }
                    ++closeIdx;
                }
                if (count == 0) {
                    String _substring = name.substring(0, openIdx);
                    String _substring_1 = name.substring(closeIdx);
                    String _plus = _substring + _substring_1;
                    return ReverseUtils.stripTemplate(_plus);
                }
            }
        }
        return name;
    }

    public static String stripLastQName(String qName) {
        int idx;
        if (qName != null && (idx = qName.lastIndexOf("::")) != -1) {
            return qName.substring(0, idx);
        }
        return null;
    }

    public static Model getCorrespondingModel(ITranslationUnit unit) {
        Model ret = null;
        for (Model model : ReverseData.current.models) {
            boolean _contains = unit.getPath().toString().contains(model.getName());
            if (!_contains) continue;
            ret = model;
        }
        return ret;
    }

    public static Namespace getContainer(ICElement element) {
        return ReverseUtils.getContainer(element, false);
    }

    public static Namespace getContainer(ICElement element, boolean forAlias) {
        ITranslationUnit tu = ReverseUtils.getTranslationUnitFromElement(element);
        Object qName = null;
        ISourceRoot _sourceFolder = ReverseUtils.getSourceFolder((ICElement)tu);
        boolean _tripleEquals = _sourceFolder == null;
        qName = _tripleEquals ? "external" : ReverseUtils.getSourceFolder((ICElement)tu).getElementName();
        String qNameSR = null;
        if (forAlias) {
            qNameSR = ASTUtils.getQualifiedName((ISourceReference)element);
        } else if (element instanceof ITypeDef) {
            ICElement _parent = ((ITypeDef)element).getParent();
            qNameSR = ASTUtils.getQualifiedName((ISourceReference)_parent);
        } else {
            qNameSR = ReverseUtils.stripLastQName(ASTUtils.getQualifiedName((ISourceReference)element));
        }
        if (qNameSR != null) {
            qName = (String)qName + "::" + qNameSR;
        }
        return ReverseUtils.getContainer((Package)ReverseUtils.getCorrespondingModel(tu), (String)qName);
    }

    public static Namespace getContainer(Package parent, String qName) {
        String[] _split;
        if (parent == null) {
            return null;
        }
        Package parentPack = parent;
        String[] stringArray = _split = qName.split("::");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _tripleEquals;
            String name = stringArray[n2];
            NamedElement _member = parentPack.getMember(name);
            boolean bl = _tripleEquals = _member == null;
            if (_tripleEquals) {
                if (parentPack instanceof Package) {
                    boolean _equals = name.equals("UmsConfig");
                    if (_equals) {
                        System.err.println("debug");
                    }
                    Package pkg = parentPack.createNestedPackage(name);
                    ReverseUtils.setXmlID((NamedElement)pkg);
                } else {
                    System.err.println("should not happen");
                    return parentPack;
                }
            }
            NamedElement _member_1 = parentPack.getMember(name);
            parentPack = (Namespace)_member_1;
            ++n2;
        }
        return parentPack;
    }

    public static ISourceRoot getSourceFolder(ICElement parent) {
        ICElement sf = parent;
        while (sf != null) {
            if (sf instanceof ISourceRoot) {
                return (ISourceRoot)sf;
            }
            sf = sf.getParent();
        }
        return null;
    }

    public static String getExcludedIncludesMapKey(ITranslationUnit translationUnit, Element umlElement) {
        int _hashCode = translationUnit.hashCode();
        String _plus = String.valueOf((Object)_hashCode);
        int _hashCode_1 = umlElement.hashCode();
        return _plus + String.valueOf((Object)_hashCode_1);
    }

    public static List<Map.Entry<ICElement, EObject>> getElementsSameName(String name) {
        Functions.Function1 _function = it -> ((ICElement)it.getKey()).getElementName().equals(name);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(ReverseData.current.map.entrySet(), (Functions.Function1)_function));
    }

    public static ICElement lookTypeInContainer(ICContainer container, String typeName) {
        ICElement[] _safeGetChilds;
        ICElement ret = null;
        ICElement[] iCElementArray = _safeGetChilds = ReverseUtils.safeGetChilds((IParent)container);
        int n = _safeGetChilds.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof ITranslationUnit) {
                List<ICElement> nesteds = ReverseUtils.getAllIStructures((IParent)child, false, true, ReverseData.current.project);
                Functions.Function1 _function = it -> it instanceof IStructure || it instanceof IEnumeration || it instanceof ITypeDef;
                Functions.Function1 _function_1 = it -> it.getElementName().equals(typeName);
                ret = (ICElement)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(nesteds, (Functions.Function1)_function), (Functions.Function1)_function_1));
            } else if (child instanceof ICContainer) {
                ret = ReverseUtils.lookTypeInContainer((ICContainer)child, typeName);
            }
            if (ret != null) {
                return ret;
            }
            ++n2;
        }
        return ret;
    }

    public static Type lookForATypeByName(String typeName) {
        try {
            Type ret = null;
            ICElement cType = null;
            for (ICContainer container : ReverseData.current.containers) {
                if (cType != null) continue;
                cType = ReverseUtils.lookTypeInContainer(container, typeName);
            }
            if (cType != null) {
                ret = GetOrCreateP2.getClassifier(cType);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean isSimpleAssociation(Property prop) {
        return (StereotypeUtil.isApplied((Element)prop, Ptr.class) || StereotypeUtil.isApplied((Element)prop, Ref.class)) && !StereotypeUtil.isApplied((Element)prop, Array.class);
    }

    public static boolean isAggregation(Property prop) {
        return (StereotypeUtil.isApplied((Element)prop, Ptr.class) || StereotypeUtil.isApplied((Element)prop, Ref.class)) && StereotypeUtil.isApplied((Element)prop, Array.class);
    }

    public static boolean isComposition(Property prop) {
        return !StereotypeUtil.isApplied((Element)prop, Ptr.class) && !StereotypeUtil.isApplied((Element)prop, Ref.class);
    }

    public static String getMemberInit(IMethodDeclaration method) {
        return ReverseUtils.getMemberInit(ASTUtils.findEnclosingNode((ISourceReference)method));
    }

    public static String getMemberInit(IASTNode methodNode) {
        ICPPASTConstructorChainInitializer[] inits;
        String ret = "";
        if (methodNode instanceof ICPPASTFunctionDefinition && (inits = ((ICPPASTFunctionDefinition)methodNode).getMemberInitializers()) != null) {
            StringConcatenation _builder = new StringConcatenation();
            boolean _hasElements = false;
            ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = inits;
            int n = inits.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTConstructorChainInitializer i = iCPPASTConstructorChainInitializerArray[n2];
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                IASTName _memberInitializerId = i.getMemberInitializerId();
                _builder.append((Object)_memberInitializerId);
                String _rawSignature = i.getInitializer().getRawSignature();
                _builder.append(_rawSignature);
                ++n2;
            }
            ret = _builder.toString();
        }
        return ret.toString();
    }

    public static void setXmlID(NamedElement ne) {
        Package root = PackageUtil.getRootPackage((Element)ne);
        Object qName = null;
        if (ne instanceof Usage) {
            String _qualifiedName = ((NamedElement)((Usage)ne).getSuppliers().get(0)).getQualifiedName();
            String _plus = "U_" + _qualifiedName;
            qName = _plus;
        } else {
            qName = ne.getQualifiedName();
        }
        if (qName != null) {
            String _replaceAll = ((String)qName).replaceFirst(root.getName(), "").replaceAll("::", "_").replaceAll("#", "_").replaceAll(" ", "_").replaceAll("<", "_").replaceAll(">", "_").replaceAll("&", "_");
            String _plus_1 = "ID" + _replaceAll;
            ReverseUtils.setXmlID((EObject)ne, _plus_1);
        }
    }

    public static void setXmlID(EObject eObject, String id) {
        Resource eObjectRes = eObject.eResource();
        if (eObjectRes instanceof XMLResource) {
            XMLResource xmlResource = (XMLResource)eObjectRes;
            Object uniqueID = id;
            int counter = 0;
            while (xmlResource.getEObject((String)uniqueID) != null) {
                uniqueID = id + String.valueOf((Object)counter);
                ++counter;
            }
            xmlResource.setID(eObject, (String)uniqueID);
        }
    }

    public static ICElement[] safeGetChilds(IParent parent) {
        try {
            ICElement[] children = null;
            try {
                children = parent.getChildren();
            }
            catch (Throwable _t) {
                if (_t instanceof StackOverflowError) {
                    StackOverflowError e = (StackOverflowError)_t;
                    LOGGER.log(Level.WARNING, String.format("Exception <%s> during fetching of children of parent <%s>", e.getMessage(), parent.toString()));
                    children = EMPTY_CHILDS;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return children;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

