/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.utils;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FileWatcher {
    private ICProject m_cproject;
    private long timestamp;

    public FileWatcher(ICProject project, long timestamp) {
        this.m_cproject = project;
        this.timestamp = timestamp;
    }

    public boolean isModified(ITranslationUnit itu) {
        File file = itu.getFile().getRawLocation().makeAbsolute().toFile();
        Path filePath = file.toPath();
        BasicFileAttributes attributes = null;
        try {
            attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exception = (IOException)_t;
                String _message = exception.getMessage();
                String _plus = "Exception handled when trying to get file attributes: " + _message;
                System.out.println(_plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        long seconds = attributes.lastModifiedTime().to(TimeUnit.SECONDS);
        return seconds > Long.MIN_VALUE && seconds < Long.MAX_VALUE && seconds > this.timestamp;
    }

    public List<ITranslationUnit> getModifiledTranslationUnits(IParent parent) {
        try {
            UniqueEList ret = new UniqueEList();
            if (!(parent instanceof ITranslationUnit)) {
                Functions.Function1 _function = it -> this.isModified((ITranslationUnit)it);
                Iterables.addAll((Collection)ret, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)parent.getChildren())), ITranslationUnit.class), (Functions.Function1)_function));
                Consumer<IParent> _function_1 = arg_0 -> this.lambda$1((List)ret, arg_0);
                Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)parent.getChildren())), IParent.class).forEach(_function_1);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private /* synthetic */ void lambda$1(List list, IParent it) {
        list.addAll(this.getModifiledTranslationUnits(it));
    }
}

