/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.python.codegen.gen;

import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PyMethods {
    public static CharSequence method(Operation method) {
        boolean _isStatic = method.isStatic();
        if (_isStatic) {
            return PyMethods.staticMethod(method);
        }
        return PyMethods.normalMethod(method);
    }

    public static CharSequence staticMethod(Operation method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@staticmethod");
        _builder.newLine();
        _builder.append("def ");
        String _writeMethodVisibility = PyMethods.writeMethodVisibility(method);
        _builder.append(_writeMethodVisibility);
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("(");
        Iterable<Parameter> _nonRetParams = PyMethods.nonRetParams(method);
        boolean _hasElements = false;
        for (Parameter parameter : _nonRetParams) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = parameter.getName();
            _builder.append(_name_1);
        }
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence normalMethod(Operation method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def ");
        String _writeMethodVisibility = PyMethods.writeMethodVisibility(method);
        _builder.append(_writeMethodVisibility);
        String _mName = PyMethods.mName(method);
        _builder.append(_mName);
        _builder.append("(self");
        Iterable<Parameter> _nonRetParams = PyMethods.nonRetParams(method);
        for (Parameter parameter : _nonRetParams) {
            _builder.append(", ");
            String _name = parameter.getName();
            _builder.append(_name);
        }
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String mName(Operation method) {
        String _xifexpression = null;
        boolean _isApplied = StereotypeUtil.isApplied((Element)method, Create.class);
        if (_isApplied) {
            _xifexpression = "__init__";
        } else {
            String _xifexpression_1 = null;
            boolean _isApplied_1 = StereotypeUtil.isApplied((Element)method, Destroy.class);
            _xifexpression_1 = _isApplied_1 ? "__del__" : method.getName();
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static String mBody(Operation operation) {
        EList _methods = operation.getMethods();
        for (Behavior method : _methods) {
            if (!(method instanceof OpaqueBehavior)) continue;
            int i = 0;
            while (i < ((OpaqueBehavior)method).getBodies().size()) {
                String _get = (String)((OpaqueBehavior)method).getLanguages().get(i);
                boolean _equals = Objects.equals(_get, "Python");
                if (_equals) {
                    return (String)((OpaqueBehavior)method).getBodies().get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Iterable<Parameter> nonRetParams(Operation method) {
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL);
        };
        return IterableExtensions.filter((Iterable)method.getOwnedParameters(), (Functions.Function1)_function);
    }

    public static boolean isConstructor(Operation method) {
        boolean _isApplied = StereotypeUtil.isApplied((Element)method, Create.class);
        return _isApplied;
    }

    public static boolean isDestroyer(Operation method) {
        boolean _isApplied = StereotypeUtil.isApplied((Element)method, Destroy.class);
        return _isApplied;
    }

    public static String writeMethodVisibility(Operation method) {
        block10: {
            String _name = method.getVisibility().name();
            if (_name == null) break block10;
            switch (_name) {
                case "PRIVATE_LITERAL": {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("__");
                    return _builder.toString();
                }
                case "PROTECTED_LITERAL": {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("_");
                    return _builder_1.toString();
                }
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            return _builder_2.toString();
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        return _builder_2.toString();
    }
}

