/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.ui.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class PythonExecutor {
    public static void executePython(IFile file, ExecutionEvent event) {
        if (file != null && file.exists()) {
            String fileOsPath = file.getRawLocation().makeAbsolute().toOSString();
            try {
                String line;
                Process p = Runtime.getRuntime().exec("python \"" + fileOsPath + "\" --propagation=jitter_offset");
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
                in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = in.readLine()) != null) {
                    IWorkbenchWindow window;
                    Shell shell;
                    System.err.println(line);
                    if (!line.startsWith("ERROR") && !line.startsWith("WARNING") || (shell = (window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event)).getShell()) == null) continue;
                    MessageBox dialog = null;
                    if (line.startsWith("ERROR: Deadline violated for task")) {
                        dialog = new MessageBox(shell, 33);
                        dialog.setText("Missed deadline");
                        dialog.setMessage(line);
                    } else if (line.startsWith("WARNING: load too high:")) {
                        dialog = new MessageBox(shell, 40);
                        dialog.setText("Load too high");
                        dialog.setMessage(line);
                    }
                    if (dialog == null) continue;
                    dialog.open();
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

