/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.transcription;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.author.IAuthor;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractList;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicList;
import org.eclipse.papyrus.model2doc.core.builtintypes.Cell;
import org.eclipse.papyrus.model2doc.core.builtintypes.FileReferenceCell;
import org.eclipse.papyrus.model2doc.core.builtintypes.IFileReference;
import org.eclipse.papyrus.model2doc.core.builtintypes.ListItem;
import org.eclipse.papyrus.model2doc.core.builtintypes.Row;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextCell;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextListItem;
import org.eclipse.papyrus.model2doc.core.builtintypes.accessors.IInputFileAccessor;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.accessors.IOutputFileAccessor;
import org.eclipse.papyrus.model2doc.core.styles.BooleanNamedStyle;
import org.eclipse.papyrus.model2doc.core.transcription.CoverPage;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescription;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.docx.Activator;
import org.eclipse.papyrus.model2doc.docx.Messages;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFDocument;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFParagraph;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFTable;
import org.eclipse.papyrus.model2doc.docx.internal.services.StyleServiceImpl;
import org.eclipse.papyrus.model2doc.docx.internal.util.ImageUtils;
import org.eclipse.papyrus.model2doc.docx.internal.util.TextUtils;
import org.eclipse.papyrus.model2doc.docx.services.StyleService;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;

public class DocxTranscription
implements Transcription {
    private static final String DOTX_SCHEMA = "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml";
    private static final String DOCX_SCHEMA = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
    private IDocumentGeneratorConfiguration docxGeneratorConfig;
    protected CustomXWPFDocument document;
    protected StyleService styleService;
    private int imageIndex = 1;
    private static final String ECORE_URI_FILE_SEPARATOR = "/";
    private static final String DOCX_FILE_EXTENTION = "docx";
    private static final String ECORE_FILE_PREFIX = "file:";
    private static final String EMPTY_STRING = "";
    private static final String WHITE_SPACE = " ";

    public DocxTranscription(IDocumentGeneratorConfiguration dgc) {
        this.docxGeneratorConfig = dgc;
        this.styleService = new StyleServiceImpl();
        try {
            InputStream templateInputStream = this.getFileWithTemplateLoaded();
            if (templateInputStream != null) {
                this.document = new CustomXWPFDocument(templateInputStream);
                templateInputStream.close();
            }
        }
        catch (IOException e) {
            Activator.log.warn("Cannot apply the template file");
        }
        catch (InvalidFormatException e1) {
            Activator.log.error("Cannot apply the template file", (Throwable)e1);
        }
        if (this.document == null) {
            this.document = new CustomXWPFDocument();
        }
    }

    private InputStream getFileWithTemplateLoaded() throws IOException, InvalidFormatException {
        URL templateURL = this.docxGeneratorConfig.createTemplateFileInputAccessor().createInputFileURL();
        if (templateURL != null) {
            IPath folderPath;
            File folder;
            URL destURL;
            IOutputFileAccessor outputAccessor = this.docxGeneratorConfig.createDocumentOutputAccessor();
            String destURI = outputAccessor.urlToPathString(destURL = outputAccessor.createOutputFileURL(this.docxGeneratorConfig.getDocumentName(), DOCX_FILE_EXTENTION), true);
            Path targetPath = new Path(destURI);
            if (targetPath.segmentCount() > 1 && !(folder = (folderPath = targetPath.removeLastSegments(1)).toFile()).exists()) {
                folder.mkdirs();
            }
            InputStream templateIS = templateURL.openStream();
            FileOutputStream destIS = new FileOutputStream(destURI);
            OPCPackage pkg = OPCPackage.open((InputStream)templateIS);
            pkg.replaceContentType(DOTX_SCHEMA, DOCX_SCHEMA);
            pkg.save((OutputStream)destIS);
            templateIS.close();
            destIS.close();
            return destURL.openStream();
        }
        return null;
    }

    public void writeCoverPage(CoverPage coverPage) {
    }

    public void writeTableOfContents(String tocTitle) {
        XWPFParagraph p = this.document.createParagraph();
        XWPFRun run = p.createRun();
        run.setText(tocTitle);
        this.document.createTOC();
    }

    public void writeTableOfFigures(String tofTitle) {
        XWPFParagraph p = this.document.createParagraph();
        XWPFRun run = p.createRun();
        run.setText(tofTitle);
        this.document.createTOF();
    }

    public void refreshTablesOfIndexes() {
    }

    public void writeDocumentMainTitle(String documentTitle) {
        XWPFParagraph p = this.document.createParagraph();
        this.styleService.applyDocumentMainTitleStyle(p);
        XWPFRun run = p.createRun();
        run.setText(documentTitle);
    }

    public void writeAuthors(Collection<IAuthor> authors) {
        this.setDocumentAuthorsProperty(authors);
    }

    public void writeVersion(String version) {
        this.setDocumentVersionProperty(version);
    }

    public void writeSectionTitle(String sectionTitle, int sectionLevel) {
        XWPFParagraph paragraph = this.document.createParagraph();
        this.styleService.applySectionTitleStyle(paragraph, sectionLevel);
        XWPFRun run = paragraph.createRun();
        run.setText(sectionTitle);
    }

    public void writeParagraph(String paragraph, boolean processRichText) {
        XWPFParagraph p = this.document.createParagraph();
        TextUtils.fillParagraph(p, paragraph);
    }

    public void writeList(AbstractList abstractList, boolean processRichText) {
        if (!(abstractList instanceof BasicList)) {
            Activator.log.warn(NLS.bind((String)"The list of type {0} is not supported by {1}.", (Object)abstractList.eClass().getName(), (Object)this.getClass().getName()));
            return;
        }
        BasicList basicList = (BasicList)abstractList;
        Iterator iter = basicList.getItems().iterator();
        while (iter.hasNext()) {
            this.writeListItem((ListItem)iter.next());
        }
    }

    private void writeListItem(ListItem listItem) {
        int itemLevel = listItem.getLevel();
        if (!(listItem instanceof TextListItem)) {
            Activator.log.warn(NLS.bind((String)"The list item  of type {0} is not supported by {1}.", (Object)listItem.eClass().getName(), (Object)this.getClass().getName()));
            return;
        }
        XWPFParagraph paragraph = this.document.createParagraph();
        paragraph.setNumID(BigInteger.ONE);
        if (paragraph instanceof CustomXWPFParagraph) {
            ((CustomXWPFParagraph)paragraph).setItemLevel(itemLevel - 1);
        }
        XWPFRun run = paragraph.createRun();
        run.setText(((TextListItem)listItem).getText());
        this.styleService.applyListStyle(paragraph);
        Iterator subItemIterator = listItem.getSubItems().iterator();
        while (subItemIterator.hasNext()) {
            this.writeListItem((ListItem)subItemIterator.next());
        }
    }

    public void writeTable(AbstractTable table) {
        Cell cell;
        int rowsNumber = table.getRowsNumber();
        int colNumbers = table.getColumnsNumber();
        if (rowsNumber <= 0 || colNumbers <= 0) {
            return;
        }
        EList allCells = table.getAllCells();
        int totalCells = allCells.size();
        if (rowsNumber * colNumbers != totalCells) {
            Activator.log.warn(NLS.bind((String)"The number of cells in the table is not as excepted. We won't manage the table {0}.", (Object)table.getCaption()));
            return;
        }
        XWPFTable xwpfTable = this.document.createTable(rowsNumber, colNumbers);
        Iterator rowIter = table.getRows().iterator();
        int rowIndex = 0;
        while (rowIter.hasNext()) {
            Row row = (Row)rowIter.next();
            Iterator cellIter = row.getCells().iterator();
            int cellIndex = 0;
            while (cellIter.hasNext()) {
                cell = (Cell)cellIter.next();
                if (cell instanceof TextCell) {
                    TextCell textCell = (TextCell)cell;
                    XWPFParagraph paragraph = xwpfTable.getRow(rowIndex).getCell(cellIndex).getParagraphArray(0);
                    if (paragraph != null) {
                        TextUtils.fillParagraph(paragraph, textCell.getText());
                    }
                } else if (cell instanceof FileReferenceCell) {
                    XWPFTableCell xwpfCell = xwpfTable.getRow(rowIndex).getCell(cellIndex);
                    this.insertFileInTableCell(((FileReferenceCell)cell).getFileReference(), xwpfCell);
                }
                ++cellIndex;
            }
            ++rowIndex;
        }
        rowIter = table.getRows().iterator();
        ArrayList<Cell> verticalMergedCells = new ArrayList<Cell>();
        while (rowIter.hasNext()) {
            Row row = (Row)rowIter.next();
            Iterator cellIter = row.getCells().iterator();
            while (cellIter.hasNext()) {
                Row lastMergedRow;
                Cell lastMergedCell;
                cell = (Cell)cellIter.next();
                BooleanNamedStyle style = (BooleanNamedStyle)cell.getNamedStyle("mergedWithRightCell");
                if (style != null && style.isValue() && (lastMergedCell = this.findLastHorizontalMergedCell(cellIter)) != null && xwpfTable instanceof CustomXWPFTable) {
                    ((CustomXWPFTable)xwpfTable).horizontalCellMerge(table.getRows().indexOf((Object)row), row.getCells().indexOf((Object)cell), row.getCells().indexOf((Object)lastMergedCell));
                }
                if ((style = (BooleanNamedStyle)cell.getNamedStyle("mergedWithBottomCell")) == null || !style.isValue() || verticalMergedCells.contains(cell) || (lastMergedRow = this.findVerticalMergedCells(table, row, cell, verticalMergedCells)) == null || !(xwpfTable instanceof CustomXWPFTable)) continue;
                ((CustomXWPFTable)xwpfTable).verticalCellMerge(row.getCells().indexOf((Object)cell), table.getRows().indexOf((Object)row), table.getRows().indexOf((Object)lastMergedRow));
            }
        }
        xwpfTable.setWidthType(TableWidthType.PCT);
        this.styleService.applyTableStyle(xwpfTable, this.document, table);
    }

    private Cell findLastHorizontalMergedCell(Iterator<Cell> cellIter) {
        while (cellIter.hasNext()) {
            Cell cell = cellIter.next();
            BooleanNamedStyle style = (BooleanNamedStyle)cell.getNamedStyle("mergedWithRightCell");
            if (style != null && style.isValue()) continue;
            return cell;
        }
        return null;
    }

    private Row findVerticalMergedCells(AbstractTable table, Row row, Cell firstCell, List<Cell> mergedCells) {
        int columnIndex = row.getCells().indexOf((Object)firstCell);
        int rowIndex = table.getRows().indexOf((Object)row) + 1;
        while (rowIndex < table.getRowsNumber()) {
            Cell cell = (Cell)((Row)table.getRows().get(rowIndex)).getCells().get(columnIndex);
            BooleanNamedStyle style = (BooleanNamedStyle)cell.getNamedStyle("mergedWithBottomCell");
            if (style == null || !style.isValue()) {
                mergedCells.add(cell);
                return (Row)table.getRows().get(rowIndex);
            }
            mergedCells.add(cell);
            ++rowIndex;
        }
        return null;
    }

    public void insertFile(IFileReference fileReference) {
        try {
            IInputFileAccessor accessor = fileReference.getFileAccessor();
            URL url = accessor.createInputFileURL();
            String path = accessor.urlToPathString(url, true);
            this.document.insertFile(path);
        }
        catch (Exception e) {
            Activator.log.warn(NLS.bind((String)"The {0} file can not be inserted", (Object)fileReference.getFilePath()));
        }
    }

    private void insertFileInTableCell(IFileReference fileReference, XWPFTableCell xwpfCell) {
        IInputFileAccessor accessor = fileReference.getFileAccessor();
        URL url = accessor.createInputFileURL();
        if (url != null) {
            String path = accessor.urlToPathString(url, true);
            try {
                int i = 0;
                while (i < xwpfCell.getParagraphs().size()) {
                    xwpfCell.removeParagraph(i);
                    ++i;
                }
                String id = this.document.importFile(path);
                xwpfCell.getCTTc().addNewAltChunk().setId(id);
            }
            catch (IOException | InvalidFormatException e) {
                Activator.log.warn(NLS.bind((String)"The {0} file can not be inserted", (Object)fileReference.getFilePath()));
            }
        }
    }

    public void writeImage(String imagePath, String caption) {
        Assert.isTrue((!imagePath.endsWith("svg") ? 1 : 0) != 0);
        imagePath = imagePath.replaceFirst(ECORE_FILE_PREFIX, EMPTY_STRING);
        XWPFParagraph imageParagraph = this.document.createParagraph();
        XWPFRun imageRun = imageParagraph.createRun();
        try {
            FileInputStream inputStream = new FileInputStream(imagePath);
            String[] path = imagePath.split(ECORE_URI_FILE_SEPARATOR);
            int[] size = ImageUtils.getImageSize(imagePath, this.document);
            imageRun.addPicture((InputStream)inputStream, 6, path[path.length - 1], size[0], size[1]);
            inputStream.close();
        }
        catch (IOException | InvalidFormatException e) {
            Activator.log.error(e);
        }
        XWPFParagraph captionParagraph = this.document.createParagraph();
        this.styleService.applyCaptionStyle(captionParagraph, this.document);
        XWPFRun captionRun = captionParagraph.createRun();
        captionRun.setText(Messages.DocxTranscription_imageCaptionLabel + WHITE_SPACE);
        CTSimpleField seq = captionParagraph.getCTP().addNewFldSimple();
        seq.setInstr(" SEQ Figure \\* ARABIC ");
        CTR ctr = seq.addNewR();
        CTRPr ctrpr = ctr.addNewRPr();
        ctrpr.addNewNoProof();
        CTText ctText = ctr.addNewT();
        ctText.setStringValue(String.valueOf(this.imageIndex));
        XWPFRun captionTextRun = captionParagraph.createRun();
        captionTextRun.setText(": " + caption);
        ++this.imageIndex;
    }

    public String save(String label) {
        IOutputFileAccessor accessor = this.docxGeneratorConfig.createDocumentOutputAccessor();
        URI ecoreURI = accessor.createOutputFileURI(this.docxGeneratorConfig.getDocumentName(), DOCX_FILE_EXTENTION);
        URL destURL = accessor.convertToURL(ecoreURI);
        try {
            String destPath = accessor.urlToPathString(destURL, true);
            FileOutputStream outputStream = new FileOutputStream(destPath);
            this.document.write(outputStream);
            ((OutputStream)outputStream).close();
            this.document.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return destURL.toString();
    }

    public void insertEmptyLine() {
        this.document.createParagraph();
    }

    public IDocumentGeneratorConfiguration getGeneratorConfig() {
        return null;
    }

    public boolean canExecute() {
        return false;
    }

    public void importImage(ImageDescription image, String caption) {
    }

    public void writeImageSubtitle(ImageDescription image) {
    }

    public void setDocumentVersionProperty(String documentVersion) {
    }

    public void setDocumentMaintTitleProperty(String documentTitle) {
    }

    public void setDocumentAuthorsProperty(Collection<IAuthor> authors) {
    }

    public void writeHeaderParagraph(String paragraph, boolean processRichText) {
        XWPFHeader header = this.document.createHeader(HeaderFooterType.DEFAULT);
        XWPFParagraph p = header.createParagraph();
        TextUtils.fillParagraph(p, paragraph);
    }

    public void writeFooterParagraph(String paragraph, boolean processRichText) {
        XWPFFooter footer = this.document.createFooter(HeaderFooterType.DEFAULT);
        XWPFParagraph p = footer.createParagraph();
        TextUtils.fillParagraph(p, paragraph);
    }
}

