/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;

public final class Template2StructureGeneratorDescription {
    private ITemplate2StructureGenerator generator;
    private List<AbstractTemplateToStructureMapper<?>> mappers = new ArrayList();
    private String inheritedFromGeneratorId;
    private Template2StructureGeneratorDescription inheritedGenerator;

    public Template2StructureGeneratorDescription(ITemplate2StructureGenerator generator, String inheritedFromGeneratorId) {
        Assert.isNotNull((Object)generator);
        this.generator = generator;
        this.inheritedFromGeneratorId = inheritedFromGeneratorId;
    }

    public final ITemplate2StructureGenerator getGenerator() {
        return this.generator;
    }

    public final String getInheritsFromGeneratorId() {
        return this.inheritedFromGeneratorId;
    }

    public List<AbstractTemplateToStructureMapper<?>> getMappers() {
        LinkedList mappers = new LinkedList();
        mappers.addAll(this.mappers);
        if (this.inheritedGenerator != null) {
            mappers.addAll(this.inheritedGenerator.getMappers());
        }
        return mappers;
    }

    public final void registerMapper(AbstractTemplateToStructureMapper<?> newMapper) {
        this.mappers.add(newMapper);
    }

    public final String getGeneratorId() {
        return this.generator.getGeneratorId();
    }

    public final void setInheritedGenerator(Template2StructureGeneratorDescription inheritedGenerator) {
        this.inheritedGenerator = inheritedGenerator;
    }

    public final Template2StructureGeneratorDescription getInheritedGenerator() {
        return this.inheritedGenerator;
    }
}

