/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.ieee.requirements.commands;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.commands.ApplyIEEERequirementsDocumentationProfileCommand;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.IEEEFunctionalRequirements;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.IEEERequirementCategory;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.documentation.IEEERequirements;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateIEEERequirementsStructureCommand
extends ApplyIEEERequirementsDocumentationProfileCommand {
    private Stereotype IEEERequirements;
    private Stereotype IEEEFunctionalRequirements;

    public CreateIEEERequirementsStructureCommand(TransactionalEditingDomain domain, Package pack) {
        super(domain, "Create IEEE Structure", pack);
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        super.doExecuteWithResult(monitor, info);
        Profile profile = this.pack.getAppliedProfile("IEEERequirementsDocumentation");
        this.IEEERequirements = profile.getOwnedStereotype("IEEERequirements");
        this.IEEEFunctionalRequirements = profile.getOwnedStereotype("IEEEFunctionalRequirements");
        if (!(this.hasExternalInterfacePackage() && this.hasExternalInterfacePackage() && this.hasUserInterfacePackage() && this.hasHWInterfacePackage() && this.hasCommunicationInterfacePackage() && this.hasSWInterfacePackage())) {
            if (!this.hasExternalInterfacePackage()) {
                this.createStereotypedIEEERequirementsPackage(this.pack, "ExternalInterfacesRequirements", IEEERequirementCategory.EXTERNAL_INTERFACES_REQUIREMENTS);
            }
            Package externalRequirementsPackage = this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.EXTERNAL_INTERFACES_REQUIREMENTS);
            if (!this.hasUserInterfacePackage()) {
                this.createStereotypedIEEERequirementsPackage(externalRequirementsPackage, "UserInterfacesRequirements", IEEERequirementCategory.USER_INTERFACES);
            }
            if (!this.hasHWInterfacePackage()) {
                this.createStereotypedIEEERequirementsPackage(externalRequirementsPackage, "HWInterfacesRequirements", IEEERequirementCategory.HARDWARE_INTERFACES);
            }
            if (!this.hasSWInterfacePackage()) {
                this.createStereotypedIEEERequirementsPackage(externalRequirementsPackage, "SWInterfacesRequirements", IEEERequirementCategory.SOFTWARE_INTERFACES);
            }
            if (!this.hasCommunicationInterfacePackage()) {
                this.createStereotypedIEEERequirementsPackage(externalRequirementsPackage, "CommunicationInterfacesRequirements", IEEERequirementCategory.COMMUNICATION_INTERFACES);
            }
        }
        if (!(this.hasFunctionalRequirements_Mode1_Package() && this.hasFunctionalRequirements_Mode2_Package() && this.hasFunctionalRequirements_Mode3_Package())) {
            this.createStereotypedIEEERequirementsPackage(this.pack, "FunctionalRequirements", IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS);
            Package functionalRequirementsRootPackage = this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS);
            if (!this.hasFunctionalRequirements_Mode1_Package()) {
                this.createStereotypedIEEERequirementsPackage(functionalRequirementsRootPackage, "FunctionalRequirements_Mode_1", IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 1);
            }
            if (!this.hasFunctionalRequirements_Mode2_Package()) {
                this.createStereotypedIEEERequirementsPackage(functionalRequirementsRootPackage, "FunctionalRequirements_Mode_2", IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 2);
            }
            if (!this.hasFunctionalRequirements_Mode3_Package()) {
                this.createStereotypedIEEERequirementsPackage(functionalRequirementsRootPackage, "FunctionalRequirements_Mode_3", IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 3);
            }
        }
        if (!this.hasPerformanceRequirementsPackage()) {
            this.createStereotypedIEEERequirementsPackage(this.pack, "PerformanceRequirements", IEEERequirementCategory.PERFORMANCE_REQUIREMENTS);
        }
        if (!this.hasDesignConstraintsPackage()) {
            this.createStereotypedIEEERequirementsPackage(this.pack, "DesignConstraintsRequirements", IEEERequirementCategory.DESIGN_CONSTRAINTS);
        }
        if (!this.hasSoftwareSystemAttributeRequirementsPackage()) {
            this.createStereotypedIEEERequirementsPackage(this.pack, "SoftwareSystemAttributeRequirements", IEEERequirementCategory.SOFTWARE_SYSTEM_ATTRIBUTES);
        }
        if (!this.hasOtherRequirementsPackage()) {
            this.createStereotypedIEEERequirementsPackage(this.pack, "OtherRequirements", IEEERequirementCategory.OTHER_REQUIREMENTS);
        }
        return CommandResult.newOKCommandResult();
    }

    private void createStereotypedIEEERequirementsPackage(Package parentPack, String packName, IEEERequirementCategory category) {
        Package newPackage = UMLFactory.eINSTANCE.createPackage();
        newPackage.setName(packName);
        parentPack.getNestedPackages().add((Object)newPackage);
        IEEERequirements steAppl = (IEEERequirements)newPackage.applyStereotype(this.IEEERequirements);
        steAppl.setCategory(category);
    }

    private void createStereotypedIEEERequirementsPackage(Package parentPack, String packName, IEEERequirementCategory category, int mode) {
        Package newPackage = UMLFactory.eINSTANCE.createPackage();
        newPackage.setName(packName);
        parentPack.getNestedPackages().add((Object)newPackage);
        IEEEFunctionalRequirements steAppl = (IEEEFunctionalRequirements)newPackage.applyStereotype(this.IEEEFunctionalRequirements);
        steAppl.setCategory(category);
        steAppl.setMode(mode);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.hasMissingIEEEPackage();
    }

    private final boolean hasMissingIEEEPackage() {
        return !this.hasExternalInterfacePackage() || !this.hasUserInterfacePackage() || !this.hasHWInterfacePackage() || !this.hasCommunicationInterfacePackage() || !this.hasSWInterfacePackage() || !this.hasFunctionalRequirements_Mode1_Package() || !this.hasFunctionalRequirements_Mode2_Package() || !this.hasFunctionalRequirements_Mode3_Package() || !this.hasPerformanceRequirementsPackage() || !this.hasDesignConstraintsPackage() || !this.hasSoftwareSystemAttributeRequirementsPackage() || !this.hasOtherRequirementsPackage();
    }

    private final boolean hasExternalInterfacePackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.EXTERNAL_INTERFACES_REQUIREMENTS) != null;
    }

    private final boolean hasUserInterfacePackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.USER_INTERFACES) != null;
    }

    private final boolean hasHWInterfacePackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.HARDWARE_INTERFACES) != null;
    }

    private final boolean hasCommunicationInterfacePackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.COMMUNICATION_INTERFACES) != null;
    }

    private final boolean hasSWInterfacePackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.SOFTWARE_INTERFACES) != null;
    }

    private final boolean hasFunctionalRequirements_Mode1_Package() {
        return this.findStereotypedIEEEFunctionalRequirementsPackage(this.pack, IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 1) != null;
    }

    private final boolean hasFunctionalRequirements_Mode2_Package() {
        return this.findStereotypedIEEEFunctionalRequirementsPackage(this.pack, IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 2) != null;
    }

    private final boolean hasFunctionalRequirements_Mode3_Package() {
        return this.findStereotypedIEEEFunctionalRequirementsPackage(this.pack, IEEERequirementCategory.FUNCTIONAL_REQUIREMENTS, 3) != null;
    }

    private final boolean hasPerformanceRequirementsPackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.PERFORMANCE_REQUIREMENTS) != null;
    }

    private final boolean hasDesignConstraintsPackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.DESIGN_CONSTRAINTS) != null;
    }

    private final boolean hasSoftwareSystemAttributeRequirementsPackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.SOFTWARE_SYSTEM_ATTRIBUTES) != null;
    }

    private final boolean hasOtherRequirementsPackage() {
        return this.findStereotypedIEEERequirementsPackage(this.pack, IEEERequirementCategory.OTHER_REQUIREMENTS) != null;
    }

    private final Package findStereotypedIEEERequirementsPackage(Package pack, IEEERequirementCategory ieeeCategory) {
        if (pack == null) {
            return null;
        }
        IEEERequirements ieeeReq = (IEEERequirements)UMLUtil.getStereotypeApplication((Element)pack, IEEERequirements.class);
        if (ieeeReq != null && ieeeReq.getCategory() == ieeeCategory) {
            return pack;
        }
        List ownedPackages = pack.getMembers().stream().filter(Package.class::isInstance).map(Package.class::cast).collect(Collectors.toList());
        Iterator iter = ownedPackages.iterator();
        Package found = null;
        while (iter.hasNext() && found == null) {
            Package tmp = (Package)iter.next();
            ieeeReq = (IEEERequirements)UMLUtil.getStereotypeApplication((Element)tmp, IEEERequirements.class);
            if (ieeeReq == null || ieeeReq.getCategory() != ieeeCategory) continue;
            found = tmp;
        }
        if (found == null) {
            iter = ownedPackages.iterator();
            while (iter.hasNext() && found == null) {
                found = this.findStereotypedIEEERequirementsPackage((Package)iter.next(), ieeeCategory);
            }
        }
        return found;
    }

    private final Package findStereotypedIEEEFunctionalRequirementsPackage(Package pack, IEEERequirementCategory ieeeCategory, int mode) {
        if (pack == null) {
            return null;
        }
        IEEEFunctionalRequirements ieeeReq = (IEEEFunctionalRequirements)UMLUtil.getStereotypeApplication((Element)pack, IEEEFunctionalRequirements.class);
        if (ieeeReq != null && ieeeReq.getCategory() == ieeeCategory && ieeeReq.getMode() == mode) {
            return pack;
        }
        List ownedPackages = pack.getMembers().stream().filter(Package.class::isInstance).map(Package.class::cast).collect(Collectors.toList());
        Iterator iter = ownedPackages.iterator();
        Package found = null;
        while (iter.hasNext() && found == null) {
            Package tmp = (Package)iter.next();
            ieeeReq = (IEEEFunctionalRequirements)UMLUtil.getStereotypeApplication((Element)tmp, IEEEFunctionalRequirements.class);
            if (ieeeReq == null || ieeeReq.getCategory() != ieeeCategory || ieeeReq.getMode() != mode) continue;
            found = tmp;
        }
        if (found == null) {
            iter = ownedPackages.iterator();
            while (iter.hasNext() && found == null) {
                found = this.findStereotypedIEEEFunctionalRequirementsPackage((Package)iter.next(), ieeeCategory, mode);
            }
        }
        return found;
    }
}

