/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.p4rocl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotics.assertions.languages.AssertionsHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;
import org.eclipse.papyrus.robotics.assertions.languages.P4RExpressionsHelper;
import org.eclipse.papyrus.robotics.assertions.languages.ocl.OCLExpressionLanguage;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterInstance;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class P4ROCLLanguage
implements IExpressionLanguage {
    public String getName() {
        return "P4R OCL";
    }

    public Object evaluate(EObject context, String expression) {
        ComponentDefinition compDefinition = null;
        ComponentInstance compInstance = null;
        System system = null;
        if (context instanceof ComponentDefinition) {
            compDefinition = (ComponentDefinition)context;
        } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class) != null) {
            compDefinition = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class);
        }
        if (compDefinition == null) {
            if (context instanceof ComponentInstance) {
                compInstance = (ComponentInstance)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class) != null) {
                compInstance = (ComponentInstance)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class);
            }
        }
        if (compDefinition == null && compInstance == null) {
            if (context instanceof System) {
                system = (System)context;
            } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), System.class) != null) {
                system = (System)UMLUtil.getStereotypeApplication((Element)((Element)context), System.class);
            }
        }
        if (compDefinition != null) {
            expression = P4RExpressionsHelper.updateExpression((EObject)compDefinition, (String)expression);
        } else if (compInstance != null) {
            expression = P4RExpressionsHelper.updateExpression((EObject)compInstance, (String)expression);
        } else if (system != null) {
            expression = P4RExpressionsHelper.updateExpression((EObject)system, (String)expression);
        }
        OCLExpressionLanguage ocl = new OCLExpressionLanguage();
        Object evaluation = ocl.evaluate(context, expression);
        return evaluation;
    }

    public String handleGlobalSum(EObject context, String expression) {
        ArrayList<String> toReplace = new ArrayList<String>();
        int igs = expression.indexOf("GlobalSum(");
        while (igs != -1) {
            String propertyInExpression = expression.substring(igs + "GlobalSum(".length(), expression.indexOf(")", igs));
            if (!toReplace.contains(propertyInExpression)) {
                toReplace.add(propertyInExpression);
            }
            igs = expression.indexOf("GlobalSum(", igs + 1);
        }
        if (toReplace.isEmpty()) {
            return expression;
        }
        System system = (System)context;
        EList instances = system.getInstances();
        for (String propertyInExpression : toReplace) {
            StringBuffer globalSum = new StringBuffer("");
            for (ComponentInstance instance : instances) {
                Map instanceProperties = AssertionsHelper.getProperties((EObject)instance.getCompdefOrSys().getBase_Class());
                if (!instanceProperties.containsKey(propertyInExpression)) continue;
                globalSum.append(instance.getBase_Property().getName());
                globalSum.append(".");
                globalSum.append(propertyInExpression);
                globalSum.append(" + ");
            }
            globalSum.setLength(globalSum.length() - " + ".length());
            expression = expression.replaceAll("GlobalSum\\(" + propertyInExpression + "\\)", " (" + String.valueOf(globalSum) + ") ");
        }
        return expression;
    }

    public Map<String, String> getCompDefinitionDefaultParameters(ComponentOrSystem compDef) {
        HashMap<String, String> defaultParameters = new HashMap<String, String>();
        TreeIterator i = compDef.getBase_Class().eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            ParameterEntry parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)((Element)eo), ParameterEntry.class);
            if (parameter == null) continue;
            String name = parameter.getBase_Property().getName();
            String value = "";
            if (parameter.getBase_Property().getDefaultValue() != null) {
                Object result = AssertionsHelper.evaluateValueSpecification((EObject)compDef, (ValueSpecification)parameter.getBase_Property().getDefaultValue());
                value = result.toString();
            }
            defaultParameters.put(name, value);
        }
        return defaultParameters;
    }

    public Map<String, String> getCompInstanceParameters(ComponentInstance compInstance) {
        Map<String, String> parameters = this.getCompDefinitionDefaultParameters(compInstance.getCompdefOrSys());
        TreeIterator i = compInstance.getBase_Property().eAllContents();
        while (i.hasNext()) {
            InstanceSpecification eo2;
            ParameterInstance paraSpec;
            EList slots;
            EObject eo = (EObject)i.next();
            if (!(eo instanceof InstanceValue) || (slots = (paraSpec = (ParameterInstance)UMLUtil.getStereotypeApplication((Element)((Element)(eo2 = ((InstanceValue)eo).getInstance())), ParameterInstance.class)).getBase_InstanceSpecification().getSlots()) == null || slots.isEmpty()) continue;
            Slot slot = (Slot)paraSpec.getBase_InstanceSpecification().getSlots().get(0);
            String name = slot.getDefiningFeature().getName();
            ValueSpecification vs = (ValueSpecification)slot.getValues().get(0);
            String value = vs.stringValue();
            parameters.put(name, value);
        }
        return parameters;
    }

    public boolean isGlobalEvaluation() {
        return false;
    }
}

