/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.animation.zmq.core;

import java.nio.ByteBuffer;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class ZMQBTReader {
    protected ZContext _context;
    protected ZMQ.Socket _treeReader;
    protected String BT_READER_TCP = "tcp://*:2667";
    protected int BT_READER_TIMEOUT_SEC = 60;
    byte[] _treeInfo;

    public ZMQBTReader(ZContext ctx) {
        this._context = ctx;
        this._treeInfo = null;
        this._treeReader = this._context.createSocket(SocketType.REQ);
        this._treeReader.connect(this.BT_READER_TCP);
        this._treeReader.setReceiveTimeOut(1000);
    }

    public ByteBuffer waitForTree() throws Exception {
        String request = "0";
        int attempt_no = 0;
        this._treeReader.send(request.getBytes(ZMQ.CHARSET), 0);
        while (attempt_no < this.BT_READER_TIMEOUT_SEC) {
            this._treeInfo = this._treeReader.recv();
            if (this._treeInfo != null) break;
            ++attempt_no;
        }
        if (attempt_no == this.BT_READER_TIMEOUT_SEC) {
            this.close();
            throw new Exception("[ZMQBTReader] Couldn't find an active server in " + this.BT_READER_TIMEOUT_SEC + " sec.");
        }
        return ByteBuffer.wrap(this._treeInfo);
    }

    public void close() {
        this._treeReader.close();
    }
}

