/**
 * Copyright (c) 2020, 2023 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Matteo MORELLI (CEA LIST) <matteo.morelli@cea.fr> - Bug #566899
 *  Matteo MORELLI (CEA LIST) <matteo.morelli@cea.fr> - Bug #581690
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.profile.robotics.skills.InAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.OutAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.PrimitiveType;

@SuppressWarnings("all")
public class SkillRealizBuildUtils {
  /**
   * Calculate the service definition dependencies for skills
   */
  public static List<String> calcDependencies(final Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap) {
    final ArrayList<String> dependencies = new ArrayList<String>();
    Set<SkillDefinition> _keySet = skdefToSemanticsMap.keySet();
    for (final SkillDefinition definition : _keySet) {
      EList<InAttribute> _ins = definition.getIns();
      EList<OutAttribute> _outs = definition.getOuts();
      Iterable<SkillParameter> _plus = Iterables.<SkillParameter>concat(_ins, _outs);
      for (final SkillParameter param : _plus) {
        {
          final DataType paramType = SkillUtils.getType(param);
          if ((!(paramType instanceof PrimitiveType))) {
            final String pkgName = MessageUtils.getMessagePackage(paramType).getName().toLowerCase();
            boolean _contains = dependencies.contains(pkgName);
            boolean _not = (!_contains);
            if (_not) {
              dependencies.add(pkgName);
            }
          }
        }
      }
    }
    Collection<SkillSemantic> _values = skdefToSemanticsMap.values();
    for (final SkillSemantic semantics : _values) {
      EList<SkillOperationalState> _operational = semantics.getOperational();
      for (final SkillOperationalState ops : _operational) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
          final String pkgName = MessageUtils.getMessagePackage(SkillUtils.getCompInterface(ops)).getName().toLowerCase();
          boolean _contains = dependencies.contains(pkgName);
          boolean _not = (!_contains);
          if (_not) {
            dependencies.add(pkgName);
          }
        }
      }
    }
    return dependencies;
  }
}
