/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.message;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.ChoiceType;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CreateMessage {
    private CreateMsgPackage msgPkgCreator;

    public CreateMessage(CreateMsgPackage msgPkgCreator) {
        this.msgPkgCreator = msgPkgCreator;
    }

    public CharSequence createDtOrEnumMsg(DataType dtOrEnum) {
        CharSequence _xifexpression = null;
        _xifexpression = dtOrEnum instanceof Enumeration ? this.createEnumMsgs((Enumeration)dtOrEnum) : this.createDataTypeMsg(dtOrEnum);
        return _xifexpression;
    }

    public CharSequence createDataTypeMsg(DataType dataType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# Publish-Subscribe (or Push, Send)");
        _builder.newLine();
        CharSequence _comment = this.comment((Element)dataType);
        _builder.append((Object)_comment);
        _builder.newLineIfNotEmpty();
        MessageUtils.makeDTExternal(dataType);
        _builder.newLineIfNotEmpty();
        StereotypeUtil.isApplied((Element)dataType, ChoiceType.class);
        _builder.append("# attributes of datatype ");
        String _qualifiedName_1 = dataType.getQualifiedName();
        _builder.append(_qualifiedName_1);
        _builder.newLineIfNotEmpty();
        EList _allAttributes = dataType.getAllAttributes();
        for (Property attribute_1 : _allAttributes) {
            String _createAttributeMsg_1 = this.createAttributeMsg(attribute_1);
            _builder.append(_createAttributeMsg_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence createServiceMsg(DataType request, DataType response) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# query pattern - request");
        _builder.newLine();
        CharSequence _comment = this.comment((Element)request);
        _builder.append((Object)_comment);
        _builder.newLineIfNotEmpty();
        _builder.append("# attributes of request ");
        String _qualifiedName = request.getQualifiedName();
        _builder.append(_qualifiedName);
        _builder.newLineIfNotEmpty();
        EList _allAttributes = request.getAllAttributes();
        for (Property attribute : _allAttributes) {
            String _createAttributeMsg = this.createAttributeMsg(attribute);
            _builder.append(_createAttributeMsg);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("---");
        _builder.newLine();
        CharSequence _comment_1 = this.comment((Element)response);
        _builder.append((Object)_comment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("# attributes of response ");
        String _qualifiedName_1 = response.getQualifiedName();
        _builder.append(_qualifiedName_1);
        _builder.newLineIfNotEmpty();
        EList _allAttributes_1 = response.getAllAttributes();
        for (Property attribute_1 : _allAttributes_1) {
            String _createAttributeMsg_1 = this.createAttributeMsg(attribute_1);
            _builder.append(_createAttributeMsg_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence createActionMsg(DataType goal, DataType response, DataType feedback) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# action pattern");
        _builder.newLine();
        _builder.append("# attributes of goal ");
        String _qualifiedName = goal.getQualifiedName();
        _builder.append(_qualifiedName);
        _builder.newLineIfNotEmpty();
        EList _allAttributes = goal.getAllAttributes();
        for (Property attribute : _allAttributes) {
            String _createAttributeMsg = this.createAttributeMsg(attribute);
            _builder.append(_createAttributeMsg);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("---");
        _builder.newLine();
        _builder.append("# attributes of result ");
        String _qualifiedName_1 = response.getQualifiedName();
        _builder.append(_qualifiedName_1);
        _builder.newLineIfNotEmpty();
        EList _allAttributes_1 = response.getAllAttributes();
        for (Property attribute_1 : _allAttributes_1) {
            String _createAttributeMsg_1 = this.createAttributeMsg(attribute_1);
            _builder.append(_createAttributeMsg_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("---");
        _builder.newLine();
        _builder.append("# attributes of feedback ");
        String _qualifiedName_2 = feedback.getQualifiedName();
        _builder.append(_qualifiedName_2);
        _builder.newLineIfNotEmpty();
        EList _allAttributes_2 = feedback.getAllAttributes();
        for (Property attribute_2 : _allAttributes_2) {
            String _createAttributeMsg_2 = this.createAttributeMsg(attribute_2);
            _builder.append(_createAttributeMsg_2);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String createAttributeMsg(Property attribute) {
        String typeStr = null;
        Type _type = attribute.getType();
        if (_type instanceof PrimitiveType) {
            typeStr = MessageUtils.primitiveTypeMap(attribute.getType());
        } else {
            Type _type_1 = attribute.getType();
            if (_type_1 instanceof Enumeration) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("# enum ");
                String _name = attribute.getType().getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
                _builder.append("uint8");
                typeStr = _builder.toString();
                Type _type_2 = attribute.getType();
                Enumeration type = (Enumeration)_type_2;
                this.msgPkgCreator.createMsgPkg((DataType)type);
            } else {
                Type _type_3 = attribute.getType();
                if (_type_3 instanceof DataType) {
                    Type _type_4 = attribute.getType();
                    DataType type_1 = (DataType)_type_4;
                    typeStr = String.format("%s/%s", PackageTools.pkgName((Package)MessageUtils.getMessagePackage((NamedElement)attribute.getType())), attribute.getType().getName());
                    this.msgPkgCreator.createMsgPkg(type_1);
                }
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(typeStr);
        String _multiplicityStr = this.getMultiplicityStr(attribute);
        _builder_1.append(_multiplicityStr);
        _builder_1.append(" ");
        String _name_1 = attribute.getName();
        _builder_1.append(_name_1);
        CharSequence _defaultValueStr = this.defaultValueStr(attribute);
        _builder_1.append((Object)_defaultValueStr);
        CharSequence _comment = this.comment((Element)attribute);
        _builder_1.append((Object)_comment);
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }

    public CharSequence comment(Element element) {
        Entity entity = (Entity)UMLUtil.getStereotypeApplication((Element)element, Entity.class);
        if (entity != null && entity.getDescription() != null && entity.getDescription().length() > 0) {
            String prefix = "";
            if (element instanceof Property) {
                prefix = "\t";
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(prefix);
            _builder.append("# ");
            String _description = entity.getDescription();
            _builder.append(_description);
            return _builder;
        }
        return "";
    }

    public String getMultiplicityStr(Property attribute) {
        boolean _notEquals;
        boolean _equals;
        int _upper = attribute.getUpper();
        boolean bl = _equals = _upper == -1;
        if (_equals) {
            return "[]";
        }
        int _upper_1 = attribute.getUpper();
        boolean bl2 = _notEquals = _upper_1 != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            int _upper_2 = attribute.getUpper();
            _builder.append((Object)_upper_2);
            _builder.append("]");
            return _builder.toString();
        }
        return null;
    }

    public CharSequence defaultValueStr(Property attribute) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        ValueSpecification _defaultValue = attribute.getDefaultValue();
        boolean bl = _tripleNotEquals = _defaultValue != null;
        if (_tripleNotEquals) {
            _builder.append(" ");
            _builder.append("= ");
            String _stringValue = attribute.getDefaultValue().stringValue();
            _builder.append(_stringValue);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public void generateFile(IPFileSystemAccess fileAccess, String fileName, String ext, CharSequence content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(ext);
        _builder.append("/");
        _builder.append(fileName);
        _builder.append(".");
        _builder.append(ext);
        String fileNameWithExt = _builder.toString();
        fileAccess.generateFile(fileNameWithExt, content.toString());
    }

    public CharSequence createEnumMsgs(Enumeration enumeration) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# constants to mimic enumeration ");
        String _name = enumeration.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        int counter = 0;
        _builder.newLineIfNotEmpty();
        EList _ownedLiterals = enumeration.getOwnedLiterals();
        for (EnumerationLiteral enumLiteral : _ownedLiterals) {
            _builder.append("uint8 ");
            String _upperCase = enumLiteral.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append(" = ");
            int _plusPlus = counter++;
            _builder.append((Object)_plusPlus);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence createMsgForEvent(TemplateBinding tb) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# Event");
        _builder.newLine();
        EList _parameterSubstitutions = tb.getParameterSubstitutions();
        for (TemplateParameterSubstitution tps : _parameterSubstitutions) {
            ParameterableElement actual = tps.getActual();
            _builder.newLineIfNotEmpty();
            String _name = ((NamedElement)actual).getName();
            _builder.append(_name);
            _builder.append(" ");
            String _tPName = InteractionUtils.getTPName((TemplateParameter)tps.getFormal());
            _builder.append(_tPName);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

