/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.utils;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.behavior.Task;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.services.CoordinationService;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.RosHelpers;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SkillUtils {
    public static String realizationPackageName(Package pkg) {
        try {
            if (pkg == null) {
                throw new Exception("Model error! Can''t access the skill realization model!");
            }
            String _pkgName = PackageTools.pkgName((Package)pkg);
            return _pkgName + "_skillrealizations";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static LinkedHashSet<SkillDefinition> getUniqueSkills(System sys) {
        LinkedHashSet<SkillDefinition> res = new LinkedHashSet<SkillDefinition>();
        if (sys != null) {
            EList _task = sys.getTask();
            for (Task task : _task) {
                res.addAll((Collection<SkillDefinition>)task.getSkills());
            }
        }
        return res;
    }

    public static String getName(SkillDefinition sdef) {
        if (sdef != null) {
            return sdef.getBase_Operation().getName();
        }
        return "";
    }

    public static DataType getType(SkillParameter param) {
        Type _type;
        if (param != null && (_type = param.getBase_Parameter().getType()) instanceof DataType) {
            Type _type_1 = param.getBase_Parameter().getType();
            return (DataType)_type_1;
        }
        return null;
    }

    public static LinkedHashSet<DataType> getUniqueSkillParameterTypes(SkillDefinition skill) {
        LinkedHashSet<DataType> res = new LinkedHashSet<DataType>();
        if (skill != null) {
            EList _ins = skill.getIns();
            EList _outs = skill.getOuts();
            Iterable _plus = Iterables.concat((Iterable)_ins, (Iterable)_outs);
            for (SkillParameter p : _plus) {
                DataType paramType = SkillUtils.getType(p);
                if (paramType instanceof PrimitiveType) continue;
                res.add(paramType);
            }
        }
        return res;
    }

    public static String getROS2TypeIncludePath(DataType tp) {
        if (tp != null) {
            String _escapeCamlCase = RosHelpers.escapeCamlCase(MessageUtils.getROS2qMsgName(tp));
            return _escapeCamlCase + ".hpp";
        }
        return "";
    }

    public static String getROS2TypeFromMsgName(DataType tp) {
        if (tp != null) {
            return MessageUtils.getROS2qMsgName(tp).replace("/", "::");
        }
        return "";
    }

    public static String getFilePathCoordinatesOfDefaultTask(System sys) {
        String res = "";
        if (sys != null) {
            boolean _not;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)sys.getTask());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                Task default_task = (Task)sys.getTask().get(0);
                URI uri = default_task.getBase_Class().eResource().getURI();
                res = uri.segment(1);
            }
        }
        return res;
    }

    public static String getPackageRelativePathOfDefaultTask(System sys, boolean fullpath) {
        String res = "";
        if (sys != null) {
            boolean _not;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)sys.getTask());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                Task default_task = (Task)sys.getTask().get(0);
                URI uri = default_task.getBase_Class().eResource().getURI();
                if (!fullpath) {
                    int _segmentCount = uri.segmentCount();
                    int _minus = _segmentCount - 2;
                    res = uri.segment(_minus);
                } else {
                    String[] pertinentSegments;
                    Path path = new Path("");
                    String[] _segments = uri.segments();
                    int _segmentCount_1 = uri.segmentCount();
                    int _minus_1 = _segmentCount_1 - 1;
                    String[] stringArray = pertinentSegments = Arrays.copyOfRange(_segments, 2, _minus_1);
                    int n = pertinentSegments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        IPath _append = path.append(s);
                        path = (Path)_append;
                        ++n2;
                    }
                    res = path.toOSString();
                }
            }
        }
        return res;
    }

    public static String getBTFileNameOfDefaultTask(System sys) {
        String res = "";
        if (sys != null) {
            boolean _not;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)sys.getTask());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                Task default_task = (Task)sys.getTask().get(0);
                String modelname = default_task.getBase_Class().getName();
                IPath _addFileExtension = new Path(modelname).addFileExtension("behaviortreeschema");
                Path path = (Path)_addFileExtension;
                res = path.toOSString();
            }
        }
        return res;
    }

    public static String getName(SkillParameter param) {
        if (param != null) {
            return param.getBase_Parameter().getName();
        }
        return null;
    }

    public static SkillOperationalState getFirstOpState(SkillSemantic sem) {
        if (sem != null) {
            return (SkillOperationalState)sem.getOperational().get(0);
        }
        return null;
    }

    public static boolean doesConfigAndCoordOfComponents(SkillOperationalState ops) {
        if (ops != null) {
            boolean _tripleNotEquals;
            CoordinationService _compInterface = ops.getCompInterface();
            boolean bl = _tripleNotEquals = _compInterface != null;
            if (_tripleNotEquals) {
                return true;
            }
        }
        return false;
    }

    public static String getCoordinationIfQn(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            String qName = MessageUtils.getROS2qMsgName(ops.getCompInterface().getBase_Interface());
            return qName.replace("/", "::");
        }
        return "";
    }

    public static String getCoordinationIfIncludePath(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            String qName = MessageUtils.getROS2qMsgName(ops.getCompInterface().getBase_Interface());
            String _escapeCamlCase = RosHelpers.escapeCamlCase(qName);
            return _escapeCamlCase + ".hpp";
        }
        return "";
    }

    public static Interface getCompInterface(SkillOperationalState ops) {
        boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
        if (_doesConfigAndCoordOfComponents) {
            return ops.getCompInterface().getBase_Interface();
        }
        return null;
    }

    public static String realizationFileName(SkillDefinition sdef) {
        try {
            if (sdef == null) {
                throw new Exception("Model error! Found UML::Operation with no stereotype applied!");
            }
            SkillOperationalState ops = SkillUtils.getFirstOpState(sdef.getDefaultSemantic());
            String _xifexpression = null;
            _xifexpression = SkillUtils.doesConfigAndCoordOfComponents(ops) && InteractionUtils.isQuery((CommunicationPattern)InteractionUtils.getCommunicationPattern((Interface)SkillUtils.getCompInterface(ops))) ? "_condition" : "_action";
            String suffix = _xifexpression;
            String _lowerCase = String.join((CharSequence)"_", sdef.getBase_Operation().getName().split("(?<=.)(?=\\p{Lu})")).toLowerCase();
            return _lowerCase + suffix;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean doesConfigAndCoordOfComponents(State st) {
        return SkillUtils.doesConfigAndCoordOfComponents((SkillOperationalState)UMLUtil.getStereotypeApplication((Element)st, SkillOperationalState.class));
    }

    public static LinkedHashSet<SkillDefinition> getUniqueSkills(Class sys) {
        if (sys == null) {
            return null;
        }
        return SkillUtils.getUniqueSkills((System)UMLUtil.getStereotypeApplication((Element)sys, System.class));
    }

    public static String getROS2PackageNameOfDefaultTask(Class sys) {
        if (sys == null) {
            return null;
        }
        return SkillUtils.getFilePathCoordinatesOfDefaultTask((System)UMLUtil.getStereotypeApplication((Element)sys, System.class));
    }

    public static String getPackageRelativePathOfDefaultTask(Class sys) {
        if (sys == null) {
            return null;
        }
        return SkillUtils.getPackageRelativePathOfDefaultTask((System)UMLUtil.getStereotypeApplication((Element)sys, System.class), true);
    }

    public static String getPackageRelativeFolderNameOfDefaultTask(Class sys) {
        if (sys == null) {
            return null;
        }
        return SkillUtils.getPackageRelativePathOfDefaultTask((System)UMLUtil.getStereotypeApplication((Element)sys, System.class), false);
    }

    public static String getBTFileNameOfDefaultTask(Class sys) {
        if (sys == null) {
            return null;
        }
        return SkillUtils.getBTFileNameOfDefaultTask((System)UMLUtil.getStereotypeApplication((Element)sys, System.class));
    }
}

