/**
 * Copyright (c) 2020, 2023 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Matteo MORELLI (CEA LIST) <matteo.morelli@cea.fr> - Bug #566899
 *  Matteo MORELLI (CEA LIST) <matteo.morelli@cea.fr> - Bug #581690
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.build;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.PackageXMLUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillRealizBuildUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create CMakeLists file for a list of skill realizations
 */
@SuppressWarnings("all")
public class CreateSkillRealizPackageXML {
  public static CharSequence createPackageXML(final org.eclipse.uml2.uml.Package model, final Set<SkillDefinition> skills, final List<String> serviceDependNames) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?xml version=\"1.0\"?>");
    _builder.newLine();
    _builder.append("<?xml-model href=\"http://download.ros.org/schema/package_format3.xsd\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>");
    _builder.newLine();
    _builder.append("<package format=\"3\">");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<name>");
    String _realizationPackageName = SkillUtils.realizationPackageName(model);
    _builder.append(_realizationPackageName, "  ");
    _builder.append("</name>");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("<version>0.0.0</version>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<description>");
    String _name = model.getName();
    _builder.append(_name, "  ");
    _builder.append(" package</description>");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("<maintainer email=\"");
    String _maintainerMail = PackageXMLUtils.getMaintainerMail(model);
    _builder.append(_maintainerMail, "  ");
    _builder.append("\">");
    String _maintainerName = PackageXMLUtils.getMaintainerName(model);
    _builder.append(_maintainerName, "  ");
    _builder.append("</maintainer>");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("<license>Apache2.0</license>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<url type=\"website\">https://eclipse.org/papyrus</url>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<author email=\"");
    String _authorMail = PackageXMLUtils.getAuthorMail(model);
    _builder.append(_authorMail, "  ");
    _builder.append("\">");
    String _authorName = PackageXMLUtils.getAuthorName(model);
    _builder.append(_authorName, "  ");
    _builder.append("</author>");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<buildtool_depend>ament_cmake</buildtool_depend>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>nav2_common</build_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>rclcpp</build_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>rclcpp_action</build_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>behaviortree_cpp_v3</build_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>nav2_behavior_tree</build_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<build_depend>bt_utils</build_depend>");
    _builder.newLine();
    {
      for(final String pkgName : serviceDependNames) {
        _builder.append("  ");
        _builder.append("<build_depend>");
        _builder.append(pkgName, "  ");
        _builder.append("</build_depend>");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<exec_depend>rclcpp</exec_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<exec_depend>rclcpp_action</exec_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<exec_depend>behaviortree_cpp_v3</exec_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<exec_depend>nav2_behavior_tree</exec_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<exec_depend>bt_utils</exec_depend>");
    _builder.newLine();
    {
      for(final String pkgName_1 : serviceDependNames) {
        _builder.append("  ");
        _builder.append("<exec_depend>");
        _builder.append(pkgName_1, "  ");
        _builder.append("</exec_depend>");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<test_depend>ament_lint_auto</test_depend>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<test_depend>ament_lint_common</test_depend>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<export>");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<build_type>ament_cmake</build_type>");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("</export>");
    _builder.newLine();
    _builder.append("</package>");
    _builder.newLine();
    return _builder;
  }

  public static void generate(final IPFileSystemAccess fileAccess, final org.eclipse.uml2.uml.Package pkg, final Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap) {
    final List<String> serviceDependNames = SkillRealizBuildUtils.calcDependencies(skdefToSemanticsMap);
    fileAccess.generateFile("package.xml", CreateSkillRealizPackageXML.createPackageXML(pkg, skdefToSemanticsMap.keySet(), serviceDependNames).toString());
  }
}
