/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.component;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppModelElementsCreator;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.component.ComponentHeader;
import org.eclipse.papyrus.robotics.ros2.codegen.cpp.utils.ProjectTools;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class RoboticsCppCreator
extends CppModelElementsCreator {
    String skeletonFolder;
    String userSrcFolder;
    Package currentModel;

    public RoboticsCppCreator(IProject project, IPFileSystemAccess fileAccess, String skeletonFolder, String userSrcFolder) {
        super(project, fileAccess, null);
        this.skeletonFolder = skeletonFolder;
        this.userSrcFolder = userSrcFolder;
    }

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor) {
        this.currentModel = PackageUtil.getRootPackage((Element)element);
        super.createPackageableElement(element, monitor);
    }

    protected void generateFile(String fileName, String content) {
        if (TransformationContext.monitor.isCanceled()) {
            throw Exceptions.sneakyThrow((Throwable)new TransformationException(ExecuteTransformationChain.USER_CANCEL));
        }
        ProjectTools.waitForCDT();
        TransformationContext.monitor.subTask("generate file " + fileName);
        TransformationContext.monitor.worked(1);
        if (this.currentModel != null) {
            content = String.valueOf(ComponentHeader.getHeader(this.currentModel)) + (String)content;
        }
        if (fileName.startsWith(this.skeletonFolder)) {
            IFileExists existsFSA;
            String srcFileName = fileName.replaceFirst(this.skeletonFolder, this.userSrcFolder);
            if (this.fileSystemAccess instanceof IFileExists && !(existsFSA = (IFileExists)this.fileSystemAccess).existsFile(srcFileName)) {
                super.generateFile(srcFileName, (String)content);
            }
        }
        super.generateFile(fileName, (String)content);
    }

    public String getFileName(NamedElement element) {
        if (element.getName() != null && element.getName().endsWith(CodeSkeleton.POSTFIX)) {
            return this.skeletonFolder + this.locStrategy.getFileName(element);
        }
        return super.getFileName(element);
    }
}

