/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.preferences;

import org.eclipse.papyrus.robotics.ros2.preferences.Ros2PreferenceUtils;

public class Ros2Distributions {
    public static RDLiteral getRosDistro() {
        String rosDistro = Ros2PreferenceUtils.getRosDistroStr();
        RDLiteral[] rDLiteralArray = RDLiteral.values();
        int n = rDLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            RDLiteral lit = rDLiteralArray[n2];
            if (Ros2Distributions.getDistroName(lit).equals(rosDistro)) {
                return lit;
            }
            ++n2;
        }
        return RDLiteral.UNKNOWN;
    }

    public static String getDistroName(RDLiteral literal) {
        return literal.toString().toLowerCase();
    }

    public static boolean since(RDLiteral distroA, RDLiteral distroB) {
        return distroA.ordinal() >= distroB.ordinal();
    }

    public static enum RDLiteral {
        UNKNOWN,
        ELOQUENT,
        FOXY,
        GALACTIC,
        HUMBLE,
        IRON,
        JAZZY;

    }
}

