/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.wizards.pages;

import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectViewPointPage
extends WizardPage {
    public static final boolean ENABLE_SAFETY = false;
    public static final String PAGE_ID = "SelectViewPointPage";
    protected String selectedId;
    protected Button safetyButton;
    protected Composite comp;

    public SelectViewPointPage() {
        super("Select model kind");
        this.setDescription("Select the kind of model that you want to create");
    }

    public String getSelectedID() {
        return this.selectedId;
    }

    public void setSelectedID(String selectedId) {
        Control[] controlArray = this.comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control unC = controlArray[n2];
            if (unC instanceof Button) {
                Button unB = (Button)unC;
                MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById("org.eclipse.papyrus.robotics.architecture");
                MergedArchitectureViewpoint viewpoint = SelectViewPointPage.getViewpointById(context, selectedId);
                if (viewpoint.getId().equals(unB.getData())) {
                    this.setPageComplete(true);
                    this.selectedId = (String)unB.getData();
                    unB.setSelection(true);
                }
            }
            ++n2;
        }
    }

    public String[] getSelectedIDs() {
        ArrayList<String> viewPoints = new ArrayList<String>();
        viewPoints.add(this.selectedId);
        if (this.selectedId.endsWith("ComponentDevelopment") || this.selectedId.endsWith("SystemConfiguration")) {
            viewPoints.add("org.eclipse.papyrus.robotics.viewpoint.Assertions");
        }
        return viewPoints.toArray(new String[0]);
    }

    public void createControl(Composite parent) {
        this.comp = SelectViewPointPage.createComposite(parent, 1, 1, 1808, 0, 0);
        ((GridData)this.comp.getLayoutData()).widthHint = 300;
        this.setControl((Control)this.comp);
        Label label = new Label(this.comp, 0);
        label.setText("Main objective");
        SelectViewPointPage.createVerticalSpacer(this.comp, 1);
        MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById("org.eclipse.papyrus.robotics.architecture");
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent se) {
                SelectViewPointPage.this.setPageComplete(true);
                Button button = (Button)se.getSource();
                SelectViewPointPage.this.selectedId = (String)button.getData();
            }
        };
        String[] tier3_ids = new String[]{"ComponentDevelopment", "SystemConfiguration", "BehaviorTreeDesign", "TadkBasedHazardAnalysis"};
        SelectViewPointPage.addButtons(context, this.comp, sl, tier3_ids);
        SelectViewPointPage.createVerticalSpacer(this.comp, 10);
        String[] tier2_ids = new String[]{"ServiceDesign", "BehaviorDesign"};
        SelectViewPointPage.addButtons(context, this.comp, sl, tier2_ids);
        this.setPageComplete(false);
    }

    protected static void addButtons(MergedArchitectureContext context, Composite comp, SelectionListener sl, String[] ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            MergedArchitectureViewpoint viewpoint = SelectViewPointPage.getViewpointById(context, id);
            if (viewpoint != null) {
                Button radio = new Button(comp, 16);
                radio.setText(viewpoint.getDescription());
                radio.setData((Object)viewpoint.getId());
                radio.addSelectionListener(sl);
            }
            ++n2;
        }
    }

    protected static MergedArchitectureViewpoint getViewpointById(MergedArchitectureContext context, String id) {
        for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
            if (!viewpoint.getId().endsWith(id)) continue;
            return viewpoint;
        }
        return null;
    }

    private static Composite createComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void createVerticalSpacer(Composite parent, int numlines) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(768);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        gd.heightHint = numlines;
        lbl.setLayoutData((Object)gd);
    }
}

