/*****************************************************************************
 * Copyright (c) 2019 CEA LIST, and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.sysml16.architecture.util;

/**
 * Utility class to get informations on DeprecatedElement resources.
 */
public final class SysML16chitectureUtil {
	
	private SysML16chitectureUtil(){
		// Do nothing
	}

    public static final String DIAGRAM_ACTIVITY_ID = "org.eclipse.papyrus.sysml16.diagram.activity"; //$NON-NLS-1$
    public static final String DIAGRAM_BLOCK_DEFINITION_ID = "org.eclipse.papyrus.sysml16.diagram.blockdefinition"; //$NON-NLS-1$	
    public static final String DIAGRAM_INTERNAL_BLOCK_ID = "org.eclipse.papyrus.sysml16.diagram.internalblock"; //$NON-NLS-1$
    public static final String DIAGRAM_PACKAGE_ID = "org.eclipse.papyrus.sysml16.diagram.package"; //$NON-NLS-1$
    public static final String DIAGRAM_PARAMETRIC_ID = "org.eclipse.papyrus.sysml16.diagram.parametric"; //$NON-NLS-1$	
    public static final String DIAGRAM_REQUIREMENT_ID = "org.eclipse.papyrus.sysml16.diagram.requirement"; //$NON-NLS-1$
    public static final String DIAGRAM_SEQUENCE_ID = "org.eclipse.papyrus.sysml16.diagram.sequence"; //$NON-NLS-1$
    public static final String DIAGRAM_STATE_MACHINE_ID = "org.eclipse.papyrus.sysml16.diagram.stateMachine"; //$NON-NLS-1$
    public static final String DIAGRAM_USE_CASE_ID = "org.eclipse.papyrus.sysml16.diagram.useCase"; //$NON-NLS-1$
    
    public static final String TABLE_REQUIREMENT_ID = "org.eclipse.papyrus.sysml16.table.requirement"; //$NON-NLS-1$	
    public static final String TABLE_REQUIREMENT_TREE_ID = "org.eclipse.papyrus.sysml16.table.requirementTree"; //$NON-NLS-1$	
    public static final String TABLE_ALLOCATION_ID = "org.eclipse.papyrus.sysml16.table.allocation"; //$NON-NLS-1$	
	
}
