/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.papyrus.gmf.internal.common.Activator;
import org.eclipse.papyrus.gmf.internal.common.ui.Messages;

public class ValidationHelper {
    private ValidationHelper() {
    }

    public static boolean matches(Diagnostic diagnostic, int severityBitMask) {
        return (diagnostic.getSeverity() & severityBitMask) != 0;
    }

    public static boolean isOK(Diagnostic diagnostic) {
        return diagnostic.getSeverity() == 0;
    }

    public static Diagnostic validate(EObject eObject, boolean createMarkers, IProgressMonitor progressMonitor) {
        SubProgressMonitor monitor = null;
        try {
            int count = -1;
            if (progressMonitor != null) {
                TreeIterator i = eObject.eAllContents();
                while (i.hasNext()) {
                    ++count;
                    i.next();
                }
            }
            monitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
            monitor.beginTask("", count);
            monitor.subTask(Messages.ValidationHelper_task_validate);
            Diagnostic validationStatus = new SmartDiagnostician((IProgressMonitor)monitor).validate(eObject);
            if (validationStatus.getSeverity() == 8) {
                Diagnostic diagnostic = validationStatus;
                return diagnostic;
            }
            if (createMarkers) {
                Diagnostic diagnostic = ValidationHelper.createMarkers(validationStatus, "org.eclipse.emf.ecore.diagnostic");
                return diagnostic;
            }
            Diagnostic diagnostic = validationStatus;
            return diagnostic;
        }
        finally {
            monitor.done();
        }
    }

    public static Diagnostic validate(EObject eObject, boolean createMarkers) {
        return ValidationHelper.validate(eObject, createMarkers, null);
    }

    public static DiagnosticMarkerMap getDiagnosticMarkerMap(Diagnostic diagnostic) {
        List data = diagnostic.getData() != null ? diagnostic.getData() : Collections.EMPTY_LIST;
        for (Object dataItem : data) {
            if (!(dataItem instanceof DiagnosticMarkerMap)) continue;
            return (DiagnosticMarkerMap)dataItem;
        }
        return null;
    }

    public static IFile getFileFromDiagnostic(Diagnostic diagnostic) {
        return new GMFMarkerHelper("org.eclipse.emf.ecore.diagnostic").getFileFromDiagnostic(diagnostic);
    }

    public static Diagnostic createResourceProblemMarkers(Diagnostic diagnostic) {
        return ValidationHelper.createMarkers(diagnostic, null);
    }

    private static Diagnostic createMarkers(Diagnostic diagnostic, String markerID) {
        GMFMarkerHelper markerHelper = new GMFMarkerHelper(markerID);
        try {
            markerHelper.deleteMarkers(diagnostic, false, 0);
            if (!diagnostic.getChildren().isEmpty() && !ValidationHelper.isOK(diagnostic)) {
                markerHelper.createMarkers(diagnostic);
            }
        }
        catch (CoreException e) {
            IStatus status = Activator.createError(Messages.ValidationHelper_e_marker_creation, e);
            Activator.log(status);
        }
        DiagnosticMarkerMap markerMap = new DiagnosticMarkerMap(markerHelper.getDiagnostic2MarkerMap());
        ArrayList<DiagnosticMarkerMap> data = new ArrayList<DiagnosticMarkerMap>(diagnostic.getData() != null ? diagnostic.getData() : Collections.emptyList());
        data.add(markerMap);
        BasicDiagnostic result = new BasicDiagnostic(diagnostic.getSource(), diagnostic.getCode(), diagnostic.getMessage(), data.toArray());
        result.addAll(diagnostic);
        return result;
    }

    public static class DiagnosticMarkerMap {
        private Map<Diagnostic, IMarker> map;

        DiagnosticMarkerMap(LinkedHashMap<Diagnostic, IMarker> markerMap) {
            this.map = Collections.unmodifiableMap(markerMap);
        }

        public Map<Diagnostic, IMarker> getMap() {
            return this.map;
        }
    }

    private static class GMFMarkerHelper
    extends EditUIMarkerHelper {
        private LinkedHashMap<Diagnostic, IMarker> diagnostic2Marker;
        private String markerID;

        GMFMarkerHelper() {
        }

        GMFMarkerHelper(String markerID) {
            this.markerID = markerID;
        }

        public IFile getFileFromDiagnostic(Diagnostic diagnostic) {
            return this.getFile(diagnostic);
        }

        protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
            Object target;
            this.getDiagnostic2MarkerMap().put(diagnostic, marker);
            List data = diagnostic.getData();
            if (data != null && !data.isEmpty() && (target = data.get(0)) instanceof EObject) {
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)((EObject)target)).toString());
            }
            super.adjustMarker(marker, diagnostic, parentDiagnostic);
        }

        protected IFile getFile(Object datum) {
            URI uri;
            IFile file;
            EObject eObject;
            if (datum instanceof EObject && (eObject = (EObject)datum).eResource() != null && (file = this.getFile(uri = eObject.eResource().getURI())) != null) {
                return file;
            }
            return super.getFile(datum);
        }

        protected String getMarkerID() {
            return this.markerID != null ? this.markerID : super.getMarkerID();
        }

        LinkedHashMap<Diagnostic, IMarker> getDiagnostic2MarkerMap() {
            if (this.diagnostic2Marker == null) {
                this.diagnostic2Marker = new LinkedHashMap();
            }
            return this.diagnostic2Marker;
        }
    }

    private static class SmartDiagnostician
    extends Diagnostician {
        private static ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        private IProgressMonitor monitor;

        SmartDiagnostician(IProgressMonitor progressMonitor) {
            this.monitor = progressMonitor;
        }

        public String getObjectLabel(EObject eObject) {
            if (eObject != null) {
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
                if (itemLabelProvider != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
            } else {
                return "";
            }
            return super.getObjectLabel(eObject);
        }

        public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            if (this.monitor.isCanceled()) {
                return true;
            }
            this.monitor.worked(1);
            return super.validate(eClass, eObject, diagnostics, context);
        }
    }
}

