/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.semantic.checker;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.semantic.checker.ISemanticRepresentationElementCreationChecker;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Element;
import org.junit.Assert;

public abstract class AbstractSemanticCreationChecker
implements ISemanticRepresentationElementCreationChecker {
    private static final int DEFAULT_CREATED_ELEMENTS_NUMBER = 1;
    protected final EObject semanticOwner;
    private final EReference containmentFeature;
    private final Class<? extends Element> expectedType;
    protected final int nbChildren;
    protected int expectedCreatedElements = 1;
    protected int expectedAssociatedElements = 1;
    protected int semanticIndex = -1;

    public AbstractSemanticCreationChecker(EObject expectedOwner, EReference containmentFeature) {
        this(expectedOwner, containmentFeature, containmentFeature.getEReferenceType().getInstanceClass());
    }

    public AbstractSemanticCreationChecker(EObject expectedOwner, EReference containmentFeature, Class<? extends Element> expectedType) {
        this.semanticOwner = expectedOwner;
        this.expectedType = expectedType;
        this.containmentFeature = containmentFeature;
        Assert.assertTrue((String)"Not multi-valued Owning feature is not yet implemented", (boolean)containmentFeature.isMany());
        if (containmentFeature != null) {
            Assert.assertTrue((String)NLS.bind((String)"Invalid containment: {0} is not {1}", (Object)this.semanticOwner.eClass().getName(), (Object)containmentFeature.getEContainingClass().getName()), (boolean)containmentFeature.getEContainingClass().isInstance((Object)this.semanticOwner));
        }
        this.nbChildren = this.getContainmentFeatureValue().size();
    }

    @Override
    public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {
        EList semanticElements = createdElementRepresentation.getSemanticElements();
        Assert.assertEquals((String)"Unexpected associated element", (long)this.getExpectedAssociatedElements(), (long)semanticElements.size());
        EObject element = this.getSemanticElement(createdElementRepresentation);
        this.validateSemanticElementInstance(element);
        this.validateSemanticOwner(element);
    }

    protected EObject getSemanticElement(DRepresentationElement view) {
        if (this.semanticIndex < 0) {
            return view.getTarget();
        }
        return (EObject)view.getSemanticElements().get(this.semanticIndex);
    }

    protected void validateSemanticOwner(EObject semanticElement) {
        Assert.assertEquals((String)"Semantic owner does not contain created element.", (Object)this.semanticOwner, (Object)semanticElement.eContainer());
        Collection<?> values = this.getContainmentFeatureValue();
        Assert.assertTrue((String)"Created element is not owned by expected feature.", (boolean)values.contains(semanticElement));
        Assert.assertEquals((String)"Unexpected additional elements after creation.", (long)this.getNumberOfExpectedCreatedElement(), (long)(values.size() - this.nbChildren));
    }

    protected void validateSemanticElementInstance(EObject semanticElement) {
        Assert.assertTrue((String)NLS.bind((String)"Unexpected class for created element: expected {0} was {1}", (Object)this.expectedType.getName(), (Object)semanticElement.eClass().getInstanceClassName()), (boolean)this.expectedType.isInstance(semanticElement));
    }

    public int getExpectedAssociatedElements() {
        return this.expectedAssociatedElements;
    }

    public void setExpectedAssociatedElements(int value) {
        this.expectedAssociatedElements = value;
    }

    public int getNumberOfExpectedCreatedElement() {
        return this.expectedCreatedElements;
    }

    public void setExpectedCreatedElements(int value) {
        this.expectedCreatedElements = value;
    }

    @Override
    public void validateAfterUndo() {
        Assert.assertEquals((String)"Unexpected elements after after undo.", (long)this.nbChildren, (long)this.getContainmentFeatureValue().size());
    }

    @Override
    public void validateAfterRedo() {
        Assert.assertEquals((String)"Unexpected additional elements after redo.", (long)this.getNumberOfExpectedCreatedElement(), (long)(this.getContainmentFeatureValue().size() - this.nbChildren));
    }

    public void setSemanticIndex(int index) {
        this.semanticIndex = index;
    }

    protected final Collection<?> getContainmentFeatureValue() {
        return (Collection)this.semanticOwner.eGet((EStructuralFeature)this.getContainmentFeature());
    }

    protected EReference getContainmentFeature() {
        return this.containmentFeature;
    }
}

