/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.application;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenActionFactoryContributionItem;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContributionItem;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContributionManager;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenGroupMarker;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMenuManager;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenSeparator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenSharedContributionItem;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenToolBarManager;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.CreationWizard;

@Singleton
@SuppressWarnings("all")
public class ActionBarAdvisor {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private CreationWizard xptCreationWizard;

  @Inject
  private WorkbenchWindowAdvisor xptWorkbenchWindowAdvisor;

  public CharSequence className(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _actionBarAdvisorClassName = it.getActionBarAdvisorClassName();
    _builder.append(_actionBarAdvisorClassName);
    return _builder;
  }

  public CharSequence packageName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence ActionBarAdvisor(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.ui.application.ActionBarAdvisor {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.ui.actions.ActionFactory.IWorkbenchAction lockToolBarAction;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   ");
    _builder.append("private org.eclipse.ui.actions.ActionFactory.IWorkbenchAction toggleCoolbarAction;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(org.eclipse.ui.application.IActionBarConfigurer configurer) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(configurer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.ui.IWorkbenchWindow getWindow() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getActionBarConfigurer().getWindowConfigurer().getWindow();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void makeActions(org.eclipse.ui.IWorkbenchWindow window) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("toggleCoolbarAction = org.eclipse.ui.actions.ActionFactory.TOGGLE_COOLBAR.create(window);");
    _builder.newLine();
    _builder.append("\t\t      ");
    _builder.append("register(toggleCoolbarAction);");
    _builder.newLine();
    _builder.append("\t\t      ");
    _builder.append("lockToolBarAction = org.eclipse.ui.actions.ActionFactory.LOCK_TOOL_BAR.create(window);");
    _builder.newLine();
    _builder.append("\t\t      ");
    _builder.append("register(lockToolBarAction);");
    _builder.newLine();
    {
      EList<GenContributionItem> _sharedContributionItems = it.getSharedContributionItems();
      for(final GenContributionItem ci : _sharedContributionItems) {
        _builder.append("\t\t      ");
        CharSequence _makeAction = this.makeAction(ci, "window");
        _builder.append(_makeAction, "\t\t      ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void fillMenuBar(org.eclipse.jface.action.IMenuManager menu) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _fill = this.fill(it.getMainMenu(), "menu");
    _builder.append(_fill, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void fillCoolBar(org.eclipse.jface.action.ICoolBarManager toolBar) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.action.IMenuManager popUpMenu = new org.eclipse.jface.action.MenuManager();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("popUpMenu.add(new org.eclipse.jface.action.ActionContributionItem(lockToolBarAction));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("popUpMenu.add(new org.eclipse.jface.action.ActionContributionItem(toggleCoolbarAction));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("toolBar.setContextMenuManager(popUpMenu);");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _fill_1 = this.fill(it.getMainToolBar(), "toolBar");
    _builder.append(_fill_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _openEditor = this.openEditor(it.getEditorGen().getEditor());
    _builder.append(_openEditor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _actions = this.actions(it);
    _builder.append(_actions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence openEditor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static boolean openEditor(org.eclipse.ui.IWorkbench workbench, org.eclipse.emf.common.util.URI fileURI) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IWorkbenchPage page = workbenchWindow.getActivePage();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.IEditorDescriptor editorDescriptor =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("workbench.getEditorRegistry().getDefaultEditor(fileURI.toFileString());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (editorDescriptor == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.dialogs.MessageDialog.openError(workbenchWindow.getShell(), ");
    _builder.newLine();
    _builder.append("\t\t             ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultFileEditorErrorDialog(it.getEditorGen().getApplication())));
    _builder.append(_accessorCall, "\t\t             ");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.osgi.util.NLS.bind(");
    _builder.newLine();
    _builder.append("\t\t    ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.messageKey(this.i18nKeyForDefaultFileEditorErrorDialog(it.getEditorGen().getApplication())));
    _builder.append(_accessorCall_1, "\t\t    ");
    _builder.append(", ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t    ");
    _builder.append("fileURI.toFileString()));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("page.openEditor(new org.eclipse.emf.common.ui.URIEditorInput(fileURI), editorDescriptor.getId());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException exception) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.MessageDialog.openError(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("workbenchWindow.getShell(), ");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultEditorOpenErrorDialog(it.getEditorGen().getApplication())));
    _builder.append(_accessorCall_2, "\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("exception.getMessage());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _makeAction(final GenContributionItem it, final String windowVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Can not make action for " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _makeAction(final GenActionFactoryContributionItem it, final String windowVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("register(org.eclipse.ui.actions.ActionFactory.");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append(".create(");
    _builder.append(windowVar);
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence fill(final GenContributionManager it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenContributionItem> _items = it.getItems();
      for(final GenContributionItem i : _items) {
        CharSequence _contribute = this.contribute(i, managerVar);
        _builder.append(_contribute);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _contribute(final GenContributionItem it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Can not contribute item: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contribute(final GenGroupMarker it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(managerVar);
    _builder.append(".add(new org.eclipse.jface.action.GroupMarker(");
    String _groupName = it.getGroupName();
    _builder.append(_groupName);
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contribute(final GenSeparator it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(managerVar);
    _builder.append(".add(new org.eclipse.jface.action.Separator(");
    {
      String _groupName = it.getGroupName();
      boolean _tripleNotEquals = (null != _groupName);
      if (_tripleNotEquals) {
        String _groupName_1 = it.getGroupName();
        _builder.append(_groupName_1);
      }
    }
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contribute(final GenMenuManager it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    String menuVar = (managerVar + "X");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.action.IMenuManager ");
    _builder.append(menuVar, "\t");
    _builder.append(" = new  org.eclipse.jface.action.MenuManager(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _name = it.getName();
      boolean _tripleNotEquals = (null != _name);
      if (_tripleNotEquals) {
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForMenu(it));
        _builder.append(_accessorCall, "\t");
      } else {
        _builder.append("null");
      }
    }
    {
      String _iD = it.getID();
      boolean _tripleNotEquals_1 = (null != _iD);
      if (_tripleNotEquals_1) {
        _builder.append(", ");
        String _iD_1 = it.getID();
        _builder.append(_iD_1, "\t");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      EList<GenContributionItem> _items = it.getItems();
      for(final GenContributionItem i : _items) {
        _builder.append("\t");
        CharSequence _contribute = this.contribute(i, menuVar);
        _builder.append(_contribute, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append(managerVar, "\t");
    _builder.append(".add(");
    _builder.append(menuVar, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contribute(final GenToolBarManager it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    String toolBarVar = (managerVar + "X");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.action.IToolBarManager ");
    _builder.append(toolBarVar, "\t");
    _builder.append(" = new  org.eclipse.jface.action.ToolBarManager();");
    _builder.newLineIfNotEmpty();
    {
      EList<GenContributionItem> _items = it.getItems();
      for(final GenContributionItem i : _items) {
        _builder.append("\t");
        CharSequence _contribute = this.contribute(i, toolBarVar);
        _builder.append(_contribute, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append(managerVar, "\t");
    _builder.append(".add(new org.eclipse.jface.action.ToolBarContributionItem(");
    _builder.append(toolBarVar, "\t");
    {
      String _iD = it.getID();
      boolean _tripleNotEquals = (null != _iD);
      if (_tripleNotEquals) {
        _builder.append(", ");
        String _iD_1 = it.getID();
        _builder.append(_iD_1, "\t");
      }
    }
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _contribute(final GenSharedContributionItem it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _contributeShared = this.contributeShared(it.getActualItem(), managerVar);
    _builder.append(_contributeShared);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contributeShared(final GenContributionItem it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Can not contribute shared item: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _contributeShared(final GenActionFactoryContributionItem it, final String managerVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(managerVar);
    _builder.append(".add(getAction(org.eclipse.ui.actions.ActionFactory.");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append(".getId()));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence actions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _NewDiagramAction = this.NewDiagramAction(it);
    _builder.append(_NewDiagramAction);
    _builder.newLineIfNotEmpty();
    CharSequence _OpenUriAction = this.OpenUriAction(it);
    _builder.append(_OpenUriAction);
    _builder.newLineIfNotEmpty();
    CharSequence _OpenAction = this.OpenAction(it);
    _builder.append(_OpenAction);
    _builder.newLineIfNotEmpty();
    CharSequence _AboutAction = this.AboutAction(it);
    _builder.append(_AboutAction);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence NewDiagramAction(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class NewDiagramAction extends org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptCreationWizard.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(" wizard =");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("new ");
    CharSequence _qualifiedClassName_1 = this.xptCreationWizard.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("wizard.init(getWindow().getWorkbench(), org.eclipse.jface.viewers.StructuredSelection.EMPTY);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.wizard.WizardDialog wizardDialog =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.jface.wizard.WizardDialog(getWindow().getShell(), wizard);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("wizardDialog.open();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public CharSequence OpenUriAction(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class OpenURIAction extends org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.edit.ui.action.LoadResourceAction.LoadResourceDialog loadResourceDialog =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.emf.edit.ui.action.LoadResourceAction.LoadResourceDialog(getWindow().getShell());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.jface.dialogs.Dialog.OK == loadResourceDialog.open()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (java.util.Iterator i = loadResourceDialog.getURIs().iterator(); i.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("openEditor(getWindow().getWorkbench(), (org.eclipse.emf.common.util.URI) i.next());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public CharSequence OpenAction(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class OpenAction extends org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.FileDialog fileDialog =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.swt.widgets.FileDialog(getWindow().getShell(), org.eclipse.swt.SWT.OPEN);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fileDialog.open();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("openEditor(getWindow().getWorkbench(), org.eclipse.emf.common.util.URI.createFileURI(");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("fileDialog.getFilterPath() + java.io.File.separator + fileDialog.getFileName()));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence AboutAction(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class AboutAction extends org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void run(org.eclipse.jface.action.IAction action) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.dialogs.MessageDialog.openInformation(getWindow().getShell(), ");
    _builder.newLine();
    _builder.append("\t\t             ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForAboutDialog(it)));
    _builder.append(_accessorCall, "\t\t             ");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t             ");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForAboutDialog(it)));
    _builder.append(_accessorCall_1, "\t\t             ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultFileEditorErrorDialog(it)));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForDefaultFileEditorErrorDialog(it)));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultEditorOpenErrorDialog(it)));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForAboutDialog(it)));
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForAboutDialog(it)));
    _builder.append(_accessorField_4);
    _builder.newLineIfNotEmpty();
    {
      GenMenuManager _mainMenu = it.getMainMenu();
      boolean _tripleNotEquals = (null != _mainMenu);
      if (_tripleNotEquals) {
        CharSequence _internal_i18nAccessors = this.internal_i18nAccessors(it.getMainMenu());
        _builder.append(_internal_i18nAccessors);
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenMenuManager> _collectGenMenuManagers = this.collectGenMenuManagers(it.getMainMenu().getItems());
          for(final GenMenuManager gmm : _collectGenMenuManagers) {
            CharSequence _internal_i18nAccessors_1 = this.internal_i18nAccessors(gmm);
            _builder.append(_internal_i18nAccessors_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      Iterable<GenMenuManager> _collectGenMenuManagers_1 = this.collectGenMenuManagers(it.getSharedContributionItems());
      for(final GenMenuManager gmm_1 : _collectGenMenuManagers_1) {
        CharSequence _internal_i18nAccessors_2 = this.internal_i18nAccessors(gmm_1);
        _builder.append(_internal_i18nAccessors_2);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence internal_i18nAccessors(final GenMenuManager it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _name = it.getName();
      boolean _tripleNotEquals = (null != _name);
      if (_tripleNotEquals) {
        CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForMenu(it));
        _builder.append(_accessorField);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18nValues(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultFileEditorErrorDialog(it)), "Error");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForDefaultFileEditorErrorDialog(it)), 
      "There is no editor registered for the file \"{0}\"");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForDefaultEditorOpenErrorDialog(it)), "Open Editor");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForAboutDialog(it)), "About");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    String _messageKey = this._externalizerUtils_qvto.messageKey(this.i18nKeyForAboutDialog(it));
    String _modelID = it.getEditorGen().getModelID();
    String _plus = (_modelID + " Diagram Editor");
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(_messageKey, _plus);
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    {
      GenMenuManager _mainMenu = it.getMainMenu();
      boolean _tripleNotEquals = (null != _mainMenu);
      if (_tripleNotEquals) {
        CharSequence _internal_i18nValues = this.internal_i18nValues(it.getMainMenu());
        _builder.append(_internal_i18nValues);
        _builder.newLineIfNotEmpty();
        {
          Iterable<GenMenuManager> _collectGenMenuManagers = this.collectGenMenuManagers(it.getMainMenu().getItems());
          for(final GenMenuManager gmm : _collectGenMenuManagers) {
            CharSequence _internal_i18nValues_1 = this.internal_i18nValues(gmm);
            _builder.append(_internal_i18nValues_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      Iterable<GenMenuManager> _collectGenMenuManagers_1 = this.collectGenMenuManagers(it.getSharedContributionItems());
      for(final GenMenuManager gmm_1 : _collectGenMenuManagers_1) {
        CharSequence _internal_i18nValues_2 = this.internal_i18nValues(gmm_1);
        _builder.append(_internal_i18nValues_2);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  @Localization
  public CharSequence internal_i18nValues(final GenMenuManager it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _name = it.getName();
      boolean _tripleNotEquals = (null != _name);
      if (_tripleNotEquals) {
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForMenu(it), it.getName());
        _builder.append(_messageEntry);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected Iterable<GenMenuManager> collectGenMenuManagers(final Iterable<GenContributionItem> allItems) {
    return Iterables.<GenMenuManager>filter(this.collectAllContributionItems(allItems), GenMenuManager.class);
  }

  protected Iterable<GenContributionManager> collectAllContributionItems(final Iterable<GenContributionItem> allItems) {
    return this.collectAllContributionItems(allItems, CollectionLiterals.<GenContributionManager>newLinkedList());
  }

  protected Iterable<GenContributionManager> collectAllContributionItems(final Iterable<GenContributionItem> allItems, final List<GenContributionManager> acc) {
    Iterable<GenContributionManager> managers = Iterables.<GenContributionManager>filter(allItems, GenContributionManager.class);
    Iterables.<GenContributionManager>addAll(acc, managers);
    for (final GenContributionManager m : managers) {
      this.collectAllContributionItems(m.getItems(), acc);
    }
    return acc;
  }

  @Localization
  protected String i18nKeyForMenu(final GenMenuManager menuManager) {
    String _name = menuManager.getName();
    return ("ApplicationMenuName." + _name);
  }

  @Localization
  protected String i18nKeyForWindowTitle(final GenApplication app) {
    CharSequence _className = this.xptWorkbenchWindowAdvisor.className(app);
    return (_className + ".Title");
  }

  @Localization
  protected String i18nKeyForAboutDialog(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".AboutDialog");
  }

  @Localization
  protected String i18nKeyForDefaultFileEditorErrorDialog(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".DefaultFileEditor");
  }

  @Localization
  protected String i18nKeyForDefaultEditorOpenErrorDialog(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".DefaultEditorOpenError");
  }

  @XbaseGenerated
  public CharSequence makeAction(final GenContributionItem it, final String windowVar) {
    if (it instanceof GenActionFactoryContributionItem) {
      return _makeAction((GenActionFactoryContributionItem)it, windowVar);
    } else if (it != null) {
      return _makeAction(it, windowVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, windowVar).toString());
    }
  }

  @XbaseGenerated
  public CharSequence contribute(final GenContributionItem it, final String managerVar) {
    if (it instanceof GenGroupMarker) {
      return _contribute((GenGroupMarker)it, managerVar);
    } else if (it instanceof GenMenuManager) {
      return _contribute((GenMenuManager)it, managerVar);
    } else if (it instanceof GenSeparator) {
      return _contribute((GenSeparator)it, managerVar);
    } else if (it instanceof GenSharedContributionItem) {
      return _contribute((GenSharedContributionItem)it, managerVar);
    } else if (it instanceof GenToolBarManager) {
      return _contribute((GenToolBarManager)it, managerVar);
    } else if (it != null) {
      return _contribute(it, managerVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, managerVar).toString());
    }
  }

  @XbaseGenerated
  public CharSequence contributeShared(final GenContributionItem it, final String managerVar) {
    if (it instanceof GenActionFactoryContributionItem) {
      return _contributeShared((GenActionFactoryContributionItem)it, managerVar);
    } else if (it != null) {
      return _contributeShared(it, managerVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, managerVar).toString());
    }
  }
}
