/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.navigator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class DomainNavigatorLabelProvider {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  @Inject
  private Activator xptActivator;

  @Inject
  private NavigatorContentProvider xptNavigatorContentProvider;

  @Inject
  private DomainNavigatorItem xptDomainNavigatorItem;

  public CharSequence className(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _domainLabelProviderClassName = it.getDomainLabelProviderClassName();
    _builder.append(_domainLabelProviderClassName);
    return _builder;
  }

  public CharSequence packageName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence implementsList(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.ui.navigator.ICommonLabelProvider");
    return _builder;
  }

  public CharSequence DomainNavigatorLabelProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _iCommonLabelProvider = this.iCommonLabelProvider(it);
    _builder.append(_iCommonLabelProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _iLabelProvider = this.iLabelProvider(it);
    _builder.append(_iLabelProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _iBaseLabelProvider = this.iBaseLabelProvider(it);
    _builder.append(_iBaseLabelProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _iMementoAware = this.xptNavigatorContentProvider.iMementoAware(it);
    _builder.append(_iMementoAware, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _iDescriptionProvider = this.iDescriptionProvider(it);
    _builder.append(_iDescriptionProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence attributes(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider myAdapterFactoryLabelProvider = new org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance().getItemProvidersAdapterFactory());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence iCommonLabelProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init(org.eclipse.ui.navigator.ICommonContentExtensionSite aConfig) {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence iLabelProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _image = this.getImage(it);
    _builder.append(_image);
    _builder.newLineIfNotEmpty();
    CharSequence _text = this.getText(it);
    _builder.append(_text);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence iBaseLabelProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _addListener = this.addListener(it);
    _builder.append(_addListener);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _dispose = this.dispose(it);
    _builder.append(_dispose);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _isLabelProperty = this.isLabelProperty(it);
    _builder.append(_isLabelProperty);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _removeListener = this.removeListener(it);
    _builder.append(_removeListener);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence iDescriptionProvider(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getDescription(Object anElement) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence addListener(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void addListener(org.eclipse.jface.viewers.ILabelProviderListener listener) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myAdapterFactoryLabelProvider.addListener(listener);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence dispose(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myAdapterFactoryLabelProvider.dispose();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence isLabelProperty(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isLabelProperty(Object element, String property) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myAdapterFactoryLabelProvider.isLabelProperty(element, property);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence removeListener(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public void removeListener(org.eclipse.jface.viewers.ILabelProviderListener listener) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myAdapterFactoryLabelProvider.removeListener(listener);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getImage(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.swt.graphics.Image getImage(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return myAdapterFactoryLabelProvider.getImage(");
    CharSequence _eObject = this.getEObject(it);
    _builder.append(_eObject, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getEObject(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("((");
    CharSequence _qualifiedClassName = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(") element).getEObject()");
    return _builder;
  }

  public CharSequence getText(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getText(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptDomainNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return myAdapterFactoryLabelProvider.getText(");
    CharSequence _eObject = this.getEObject(it);
    _builder.append(_eObject, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
