/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.config;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;

public abstract class AbstractCellAxisConfiguration
implements ICellAxisConfiguration,
IAxisCellEditorConfiguration {
    protected static final INattableModelManager getModelManager(IConfigRegistry fromRegistry) {
        return (INattableModelManager)fromRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
    }

    protected static final Table getTable(IConfigRegistry fromRegistry) {
        INattableModelManager manager = AbstractCellAxisConfiguration.getModelManager(fromRegistry);
        if (manager == null) {
            return null;
        }
        return manager.getTable();
    }

    @Override
    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        INattableModelManager modelManager = AbstractCellAxisConfiguration.getModelManager(configRegistry);
        Table table = modelManager.getTable();
        Object axisElement = AxisUtils.getRepresentedElement(axis);
        DisplayMode displayMode = this.getDisplayMode(table, axisElement);
        ICellPainter painter = this.getCellPainter(table, axisElement);
        ICellEditor editor = this.getICellEditor(table, axisElement, modelManager.getTableAxisElementProvider());
        IDisplayConverter converter = this.getDisplayConvert(table, axisElement, (ILabelProvider)new EMFLabelProvider());
        IDataValidator validator = this.getDataValidator(table, axisElement);
        if (painter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)painter, displayMode, configLabel);
        }
        if (editor != null) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, displayMode, configLabel);
        }
        if (converter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)converter, displayMode, configLabel);
        }
        if (validator != null) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)validator, displayMode, configLabel);
        }
    }

    @Override
    public IDataValidator getDataValidator(Table table, Object axisElement) {
        return null;
    }

    @Override
    public IDisplayConverter getDisplayConvert(Table table, Object axisElement, ILabelProvider provider) {
        return null;
    }

    @Override
    public DisplayMode getDisplayMode(Table table, Object axisElement) {
        return DisplayMode.NORMAL;
    }
}

