/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.operations;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.types.advices.constraints.PermissionResult;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferencePermission;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.AdviceConstraintOperations;

public class ReferenceConstraintOperations
extends AdviceConstraintOperations {
    protected ReferenceConstraintOperations() {
    }

    public static boolean approveRequest(ReferenceConstraint referenceConstraint, IEditCommandRequest request) {
        Function<ReferencePermission, PermissionResult> evaluator = request instanceof CreateRelationshipRequest ? null : (request instanceof CreateElementRequest ? permission -> ReferenceConstraintOperations.approveRequest(permission, (CreateElementRequest)request) : (request instanceof MoveRequest ? permission -> ReferenceConstraintOperations.approveRequest(permission, (MoveRequest)request) : (request instanceof SetRequest ? permission -> ReferenceConstraintOperations.approveRequest(permission, (SetRequest)request) : null)));
        return ReferenceConstraintOperations.approveRequest(request, referenceConstraint.getPermissions(), evaluator);
    }

    private static PermissionResult approveRequest(ReferencePermission permission, CreateElementRequest request) {
        PermissionResult result = PermissionResult.NONE;
        EReference containment = request.getContainmentFeature();
        if (containment != null) {
            result = ReferenceConstraintOperations.evaluate(permission, request.getContainmentFeature(), request.getElementType());
        } else {
            EObject container = request.getContainer();
            IElementType type = request.getElementType();
            Iterator iter = container.eClass().getEAllContainments().iterator();
            while (iter.hasNext() && !result.isDetermined()) {
                EReference next = (EReference)iter.next();
                if (!next.isChangeable() || !next.getEReferenceType().isSuperTypeOf(type.getEClass())) continue;
                result = ReferenceConstraintOperations.evaluate(permission, next, type);
            }
        }
        return result;
    }

    private static PermissionResult approveRequest(ReferencePermission permission, MoveRequest request) {
        PermissionResult result = PermissionResult.NONE;
        Map elementsToMove = request.getElementsToMove();
        Iterator iter = elementsToMove.entrySet().iterator();
        while (iter.hasNext() && !result.isDetermined()) {
            Map.Entry entry = iter.next();
            EObject object = (EObject)entry.getKey();
            EReference containment = (EReference)entry.getValue();
            if (containment != null) {
                result = ReferenceConstraintOperations.evaluate(permission, containment, object);
                continue;
            }
            EObject container = request.getTargetContainer();
            Iterator containments = container.eClass().getEAllContainments().iterator();
            while (containments.hasNext() && !result.isDetermined()) {
                EReference next = (EReference)containments.next();
                if (!next.isChangeable() || !next.getEReferenceType().isInstance((Object)object)) continue;
                result = ReferenceConstraintOperations.evaluate(permission, next, object);
            }
        }
        return result;
    }

    private static PermissionResult approveRequest(ReferencePermission permission, SetRequest request) {
        PermissionResult result;
        if (!(request.getFeature() instanceof EReference)) {
            result = PermissionResult.GRANTED;
        } else {
            result = PermissionResult.NONE;
            EReference reference = (EReference)request.getFeature();
            Iterator<?> iter = ReferenceConstraintOperations.iterate(request.getValue());
            while (iter.hasNext() && !result.isDetermined()) {
                result = ReferenceConstraintOperations.evaluate(permission, reference, iter.next());
            }
        }
        return result;
    }

    protected static PermissionResult evaluate(ReferencePermission permission, EReference reference, Object value) {
        PermissionResult result = PermissionResult.NONE;
        if (permission.matches(reference)) {
            result = ReferenceConstraintOperations.evaluate(permission.getFilter(), value) ? PermissionResult.of(permission.isPermitted()) : PermissionResult.NONE;
        }
        return result;
    }
}

