/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.BooleanValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.DataTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.EnumerationValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.IntegerValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.MetaclassValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.PrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StringValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UnlimitedNaturalValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UserPrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileElementLabelProvider
extends LabelProvider {
    public static final String TAB = "    ";
    private static final String UNDEFINED = "<Undefined>";
    private static final String NULL = "null";
    private static final String EMPTY_STRING = "";
    private LabelProviderService labelProviderService;
    public static final String TAG_PROFILE_CHANGED = "    (has changed, consider re-applying profile)";

    public ProfileElementLabelProvider() {
        try {
            this.labelProviderService = new LabelProviderServiceImpl();
            this.labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void dispose() {
        try {
            this.labelProviderService.disposeService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Image getImage(Object object) {
        if (object instanceof AppliedStereotypeTreeObject) {
            return ImageManager.IMG_STEREOTYPE;
        }
        if (object instanceof AppliedStereotypePropertyTreeObject) {
            return ImageManager.IMG_PROPERTY;
        }
        if (object instanceof BooleanValueTreeObject) {
            return ImageManager.IMG_LITERALBOOLEAN;
        }
        if (object instanceof StringValueTreeObject) {
            return ImageManager.IMG_LITERALSTRING;
        }
        if (object instanceof IntegerValueTreeObject) {
            return ImageManager.IMG_LITERALINTEGER;
        }
        if (object instanceof UnlimitedNaturalValueTreeObject) {
            return ImageManager.IMG_LITERALUNLIMITEDNATURAL;
        }
        if (object instanceof UserPrimitiveTypeValueTreeObject) {
            return ImageManager.IMG_PRIMITIVETYPE;
        }
        if (object instanceof EnumerationValueTreeObject) {
            return ImageManager.IMG_ENUMERATION;
        }
        if (object instanceof DataTypeValueTreeObject) {
            return ImageManager.IMG_DATATYPE;
        }
        if (object instanceof StereotypeValueTreeObject) {
            return ImageManager.IMG_STEREOTYPEPROPERTY;
        }
        if (object instanceof MetaclassValueTreeObject) {
            return ImageManager.IMG_METACLASS;
        }
        return ImageManager.IMG_UNKNOWN;
    }

    public String getText(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof AppliedStereotypeTreeObject) {
            AppliedStereotypeTreeObject element = (AppliedStereotypeTreeObject)object;
            StereotypedElementTreeObject parent = (StereotypedElementTreeObject)element.getParent();
            Element baseElement = parent.getElement();
            Package nearestPackage = baseElement.getNearestPackage();
            Stereotype st = ((AppliedStereotypeTreeObject)object).getStereotype();
            String stName = UMLLabelInternationalization.getInstance().getKeyword(st);
            String profileName = null;
            profileName = LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)st.getProfile()) ? UMLLabelInternationalization.getInstance().getQualifiedLabel((NamedElement)st.getProfile()) : st.getProfile().getQualifiedName();
            String label = stName + "    (from " + profileName + ")";
            if (ProfileUtil.isDirty((Package)nearestPackage, (Profile)st.getProfile())) {
                label = label + TAG_PROFILE_CHANGED;
            }
            return label;
        }
        if (object instanceof AppliedStereotypePropertyTreeObject) {
            AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)object;
            Property prop = pTO.getProperty();
            Type propType = prop.getType();
            Object propValue = pTO.getValue();
            return this.getPropLabel(prop, propType, propValue);
        }
        if (object instanceof ValueTreeObject) {
            return this.getLabel((ValueTreeObject)object);
        }
        return object.toString();
    }

    protected String getPropLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String propertyShortLabel = this.getPropertyShortLabel(currentProp);
        String propertyValueLabel = this.getPropertyValueLabel(currentProp, currentPropType, currentPropValue);
        StringBuilder builder = new StringBuilder(propertyShortLabel);
        builder.append(" = ");
        builder.append(propertyValueLabel);
        return builder.toString();
    }

    protected final String getPropertyValueLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = EMPTY_STRING;
        label = currentPropValue == null ? NULL : (currentPropType instanceof Enumeration ? this.getPropEnumerationLabel(currentProp, currentPropType, currentPropValue) : (currentPropType instanceof Stereotype ? this.getPropStereotypeLabel(currentProp, currentPropType, currentPropValue) : (currentPropType instanceof Class ? this.getPropClassLabel(currentProp, currentPropType, currentPropValue) : this.getPropDefaultLabel(currentProp, currentPropValue))));
        return label;
    }

    private String getPropEnumerationLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = EMPTY_STRING;
        if (currentProp.getUpper() == 1) {
            if (currentPropValue != null) {
                label = currentPropValue instanceof EnumerationLiteral ? ((EnumerationLiteral)currentPropValue).getLabel() : currentPropValue.toString();
            }
        } else {
            label = currentPropValue.toString();
        }
        return label;
    }

    private String getPropStereotypeLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = EMPTY_STRING;
        if (currentProp.getUpper() == 1) {
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)currentPropValue));
            label = Util.getLabel(baseElement, true);
        } else {
            List values = (List)currentPropValue;
            ArrayList<String> baseElements = new ArrayList<String>();
            for (Object value : values) {
                Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
                String name = Util.getLabel(baseElement, true);
                if (name == null) continue;
                baseElements.add(name);
            }
            label = ((Object)baseElements).toString();
        }
        return label;
    }

    private String getPropClassLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = EMPTY_STRING;
        if (Util.isMetaclass(currentPropType)) {
            if (currentProp.getUpper() == 1) {
                label = Util.getLabel(currentPropValue, true);
            } else {
                List values = (List)currentPropValue;
                ArrayList<String> elementNames = new ArrayList<String>();
                if (values != null) {
                    int i = 0;
                    while (i < values.size()) {
                        elementNames.add(Util.getLabel(values.get(i), true));
                        ++i;
                    }
                }
                label = elementNames.toString();
            }
        }
        return label;
    }

    private String getPropDefaultLabel(Property currentProp, Object currentPropValue) {
        String label = EMPTY_STRING;
        if (currentPropValue != null) {
            label = this.labelProviderService.getLabelProvider().getText(currentPropValue);
        }
        return label;
    }

    protected final String getPropertyShortLabel(Property property) {
        Type type;
        String derived = EMPTY_STRING;
        if (property.isDerived()) {
            derived = "/";
        }
        String typeName = (type = property.getType()) == null ? UNDEFINED : UMLLabelInternationalization.getInstance().getLabel((NamedElement)type);
        String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
        return derived + name + ": " + typeName + " " + MultiplicityElementUtil.formatMultiplicity((MultiplicityElement)property);
    }

    private String getLabel(ValueTreeObject object) {
        if (object instanceof PrimitiveTypeValueTreeObject) {
            return this.getLabel((PrimitiveTypeValueTreeObject)object);
        }
        if (object instanceof EnumerationValueTreeObject) {
            return this.getLabel((EnumerationValueTreeObject)object);
        }
        if (object instanceof DataTypeValueTreeObject) {
            return this.getLabel((DataTypeValueTreeObject)object);
        }
        if (object instanceof StereotypeValueTreeObject) {
            return this.getLabel((StereotypeValueTreeObject)object);
        }
        if (object instanceof MetaclassValueTreeObject) {
            return this.getLabel((MetaclassValueTreeObject)object);
        }
        return object.getValue().toString();
    }

    private String getLabel(PrimitiveTypeValueTreeObject object) {
        Object value = object.getValue();
        if (value != null) {
            return value.toString();
        }
        return UNDEFINED;
    }

    private String getLabel(DataTypeValueTreeObject object) {
        Object value = object.getValue();
        if (value != null) {
            return this.labelProviderService.getLabelProvider().getText(object.getValue());
        }
        return UNDEFINED;
    }

    private String getLabel(EnumerationValueTreeObject object) {
        EnumerationValueTreeObject eTO = object;
        Property property = ((AppliedStereotypePropertyTreeObject)eTO.getParent()).getProperty();
        Object value = eTO.getValue();
        EnumerationLiteral eLiteral = null;
        if (value instanceof EnumerationLiteral) {
            eLiteral = (EnumerationLiteral)value;
        } else if (value instanceof EEnumLiteral) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)value;
            Object tmp = Util.getValueObjectFromString(eEnumLiteral.getName(), property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else if (value instanceof String) {
            String literalString = (String)value;
            Object tmp = Util.getValueObjectFromString(literalString, property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else if (value instanceof Enumerator) {
            String literalString = ((Enumerator)value).getLiteral();
            Object tmp = Util.getValueObjectFromString(literalString, property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else {
            String err = NLS.bind((String)"Value {0} of Property {1} is not an EnumerationLiteral.", (Object)(value != null ? value.toString() : NULL), (Object)property.getName());
            Message.error(err);
        }
        if (eLiteral != null) {
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)eLiteral);
        }
        return UNDEFINED;
    }

    private String getLabel(StereotypeValueTreeObject object) {
        StereotypeValueTreeObject sTO = object;
        Property property = ((AppliedStereotypePropertyTreeObject)sTO.getParent()).getProperty();
        Object value = sTO.getValue();
        Element baseElement = null;
        if (value instanceof EObject) {
            baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
        } else {
            String err = NLS.bind((String)"Value {0} of Property {1} is not an EObject.", (Object)(value != null ? value.toString() : NULL), (Object)property.getName());
            Message.error(err);
        }
        if (baseElement != null) {
            NamedElement baseNamedElement;
            String label = baseElement.toString();
            if (baseElement instanceof ValueSpecification) {
                return Util.getOriginLabel((ValueSpecification)baseElement);
            }
            if (baseElement instanceof NamedElement && (baseNamedElement = (NamedElement)baseElement).isSetName()) {
                label = baseNamedElement.getQualifiedName();
            }
            return label;
        }
        return UNDEFINED;
    }

    private String getLabel(MetaclassValueTreeObject object) {
        MetaclassValueTreeObject sTO = object;
        Object value = sTO.getValue();
        if (value instanceof ValueSpecification) {
            return Util.getOriginLabel((ValueSpecification)value);
        }
        if (value instanceof Element) {
            return Util.getLabel(value, false);
        }
        return UNDEFINED;
    }
}

