/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.AbstractGraphicalNodeCreationChecker;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.junit.Assert;

public abstract class AbstractDNodeContainerCreationChecker
extends AbstractGraphicalNodeCreationChecker {
    public AbstractDNodeContainerCreationChecker(Diagram diagram, EObject graphicalParent) {
        super(diagram, graphicalParent);
    }

    @Override
    protected void checkCreatedElementInstanceOf(DRepresentationElement createdElementRepresentation) {
        Assert.assertTrue((String)NLS.bind((String)"The created element must be a DNodeContainer instead of a {0}.", (Object)createdElementRepresentation.eClass().getName()), (boolean)(createdElementRepresentation instanceof DNodeContainer));
    }

    @Override
    protected void checkCreatedElementMapping(DRepresentationElement createdElementRepresentation) {
        super.checkCreatedElementMapping(createdElementRepresentation);
        DNodeContainer nodeContainer = (DNodeContainer)createdElementRepresentation;
        List<String> compartments = this.getNodeCompartmentTypes();
        List<String> borderNodes = this.getSynchronizedBorderNodes();
        Assert.assertEquals((String)"The created DNodeContainer doesn't have the expected number of compartment types", (long)compartments.size(), (long)nodeContainer.getOwnedDiagramElements().size());
        Assert.assertEquals((String)"The created DNodeContainer doesn't have the expected number of synchronized bordered nodes", (long)borderNodes.size(), (long)nodeContainer.getOwnedBorderedNodes().size());
        int i = 0;
        while (i < compartments.size()) {
            String compartmentMappingType = compartments.get(i);
            DDiagramElement subElement = (DDiagramElement)nodeContainer.getOwnedDiagramElements().get(i);
            Assert.assertEquals((String)"The mapping type of compartment is not the expected one", (Object)compartmentMappingType, (Object)subElement.getMapping().getName());
            ++i;
        }
        i = 0;
        while (i < borderNodes.size()) {
            DDiagramElement subElement = (DDiagramElement)nodeContainer.getOwnedBorderedNodes().get(i);
            Assert.assertTrue((String)"The mapping type of border node is not the expected one", (boolean)borderNodes.contains(subElement.getMapping().getName()));
            ++i;
        }
    }

    @Override
    public int getNumberOfExpectedCreatedElement() {
        Integer nbSynchronizedBorderNodes = Optional.ofNullable(this.getSynchronizedBorderNodes()).map(List::size).orElse(0);
        Integer nbNodeCompartmentTypes = Optional.ofNullable(this.getNodeCompartmentTypes()).map(List::size).orElse(0);
        return super.getNumberOfExpectedCreatedElement() + nbNodeCompartmentTypes + nbSynchronizedBorderNodes;
    }

    protected abstract List<String> getNodeCompartmentTypes();

    protected abstract List<String> getSynchronizedBorderNodes();
}

