/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ConstraintsPackage;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.constraints.util.ConstraintsUtil;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ComposedSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.NameKind;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SourceTraceHelper;

public class ConstraintsCustomValidator
extends CustomModelChecker.SwitchValidator {
    private final SourceTraceHelper traceHelper = new ComposedSourceTraceHelper();

    public ConstraintsCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(ConstraintDescriptor constraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObject sourceClass;
        if (this.traceHelper.isInstanceOfConstraint(constraint) && ((sourceClass = this.traceHelper.resolveInstanceOfConstraintClass(constraint)) == null || sourceClass.eIsProxy())) {
            ValueProperty constraintProperty;
            EObject container = constraint.eContainer();
            EObject containerSource = this.traceHelper.getSourceElement(container);
            Collection<? extends EObject> constraintSourceClasses = this.traceHelper.getValidConstraintSourceClasses(constraint, containerSource);
            String actualClassName = this.traceHelper.getClassName(constraint);
            String expectedClassName = constraintSourceClasses.stream().map(c -> this.traceHelper.getName((EObject)c, NameKind.CONSTRAINT)).distinct().collect(Collectors.joining(","));
            ValueProperty valueProperty = constraintProperty = Strings.isNullOrEmpty((String)expectedClassName) ? null : this.traceHelper.getClassNameProperty(constraint);
            if (constraintProperty != null) {
                int problemID = constraintSourceClasses.size() > 1 ? 16715855 : 16715854;
                ConstraintType type = ((SimpleConstraint)constraint).getConstraintType();
                String message = this.format(Messages.ConstraintsCustomValidator_0, context, new Object[]{ConstraintsUtil.getLabel((EObject)constraint), actualClassName, ConstraintsUtil.getLabel((EObject)constraintProperty), ConstraintsUtil.getLabel((EObject)type)});
                diagnostics.add(this.createDiagnostic(4, (EObject)constraintProperty, (EStructuralFeature)ConstraintsPackage.Literals.VALUE_PROPERTY__VALUE, message, IPluginChecker2.problem((int)problemID), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(expectedClassName, EcorePackage.Literals.ESTRING)}));
            } else {
                diagnostics.add(this.createDiagnostic(4, (EObject)constraint, this.format(Messages.ConstraintsCustomValidator_1, context, new Object[]{constraint, actualClassName})));
            }
        }
    }
}

