/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DeleteServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.ViewpointHelpers;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramObservationServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder.SequenceDiagramReorderElementSwitch;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder.SequenceDiagramSemanticReorderHelper;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.sirius.diagram.sequence.description.ObservationPointMapping;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.OrderingFactory;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;

public class SequenceDiagramServices
extends AbstractDiagramServices {
    private static final UMLPackage UML = UMLPackage.eINSTANCE;
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final ElementDefaultNameProvider nameProvider = new ElementDefaultNameProvider();
    private final DeleteServices deleteServices = new DeleteServices();
    private final SequenceDiagramSemanticReorderHelper reorderHelper = new SequenceDiagramSemanticReorderHelper();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();
    private final DomainBasedEdgeServices edgeService = new DomainBasedEdgeServices();

    public Lifeline createLifeline(Interaction parent, DSemanticDecorator parentView, Lifeline predecessor) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        Lifeline result = (Lifeline)commonDiagramServices.createElement((Element)parent, UML.getLifeline().getName(), UML.getInteraction_Lifeline().getName(), parentView);
        this.reorderHelper.reorderLifeline(result, predecessor);
        return result;
    }

    public boolean canCreateSD(EObject container, EClass objectToCreate, String containmentReferenceName) {
        return super.canCreate(container, objectToCreate, containmentReferenceName);
    }

    /*
     * WARNING - void declaration
     */
    public boolean canCreateMessageSD(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        EObject realSource = source;
        EObject realTarget = target;
        boolean allowedEnd = true;
        EObject eObject = target;
        if (eObject instanceof EAnnotation) {
            void end;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EAnnotation cfr_ignored_0 = (EAnnotation)eObject;
            realTarget = this.orderService.getEndOwner((EAnnotation)end);
            allowedEnd = this.isStartingEndExecution((EAnnotation)end);
        } else {
            EObject eObject2 = source;
            if (eObject2 instanceof EAnnotation) {
                void end;
                EAnnotation eAnnotation = (EAnnotation)eObject2;
                EAnnotation cfr_ignored_1 = (EAnnotation)eObject2;
                realSource = this.orderService.getEndOwner((EAnnotation)end);
                allowedEnd = this.isFinishingEndExecution((EAnnotation)end);
            }
        }
        return allowedEnd && this.edgeService.canCreateDomainBasedEdge(realSource, realTarget, Message.class.getSimpleName(), UML.getInteraction_Message().getName(), sourceView, targetView);
    }

    public Message initializeMessage(Message message, MessageSort type, NamedElement source, NamedElement target, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        this.setDefaultName((NamedElement)message);
        message.setMessageSort(type);
        if (source != null) {
            this.initializeMessageEvent(message, UML.getMessage_SendEvent(), source);
            this.orderService.createStartingEnd((NamedElement)message);
        }
        if (target != null) {
            this.initializeMessageEvent(message, UML.getMessage_ReceiveEvent(), target);
            this.orderService.createFinishingEnd((NamedElement)message);
        }
        return this.updateElementOrderWithEvents(message, startingEndPredecessor, finishingEndPredecessor);
    }

    public Message initializeMessageToExecutionStart(Message message, MessageSort type, NamedElement source, EAnnotation executionEndTarget) {
        ExecutionSpecification executionTarget = (ExecutionSpecification)this.orderService.getEndOwner(executionEndTarget);
        return this.initializeMessageOnExecution(message, type, source, (NamedElement)executionTarget, executionEndTarget, UML.getExecutionSpecification_Start(), UML.getMessage_ReceiveEvent());
    }

    public Message initializeMessageFromExecutionFinish(Message message, MessageSort type, NamedElement target, EAnnotation executionEndSource) {
        ExecutionSpecification executionSource = (ExecutionSpecification)this.orderService.getEndOwner(executionEndSource);
        return this.initializeMessageOnExecution(message, type, (NamedElement)executionSource, target, executionEndSource, UML.getExecutionSpecification_Finish(), UML.getMessage_SendEvent());
    }

    private Message initializeMessageOnExecution(Message message, MessageSort type, NamedElement source, NamedElement target, EAnnotation executionEnd, EReference executionReference, EReference messageReference) {
        EventEnd executionEvent = this.toEventEnd(executionEnd);
        ExecutionSpecification execution = (ExecutionSpecification)this.orderService.getEndOwner(executionEnd);
        this.initializeMessage(message, type, source, target, executionEvent, executionEvent);
        OccurrenceSpecification executionFragment = (OccurrenceSpecification)this.orderService.getEndFragment(executionEnd);
        MessageOccurrenceSpecification messageFragment = (MessageOccurrenceSpecification)message.eGet((EStructuralFeature)messageReference);
        SequenceDiagramObservationServices.replaceFragmentReferences(executionFragment, (OccurrenceSpecification)messageFragment);
        execution.eSet((EStructuralFeature)executionReference, (Object)messageFragment);
        this.deleteServices.delete((EObject)executionFragment);
        this.orderService.removeEnd(executionEnd);
        return message;
    }

    public Message initializeSyncCall(Message invocation, ExecutionSpecification exec, Message reply, NamedElement source, NamedElement target, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        this.initializeMessage(invocation, MessageSort.SYNCH_CALL_LITERAL, source, target, startingEndPredecessor, finishingEndPredecessor);
        EventEnd invocationFinish = this.toEventEnd(this.orderService.getFinishingEnd((Element)invocation));
        this.initializeMessage(reply, MessageSort.REPLY_LITERAL, target, source, invocationFinish, invocationFinish);
        this.initializeExecutionContent(exec, target);
        exec.setStart((OccurrenceSpecification)((MessageOccurrenceSpecification)invocation.getReceiveEvent()));
        exec.setFinish((OccurrenceSpecification)((MessageOccurrenceSpecification)reply.getSendEvent()));
        EventEnd invocationStart = this.toEventEnd(this.orderService.getStartingEnd((Element)invocation));
        this.updateElementOrderWithEvents(exec, invocationStart, invocationStart);
        return invocation;
    }

    private EventEnd toEventEnd(EAnnotation end) {
        SingleEventEnd result = OrderingFactory.eINSTANCE.createSingleEventEnd();
        result.setSemanticEnd((EObject)end);
        result.setStart(false);
        return result;
    }

    private MessageOccurrenceSpecification initializeMessageEvent(Message message, EReference eventReference, NamedElement eventTarget) {
        Object result = MessageSort.DELETE_MESSAGE_LITERAL.equals((Object)message.getMessageSort()) && UML.getMessage_ReceiveEvent() == eventReference ? UML.getUMLFactory().createDestructionOccurrenceSpecification() : UML.getUMLFactory().createMessageOccurrenceSpecification();
        message.getInteraction().getFragments().add(result);
        result.setName(message.getName() + eventReference.getName());
        result.setMessage(message);
        message.eSet((EStructuralFeature)eventReference, result);
        result.setCovered(this.umlHelper.getCoveredLifeline(eventTarget));
        return result;
    }

    public boolean isDestroyed(Lifeline lifeline) {
        return lifeline.getCoveredBys().stream().anyMatch(DestructionOccurrenceSpecification.class::isInstance);
    }

    public boolean isStartingEndExecution(EAnnotation end) {
        return this.orderService.getEndOwner(end) instanceof ExecutionSpecification && this.orderService.isStartingEnd(end);
    }

    public boolean isFinishingEndExecution(EAnnotation end) {
        return this.orderService.getEndOwner(end) instanceof ExecutionSpecification && this.orderService.isFinishingEnd(end);
    }

    public ExecutionSpecification initializeExecutionSpecification(ExecutionSpecification execution, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, NamedElement parent) {
        this.initializeExecutionContent(execution, parent);
        this.initializeExecutionEvent(execution, UML.getExecutionSpecification_Start());
        this.initializeExecutionEvent(execution, UML.getExecutionSpecification_Finish());
        this.orderService.createStartingEnd((NamedElement)execution);
        this.orderService.createFinishingEnd((NamedElement)execution);
        this.updateElementOrderWithEvents(execution, startingEndPredecessor, finishingEndPredecessor);
        return execution;
    }

    private ExecutionSpecification initializeExecutionContent(ExecutionSpecification execution, NamedElement parent) {
        this.setDefaultName((NamedElement)execution);
        execution.getCovereds().add((Object)this.umlHelper.getCoveredLifeline(parent));
        return execution;
    }

    private ExecutionOccurrenceSpecification initializeExecutionEvent(ExecutionSpecification execution, EReference eventReference) {
        ExecutionOccurrenceSpecification result = UML.getUMLFactory().createExecutionOccurrenceSpecification();
        execution.getEnclosingInteraction().getFragments().add((Object)result);
        result.setName(execution.getName() + eventReference.getName());
        result.setExecution(execution);
        execution.eSet((EStructuralFeature)eventReference, (Object)result);
        Lifeline owner = (Lifeline)execution.getCovereds().get(0);
        result.getCovereds().add((Object)owner);
        return result;
    }

    public InteractionUse initializeInteractionUse(InteractionUse interactionUse, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<Lifeline> coveredLifelines) {
        this.setDefaultName((NamedElement)interactionUse);
        interactionUse.getCovereds().addAll(coveredLifelines);
        this.orderService.createStartingEnd((NamedElement)interactionUse);
        this.orderService.createFinishingEnd((NamedElement)interactionUse);
        return this.updateElementOrderWithEvents(interactionUse, startingEndPredecessor, finishingEndPredecessor);
    }

    public CombinedFragment initializeCombinedFragment(CombinedFragment combinedFragment, InteractionOperand operand, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<Lifeline> coveredLifelines) {
        this.setDefaultName((NamedElement)combinedFragment);
        this.orderService.createStartingEnd((NamedElement)combinedFragment);
        combinedFragment.getCovereds().addAll(coveredLifelines);
        this.initializeOperandContent(operand, combinedFragment);
        this.orderService.createFinishingEnd((NamedElement)combinedFragment);
        return this.updateElementOrderWithEvents(combinedFragment, startingEndPredecessor, finishingEndPredecessor);
    }

    public InteractionOperand initializeInteractionOperand(InteractionOperand operand, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, CombinedFragment parent) {
        this.initializeOperandContent(operand, parent);
        return this.updateElementOrderWithEvents(operand, startingEndPredecessor, finishingEndPredecessor);
    }

    private InteractionOperand initializeOperandContent(InteractionOperand operand, CombinedFragment parent) {
        this.setDefaultName((NamedElement)operand);
        operand.createGuard("guard");
        operand.getCovereds().addAll((Collection)parent.getCovereds());
        this.orderService.createStartingEnd((NamedElement)operand);
        return operand;
    }

    public StateInvariant initializeStateInvariant(StateInvariant stateInvariant, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, NamedElement parent) {
        this.setDefaultName((NamedElement)stateInvariant);
        stateInvariant.getCovereds().add((Object)this.umlHelper.getCoveredLifeline(parent));
        this.orderService.createStartingEnd((NamedElement)stateInvariant);
        this.orderService.createFinishingEnd((NamedElement)stateInvariant);
        this.updateElementOrderWithEvents(stateInvariant, startingEndPredecessor, finishingEndPredecessor);
        return stateInvariant;
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteSD(EObject element, DSemanticDecorator elementView) {
        EObject elementToDelete = element;
        EObject eObject = element;
        if (eObject instanceof EAnnotation) {
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EAnnotation cfr_ignored_0 = (EAnnotation)eObject;
            elementToDelete = null;
            if (ViewpointHelpers.isMapping(elementView, ObservationPointMapping.class, "SD_TimeElement")) {
                void end;
                elementToDelete = SequenceDiagramUMLHelper.getTimeElementFromEnd((EAnnotation)end).orElse(null);
            }
        }
        boolean result = false;
        if (elementToDelete != null) {
            result = this.deleteServices.delete(elementToDelete);
        }
        return result;
    }

    public <T extends Element> T updateElementOrderWithEvents(T element, EventEnd startPreviousEnd, EventEnd finishPreviousEnd) {
        EAnnotation startPrevious = this.getSemanticEnd(startPreviousEnd);
        EAnnotation finishPrevious = this.getSemanticEnd(finishPreviousEnd);
        new SequenceDiagramReorderElementSwitch(startPrevious, finishPrevious).doSwitch((EObject)element);
        return element;
    }

    public void updateLifelineOrder(Interaction container, Lifeline lifeline, Lifeline predecessor) {
        this.reorderHelper.reorderLifeline(lifeline, predecessor);
    }

    public Interaction getOwningInteraction(Element element) {
        return this.umlHelper.getOwningInteraction(element);
    }

    /*
     * WARNING - void declaration
     */
    private EAnnotation getSemanticEnd(EventEnd eventEnd) {
        EObject eObject;
        if (eventEnd != null && (eObject = eventEnd.getSemanticEnd()) instanceof EAnnotation) {
            void result;
            EAnnotation eAnnotation = (EAnnotation)eObject;
            EAnnotation cfr_ignored_0 = (EAnnotation)eObject;
            return result;
        }
        return null;
    }

    public Element getMessageSendContext(Message element) {
        return this.getMessageEndContext(element, element.getSendEvent());
    }

    public Element getMessageReceiveContext(Message element) {
        return this.getMessageEndContext(element, element.getReceiveEvent());
    }

    /*
     * WARNING - void declaration
     */
    private Element getMessageEndContext(Message element, MessageEnd end) {
        MessageEnd messageEnd = end;
        if (messageEnd instanceof InteractionFragment) {
            void event;
            InteractionFragment interactionFragment = (InteractionFragment)messageEnd;
            InteractionFragment cfr_ignored_0 = (InteractionFragment)messageEnd;
            return this.orderService.findIncludingFragment((InteractionFragment)event);
        }
        return element;
    }

    private void setDefaultName(NamedElement element) {
        String name = this.nameProvider.getDefaultName(element, (EObject)element.getOwner());
        element.setName(name);
    }
}

