/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.strategy;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.Annotation;
import org.eclipse.papyrus.infra.types.ConfigurationElement;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeMatcherAdviceConfiguration;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ElementTypeConfigHelper {
    public static final String GENERATOR_ANNOTATION_SOURCE = "org.eclipse.papyrus.uml.profile.types.generator.source";
    private final UML uml = new UML();

    public String getStereotypeName(ElementTypeConfiguration config) {
        if (config instanceof SpecializationTypeConfiguration) {
            List<AbstractAdviceBindingConfiguration> relatedAdvices = this.getRelatedAdvices(config);
            String name = null;
            for (AbstractAdviceBindingConfiguration advice : relatedAdvices) {
                String stereotypeName;
                if (advice instanceof ApplyStereotypeAdviceConfiguration) {
                    stereotypeName = this.getStereotypeName((ApplyStereotypeAdviceConfiguration)advice);
                } else {
                    if (!(advice instanceof StereotypeMatcherAdviceConfiguration)) continue;
                    stereotypeName = this.getStereotypeName((StereotypeMatcherAdviceConfiguration)advice);
                }
                if (stereotypeName != null && name != null) {
                    return null;
                }
                name = stereotypeName;
            }
            return name;
        }
        return null;
    }

    public List<AbstractAdviceBindingConfiguration> getRelatedAdvices(ElementTypeConfiguration typeConfig) {
        List<AbstractAdviceBindingConfiguration> relatedAdvices = Stream.concat(typeConfig.getOwnedAdvice().stream(), typeConfig.getOwningSet().getAdviceBindingsConfigurations().stream().filter(advice -> advice.getTarget() == typeConfig)).collect(Collectors.toList());
        return relatedAdvices;
    }

    public String getStereotypeName(ApplyStereotypeAdviceConfiguration advice) {
        if (advice.getStereotypesToApply().size() == 1) {
            return ((StereotypeToApply)advice.getStereotypesToApply().get(0)).getStereotypeQualifiedName();
        }
        return null;
    }

    public String getStereotypeName(StereotypeMatcherAdviceConfiguration advice) {
        if (advice.getStereotypesQualifiedNames().size() == 1) {
            return (String)advice.getStereotypesQualifiedNames().get(0);
        }
        return null;
    }

    public Optional<Boolean> exists(ElementTypeConfiguration config, Profile currentProfile) {
        String stereoQName = this.getStereotypeName(config);
        URI stereoURI = this.getStereotypeURI(config);
        if (stereoURI != null && currentProfile.eResource().getResourceSet().getEObject(stereoURI, false) != null) {
            return Optional.of(Boolean.TRUE);
        }
        if (stereoQName != null) {
            return Optional.of(StreamSupport.stream(this.uml.getAllStereotypes((Package)currentProfile).spliterator(), false).anyMatch(s -> stereoQName.equals(s.getQualifiedName())));
        }
        return Optional.empty();
    }

    private URI getStereotypeURI(ElementTypeConfiguration config) {
        String source = this.getSource((ConfigurationElement)config);
        if (source == null || source.isEmpty()) {
            return null;
        }
        try {
            URI uri = URI.createURI((String)source);
            return uri;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean exists(Stereotype stereotype, ElementTypeSetConfiguration previousTypes) {
        String stereoQName = stereotype.getQualifiedName();
        URI stereotypeURI = EcoreUtil.getURI((EObject)stereotype);
        boolean anyMatch = previousTypes.getElementTypeConfigurations().stream().anyMatch(config -> stereoQName.equals(this.getStereotypeName((ElementTypeConfiguration)config)) || stereotypeURI.equals(this.getStereotypeURI((ElementTypeConfiguration)config)));
        return anyMatch;
    }

    public Stereotype getCurrentStereotypeByURI(ElementTypeConfiguration config, Profile currentProfile) {
        URI sourceURI = this.getStereotypeURI(config);
        if (sourceURI == null) {
            return null;
        }
        EObject eObject = currentProfile.eResource().getResourceSet().getEObject(sourceURI, false);
        if (eObject instanceof Stereotype) {
            return (Stereotype)eObject;
        }
        return null;
    }

    public Stereotype getCurrentStereotype(ElementTypeConfiguration config, Profile currentProfile) {
        Stereotype stereotype = this.getCurrentStereotypeByURI(config, currentProfile);
        if (stereotype != null) {
            return stereotype;
        }
        String stereoQName = this.getStereotypeName(config);
        if (stereoQName == null) {
            return null;
        }
        return StreamSupport.stream(this.uml.getAllStereotypes((Package)currentProfile).spliterator(), false).filter(st -> stereoQName.equals(st.getQualifiedName())).findFirst().orElse(null);
    }

    public ImpliedExtension getExtension(ElementTypeConfiguration config, Profile currentProfile) {
        Stereotype stereotype = this.getCurrentStereotype(config, currentProfile);
        return stereotype == null ? null : this.getExtension(config, stereotype);
    }

    public boolean exists(ImpliedExtension extension, Iterable<ImpliedExtension> allExtensions) {
        return StreamSupport.stream(allExtensions.spliterator(), false).anyMatch(e -> e.equals(extension));
    }

    public ImpliedExtension getExtension(ElementTypeConfiguration typeConfig, Stereotype stereotype) {
        EClass metaclass;
        SpecializationTypeConfiguration type;
        MetamodelTypeConfiguration baseType;
        if (stereotype == null || typeConfig == null) {
            return null;
        }
        if (typeConfig instanceof SpecializationTypeConfiguration && (baseType = this.getMetamodelType(type = (SpecializationTypeConfiguration)typeConfig)) != null && (metaclass = baseType.getEClass()) != null) {
            Package uml2Metamodel = ElementUtil.contentload((URI)URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), (Element)stereotype);
            PackageableElement baseClass = uml2Metamodel.getPackagedElement(metaclass.getName());
            return baseClass instanceof Class ? new ImpliedExtension(stereotype, (Class)baseClass) : null;
        }
        return null;
    }

    private MetamodelTypeConfiguration getMetamodelType(SpecializationTypeConfiguration specialType) {
        EList specializedTypes = specialType.getSpecializedTypes();
        if (specializedTypes.size() != 1) {
            return null;
        }
        ElementTypeConfiguration superType = (ElementTypeConfiguration)specializedTypes.get(0);
        if (superType instanceof MetamodelTypeConfiguration) {
            return (MetamodelTypeConfiguration)superType;
        }
        if (superType instanceof SpecializationTypeConfiguration) {
            return this.getMetamodelType((SpecializationTypeConfiguration)superType);
        }
        return null;
    }

    public boolean exists(ImpliedExtension extension, ElementTypeSetConfiguration previousTypes) {
        for (ElementTypeConfiguration config : previousTypes.getElementTypeConfigurations()) {
            ImpliedExtension ext = this.getExtension(config, extension.getStereotype().getProfile());
            if (!extension.equals(ext)) continue;
            return true;
        }
        return false;
    }

    public String getSource(ConfigurationElement configElement) {
        return configElement.getAnnotations().stream().filter(a -> GENERATOR_ANNOTATION_SOURCE.equals(a.getSource())).findFirst().map(Annotation::getValue).orElse(null);
    }

    public void setSource(ConfigurationElement configElement, String source) {
        Optional<Annotation> annotation = configElement.getAnnotations().stream().filter(a -> GENERATOR_ANNOTATION_SOURCE.equals(a.getSource())).findFirst();
        if (source == null) {
            annotation.ifPresent(EcoreUtil::delete);
        } else {
            if (!annotation.isPresent()) {
                Annotation newAnnotation = ElementTypesConfigurationsFactory.eINSTANCE.createAnnotation();
                configElement.getAnnotations().add((Object)newAnnotation);
                newAnnotation.setSource(GENERATOR_ANNOTATION_SOURCE);
                annotation = Optional.of(newAnnotation);
            }
            annotation.get().setValue(source);
        }
    }
}

