/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.celleditor.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.emf.nattable.dataprovider.EEnumComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;

public class SingleEEnumTypeCellEditorConfiguration
implements ICellAxisConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.celleditor.configuration.SingleEEnumTypeCellEditorConfiguration.ComboBox";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a ComboBox editor for a single EEnum type";
    }

    public boolean handles(Table table, Object axisElement) {
        EStructuralFeature feature;
        Object representedElement = AxisUtils.getRepresentedElement((Object)axisElement);
        if (representedElement instanceof EStructuralFeature && !(feature = (EStructuralFeature)representedElement).isMany()) {
            EClassifier eType = feature.getEType();
            return eType instanceof EEnum;
        }
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        Object representedElement = AxisUtils.getRepresentedElement((Object)axis);
        EEnum eenum = (EEnum)((EStructuralFeature)representedElement).getEType();
        DisplayConverter displayConverter = new DisplayConverter(){

            public Object displayToCanonicalValue(Object displayValue) {
                return null;
            }

            public Object canonicalToDisplayValue(Object canonicalValue) {
                return new EMFLabelProvider().getText(canonicalValue);
            }
        };
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor((IComboBoxDataProvider)new EEnumComboBoxDataProvider(eenum)), DisplayMode.EDIT, configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)displayConverter, DisplayMode.EDIT, configLabel);
    }
}

