/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.provider;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFEObjectHeaderLabelProvider;
import org.eclipse.papyrus.infra.emf.nattable.registry.EOperationImageRegistry;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.OperationLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public class EMFEOperationHeaderLabelProvider
extends EMFEObjectHeaderLabelProvider {
    @Override
    public boolean accept(Object element) {
        if (element instanceof ILabelProviderContextElementWrapper) {
            Object object = ((ILabelProviderContextElementWrapper)element).getObject();
            return object instanceof EOperation || object instanceof EOperationAxis;
        }
        return false;
    }

    protected String getText(FeatureLabelProviderConfiguration featureConf, IConfigRegistry configRegistry, String name, Object type, int lowerBound, int upperBounds) {
        boolean displayName = false;
        try {
            displayName = featureConf.isDisplayName();
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        boolean displayMultiplicity = featureConf.isDisplayMultiplicity();
        boolean displayType = featureConf.isDisplayType();
        Object displayedText = "";
        if (displayName) {
            displayedText = (String)displayedText + name;
        }
        if (displayType) {
            if (displayName) {
                displayedText = (String)displayedText + " : ";
            }
            displayedText = (String)displayedText + this.getTypeName(configRegistry, type);
        }
        if (displayMultiplicity) {
            displayedText = (String)displayedText + " [";
            if (upperBounds == -1 && lowerBound <= 1) {
                displayedText = (String)displayedText + "*";
            } else if (lowerBound == upperBounds) {
                displayedText = (String)displayedText + Integer.toString(lowerBound);
            } else {
                displayedText = (String)displayedText + Integer.toString(lowerBound);
                displayedText = (String)displayedText + "..";
                displayedText = upperBounds == -1 ? (String)displayedText + "*" : (String)displayedText + Integer.toString(upperBounds);
            }
            displayedText = (String)displayedText + "]";
        }
        return displayedText;
    }

    protected String getText(OperationLabelProviderConfiguration featureConf, IConfigRegistry configRegistry, String name, Object type, int lowerBound, int upperBounds) {
        boolean displayName = false;
        try {
            displayName = featureConf.isDisplayName();
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        boolean displayMultiplicity = featureConf.isDisplayMultiplicity();
        boolean displayType = featureConf.isDisplayType();
        Object displayedText = "";
        if (displayName) {
            displayedText = (String)displayedText + name;
        }
        if (displayType) {
            if (displayName) {
                displayedText = (String)displayedText + " : ";
            }
            displayedText = (String)displayedText + this.getTypeName(configRegistry, type);
        }
        if (displayMultiplicity) {
            displayedText = (String)displayedText + " [";
            if (upperBounds == -1 && lowerBound <= 1) {
                displayedText = (String)displayedText + "*";
            } else if (lowerBound == upperBounds) {
                displayedText = (String)displayedText + Integer.toString(lowerBound);
            } else {
                displayedText = (String)displayedText + Integer.toString(lowerBound);
                displayedText = (String)displayedText + "..";
                displayedText = upperBounds == -1 ? (String)displayedText + "*" : (String)displayedText + Integer.toString(upperBounds);
            }
            displayedText = (String)displayedText + "]";
        }
        return displayedText;
    }

    protected String getTypeName(IConfigRegistry configRegistry, Object type) {
        LabelProviderService serv = this.getLabelProviderService(configRegistry);
        if (type instanceof EClassifier) {
            return ((EClassifier)type).getName();
        }
        return serv.getLabelProvider(type).getText(type);
    }

    @Override
    public String getText(Object element) {
        ILabelProviderContextElementWrapper wrapper = (ILabelProviderContextElementWrapper)element;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        Object value = this.getWrappedValue(wrapper);
        EOperation operation = null;
        String alias = "";
        if (value instanceof EOperationAxis) {
            operation = ((EOperationAxis)value).getElement();
            alias = ((EOperationAxis)value).getAlias();
        } else if (value instanceof EOperation) {
            operation = (EOperation)value;
        }
        String returnedValue = null;
        if (alias != null && !alias.isEmpty()) {
            returnedValue = alias;
        } else {
            StringBuilder returnedValueBuilder = new StringBuilder(operation.getName());
            if (!operation.getEParameters().isEmpty()) {
                returnedValueBuilder.append("(");
                Iterator parameters = operation.getEParameters().iterator();
                while (parameters.hasNext()) {
                    EParameter parameter = (EParameter)parameters.next();
                    returnedValueBuilder.append(parameter.getEType().getName());
                    returnedValueBuilder.append(" ");
                    returnedValueBuilder.append(parameter.getName());
                    if (!parameters.hasNext()) continue;
                    returnedValueBuilder.append(", ");
                }
                returnedValueBuilder.append(")");
            } else {
                returnedValueBuilder.append("()");
            }
            returnedValue = returnedValueBuilder.toString();
        }
        ILabelProviderConfiguration conf = null;
        if (wrapper instanceof LabelProviderCellContextElementWrapper) {
            conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)((LabelProviderCellContextElementWrapper)wrapper));
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayLabel()) {
            returnedValue = "";
        } else if (conf instanceof OperationLabelProviderConfiguration) {
            returnedValue = this.getText((OperationLabelProviderConfiguration)conf, configRegistry, returnedValue, (Object)operation.getEType(), operation.getLowerBound(), operation.getUpperBound());
        } else if (conf instanceof FeatureLabelProviderConfiguration) {
            returnedValue = this.getText((FeatureLabelProviderConfiguration)conf, configRegistry, returnedValue, (Object)operation.getEType(), operation.getLowerBound(), operation.getUpperBound());
        }
        return returnedValue;
    }

    @Override
    public Image getImage(Object element) {
        Image result = null;
        ILabelProviderConfiguration conf = null;
        if (element instanceof LabelProviderCellContextElementWrapper) {
            conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)((LabelProviderCellContextElementWrapper)element));
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayIcon()) {
            return null;
        }
        Object object = this.getWrappedValue((ILabelProviderContextElementWrapper)element);
        EOperation operation = null;
        if (object instanceof EOperationAxis) {
            operation = ((EOperationAxis)object).getElement();
        } else if (object instanceof EOperation) {
            operation = (EOperation)object;
        }
        if (operation != null) {
            result = EOperationImageRegistry.getOperationIcon();
        }
        return result;
    }

    protected Object getWrappedValue(ILabelProviderContextElementWrapper wrapper) {
        return wrapper.getObject();
    }
}

