/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EObjectStructuredValueFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ILabeledModelElement;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableList;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.databinding.StereotypePropertyObservableList;
import org.eclipse.papyrus.uml.properties.databinding.StereotypePropertyObservableValue;
import org.eclipse.papyrus.uml.properties.datatype.DataTypeProvider;
import org.eclipse.papyrus.uml.properties.datatype.StructuredDataTypeObservableValue;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.utils.DataTypeUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeModelElement
extends EMFModelElement
implements ILabeledModelElement {
    protected Stereotype stereotype;

    public StereotypeModelElement(EObject stereotypeApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereotypeApplication, domain);
        this.stereotype = stereotype;
    }

    public IObservable doGetObservable(String propertyPath) {
        Iterator stereoIter;
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        if (feature == null) {
            return super.doGetObservable(propertyPath);
        }
        if (feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum) && feature.getUpperBound() == 1 && DataTypeProvider.instance.canHandle((EDataType)feature.getEType())) {
            return new StructuredDataTypeObservableValue(this.source, feature, this.domain, (EDataType)feature.getEType());
        }
        if (feature.getEType() instanceof EClass && DataTypeUtil.isDataTypeDefinition((EClass)((EClass)feature.getEType()), (EObject)this.getSource(featurePath))) {
            if (feature.getUpperBound() != 1) {
                List wrappedList = (List)this.source.eGet(feature);
                return new PapyrusObservableList(wrappedList, this.domain, this.source, feature, GMFtoEMFCommandWrapper::wrap);
            }
            return new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain, GMFtoEMFCommandWrapper::wrap);
        }
        Element baseElement = UMLUtil.getBaseElement((EObject)this.source);
        Stereotype useStereotype = this.stereotype;
        if (baseElement.getStereotypeApplication(this.stereotype) == null && (stereoIter = baseElement.getAppliedSubstereotypes(this.stereotype).iterator()).hasNext()) {
            useStereotype = (Stereotype)stereoIter.next();
        }
        if (feature.getUpperBound() != 1) {
            List wrappedList = (List)this.source.eGet(feature);
            return new StereotypePropertyObservableList(wrappedList, this.domain, (EObject)baseElement, feature, useStereotype);
        }
        return new StereotypePropertyObservableValue((EObject)baseElement, feature, this.domain, useStereotype);
    }

    public FeaturePath getFeaturePath(String propertyPath) {
        String[] featureNames = propertyPath.split("\\.");
        EStructuralFeature[] features = new EStructuralFeature[featureNames.length];
        int i = 0;
        EClass currentClass = this.source.eClass();
        String[] stringArray = featureNames;
        int n = featureNames.length;
        int n2 = 0;
        while (n2 < n) {
            String featureName = stringArray[n2];
            featureName = UML2Util.getValidJavaIdentifier((String)featureName);
            EStructuralFeature feature = currentClass.getEStructuralFeature(featureName);
            features[i++] = feature;
            if (i < featureNames.length) {
                EReference reference;
                EClassifier type;
                if (feature instanceof EReference && (type = (reference = (EReference)feature).getEType()) instanceof EClass) {
                    currentClass = (EClass)type;
                } else {
                    StringBuilder warningMessage = new StringBuilder("Cannot find feature path ");
                    warningMessage.append(propertyPath);
                    warningMessage.append(" for EClass ");
                    warningMessage.append(this.source.eClass());
                    Activator.log.warn(warningMessage.toString());
                    return null;
                }
            }
            ++n2;
        }
        return FeaturePath.fromList((EStructuralFeature[])features);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature == null) {
            return super.getContentProvider(propertyPath);
        }
        return new UMLContentProvider(this.source, feature, this.stereotype);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        EClassifier featureType;
        EReference reference;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature != null && feature instanceof EReference && (reference = (EReference)feature).isContainment() && (featureType = feature.getEType()) instanceof EClass && DataTypeUtil.isDataTypeDefinition((EClass)((EClass)featureType), (EObject)this.getSource())) {
            return new EObjectStructuredValueFactory(reference);
        }
        return super.getValueFactory(propertyPath);
    }

    public String getLabel(String propertyPath) {
        Property property;
        String result = null;
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        if (feature != null && (property = StereotypeUtil.getPropertyByName((Stereotype)this.stereotype, (String)feature.getName())) instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)property;
            String name = namedElement.getName();
            String label = namedElement.getLabel();
            if (!label.equals(name)) {
                result = label;
            }
        }
        return result;
    }
}

