/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.utils.DeleteActionUtil;

public class DeleteFromModelCommandHandler
extends AbstractGraphicalCommandHandler
implements IHandler {
    private static final String COMMAND_LABEL = "Delete From Model";

    @Override
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, COMMAND_LABEL);
        for (IGraphicalEditPart editPart : editParts) {
            Command curCommand = DeleteActionUtil.getDeleteFromModelCommand(editPart, editingDomain);
            if (curCommand == null || !curCommand.canExecute()) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    @Override
    protected boolean computeEnabled() {
        boolean enable = true;
        List<IGraphicalEditPart> selectedElement = this.getSelectedElements();
        Iterator<IGraphicalEditPart> iteratorSelection = selectedElement.iterator();
        while (iteratorSelection.hasNext() && enable) {
            IGraphicalEditPart editPart = iteratorSelection.next();
            boolean bl = enable = enable && !(editPart instanceof DiagramEditPart) && DeleteActionUtil.isSemanticDeletion(editPart);
        }
        return enable;
    }
}

